/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.AnnotationSpec;
import com.google.cloud.aiplatform.v1.CreateDatasetOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateDatasetRequest;
import com.google.cloud.aiplatform.v1.CreateDatasetVersionOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateDatasetVersionRequest;
import com.google.cloud.aiplatform.v1.Dataset;
import com.google.cloud.aiplatform.v1.DatasetServiceClient;
import com.google.cloud.aiplatform.v1.DatasetVersion;
import com.google.cloud.aiplatform.v1.DeleteDatasetRequest;
import com.google.cloud.aiplatform.v1.DeleteDatasetVersionRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.DeleteSavedQueryRequest;
import com.google.cloud.aiplatform.v1.ExportDataOperationMetadata;
import com.google.cloud.aiplatform.v1.ExportDataRequest;
import com.google.cloud.aiplatform.v1.ExportDataResponse;
import com.google.cloud.aiplatform.v1.GetAnnotationSpecRequest;
import com.google.cloud.aiplatform.v1.GetDatasetRequest;
import com.google.cloud.aiplatform.v1.GetDatasetVersionRequest;
import com.google.cloud.aiplatform.v1.ImportDataOperationMetadata;
import com.google.cloud.aiplatform.v1.ImportDataRequest;
import com.google.cloud.aiplatform.v1.ImportDataResponse;
import com.google.cloud.aiplatform.v1.ListAnnotationsRequest;
import com.google.cloud.aiplatform.v1.ListAnnotationsResponse;
import com.google.cloud.aiplatform.v1.ListDataItemsRequest;
import com.google.cloud.aiplatform.v1.ListDataItemsResponse;
import com.google.cloud.aiplatform.v1.ListDatasetVersionsRequest;
import com.google.cloud.aiplatform.v1.ListDatasetVersionsResponse;
import com.google.cloud.aiplatform.v1.ListDatasetsRequest;
import com.google.cloud.aiplatform.v1.ListDatasetsResponse;
import com.google.cloud.aiplatform.v1.ListSavedQueriesRequest;
import com.google.cloud.aiplatform.v1.ListSavedQueriesResponse;
import com.google.cloud.aiplatform.v1.RestoreDatasetVersionOperationMetadata;
import com.google.cloud.aiplatform.v1.RestoreDatasetVersionRequest;
import com.google.cloud.aiplatform.v1.SearchDataItemsRequest;
import com.google.cloud.aiplatform.v1.SearchDataItemsResponse;
import com.google.cloud.aiplatform.v1.UpdateDatasetRequest;
import com.google.cloud.aiplatform.v1.UpdateDatasetVersionRequest;
import com.google.cloud.aiplatform.v1.stub.DatasetServiceStub;
import com.google.cloud.aiplatform.v1.stub.DatasetServiceStubSettings;
import com.google.cloud.aiplatform.v1.stub.GrpcDatasetServiceCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcDatasetServiceStub
extends DatasetServiceStub {
    private static final MethodDescriptor<CreateDatasetRequest, Operation> createDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/CreateDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetDatasetRequest, Dataset> getDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/GetDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Dataset.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateDatasetRequest, Dataset> updateDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/UpdateDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Dataset.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListDatasetsRequest, ListDatasetsResponse> listDatasetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/ListDatasets").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDatasetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDatasetsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteDatasetRequest, Operation> deleteDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/DeleteDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ImportDataRequest, Operation> importDataMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/ImportData").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportDataRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ExportDataRequest, Operation> exportDataMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/ExportData").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportDataRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateDatasetVersionRequest, Operation> createDatasetVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/CreateDatasetVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateDatasetVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateDatasetVersionRequest, DatasetVersion> updateDatasetVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/UpdateDatasetVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateDatasetVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DatasetVersion.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteDatasetVersionRequest, Operation> deleteDatasetVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/DeleteDatasetVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteDatasetVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetDatasetVersionRequest, DatasetVersion> getDatasetVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/GetDatasetVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDatasetVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DatasetVersion.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListDatasetVersionsRequest, ListDatasetVersionsResponse> listDatasetVersionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/ListDatasetVersions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDatasetVersionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDatasetVersionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<RestoreDatasetVersionRequest, Operation> restoreDatasetVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/RestoreDatasetVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)RestoreDatasetVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListDataItemsRequest, ListDataItemsResponse> listDataItemsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/ListDataItems").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDataItemsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDataItemsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SearchDataItemsRequest, SearchDataItemsResponse> searchDataItemsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/SearchDataItems").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchDataItemsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchDataItemsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListSavedQueriesRequest, ListSavedQueriesResponse> listSavedQueriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/ListSavedQueries").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSavedQueriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSavedQueriesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteSavedQueryRequest, Operation> deleteSavedQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/DeleteSavedQuery").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSavedQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/GetAnnotationSpec").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAnnotationSpecRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AnnotationSpec.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListAnnotationsRequest, ListAnnotationsResponse> listAnnotationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.DatasetService/ListAnnotations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAnnotationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAnnotationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateDatasetRequest, Operation> createDatasetCallable;
    private final OperationCallable<CreateDatasetRequest, Dataset, CreateDatasetOperationMetadata> createDatasetOperationCallable;
    private final UnaryCallable<GetDatasetRequest, Dataset> getDatasetCallable;
    private final UnaryCallable<UpdateDatasetRequest, Dataset> updateDatasetCallable;
    private final UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> listDatasetsCallable;
    private final UnaryCallable<ListDatasetsRequest, DatasetServiceClient.ListDatasetsPagedResponse> listDatasetsPagedCallable;
    private final UnaryCallable<DeleteDatasetRequest, Operation> deleteDatasetCallable;
    private final OperationCallable<DeleteDatasetRequest, Empty, DeleteOperationMetadata> deleteDatasetOperationCallable;
    private final UnaryCallable<ImportDataRequest, Operation> importDataCallable;
    private final OperationCallable<ImportDataRequest, ImportDataResponse, ImportDataOperationMetadata> importDataOperationCallable;
    private final UnaryCallable<ExportDataRequest, Operation> exportDataCallable;
    private final OperationCallable<ExportDataRequest, ExportDataResponse, ExportDataOperationMetadata> exportDataOperationCallable;
    private final UnaryCallable<CreateDatasetVersionRequest, Operation> createDatasetVersionCallable;
    private final OperationCallable<CreateDatasetVersionRequest, DatasetVersion, CreateDatasetVersionOperationMetadata> createDatasetVersionOperationCallable;
    private final UnaryCallable<UpdateDatasetVersionRequest, DatasetVersion> updateDatasetVersionCallable;
    private final UnaryCallable<DeleteDatasetVersionRequest, Operation> deleteDatasetVersionCallable;
    private final OperationCallable<DeleteDatasetVersionRequest, Empty, DeleteOperationMetadata> deleteDatasetVersionOperationCallable;
    private final UnaryCallable<GetDatasetVersionRequest, DatasetVersion> getDatasetVersionCallable;
    private final UnaryCallable<ListDatasetVersionsRequest, ListDatasetVersionsResponse> listDatasetVersionsCallable;
    private final UnaryCallable<ListDatasetVersionsRequest, DatasetServiceClient.ListDatasetVersionsPagedResponse> listDatasetVersionsPagedCallable;
    private final UnaryCallable<RestoreDatasetVersionRequest, Operation> restoreDatasetVersionCallable;
    private final OperationCallable<RestoreDatasetVersionRequest, DatasetVersion, RestoreDatasetVersionOperationMetadata> restoreDatasetVersionOperationCallable;
    private final UnaryCallable<ListDataItemsRequest, ListDataItemsResponse> listDataItemsCallable;
    private final UnaryCallable<ListDataItemsRequest, DatasetServiceClient.ListDataItemsPagedResponse> listDataItemsPagedCallable;
    private final UnaryCallable<SearchDataItemsRequest, SearchDataItemsResponse> searchDataItemsCallable;
    private final UnaryCallable<SearchDataItemsRequest, DatasetServiceClient.SearchDataItemsPagedResponse> searchDataItemsPagedCallable;
    private final UnaryCallable<ListSavedQueriesRequest, ListSavedQueriesResponse> listSavedQueriesCallable;
    private final UnaryCallable<ListSavedQueriesRequest, DatasetServiceClient.ListSavedQueriesPagedResponse> listSavedQueriesPagedCallable;
    private final UnaryCallable<DeleteSavedQueryRequest, Operation> deleteSavedQueryCallable;
    private final OperationCallable<DeleteSavedQueryRequest, Empty, DeleteOperationMetadata> deleteSavedQueryOperationCallable;
    private final UnaryCallable<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecCallable;
    private final UnaryCallable<ListAnnotationsRequest, ListAnnotationsResponse> listAnnotationsCallable;
    private final UnaryCallable<ListAnnotationsRequest, DatasetServiceClient.ListAnnotationsPagedResponse> listAnnotationsPagedCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, DatasetServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDatasetServiceStub create(DatasetServiceStubSettings settings) throws IOException {
        return new GrpcDatasetServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDatasetServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcDatasetServiceStub(DatasetServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDatasetServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDatasetServiceStub(DatasetServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDatasetServiceStub(DatasetServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDatasetServiceCallableFactory());
    }

    protected GrpcDatasetServiceStub(DatasetServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createDatasetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDatasetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDatasetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("dataset.name", String.valueOf(request.getDataset().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listDatasetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDatasetsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteDatasetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings importDataTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importDataMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings exportDataTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportDataMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createDatasetVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createDatasetVersionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateDatasetVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDatasetVersionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("dataset_version.name", String.valueOf(request.getDatasetVersion().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteDatasetVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteDatasetVersionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getDatasetVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDatasetVersionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listDatasetVersionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDatasetVersionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings restoreDatasetVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(restoreDatasetVersionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listDataItemsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDataItemsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings searchDataItemsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchDataItemsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("dataset", String.valueOf(request.getDataset()));
            return builder.build();
        }).build();
        GrpcCallSettings listSavedQueriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSavedQueriesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteSavedQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSavedQueryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getAnnotationSpecTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAnnotationSpecMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listAnnotationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAnnotationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createDatasetCallable = callableFactory.createUnaryCallable(createDatasetTransportSettings, settings.createDatasetSettings(), clientContext);
        this.createDatasetOperationCallable = callableFactory.createOperationCallable(createDatasetTransportSettings, settings.createDatasetOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getDatasetCallable = callableFactory.createUnaryCallable(getDatasetTransportSettings, settings.getDatasetSettings(), clientContext);
        this.updateDatasetCallable = callableFactory.createUnaryCallable(updateDatasetTransportSettings, settings.updateDatasetSettings(), clientContext);
        this.listDatasetsCallable = callableFactory.createUnaryCallable(listDatasetsTransportSettings, settings.listDatasetsSettings(), clientContext);
        this.listDatasetsPagedCallable = callableFactory.createPagedCallable(listDatasetsTransportSettings, settings.listDatasetsSettings(), clientContext);
        this.deleteDatasetCallable = callableFactory.createUnaryCallable(deleteDatasetTransportSettings, settings.deleteDatasetSettings(), clientContext);
        this.deleteDatasetOperationCallable = callableFactory.createOperationCallable(deleteDatasetTransportSettings, settings.deleteDatasetOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.importDataCallable = callableFactory.createUnaryCallable(importDataTransportSettings, settings.importDataSettings(), clientContext);
        this.importDataOperationCallable = callableFactory.createOperationCallable(importDataTransportSettings, settings.importDataOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.exportDataCallable = callableFactory.createUnaryCallable(exportDataTransportSettings, settings.exportDataSettings(), clientContext);
        this.exportDataOperationCallable = callableFactory.createOperationCallable(exportDataTransportSettings, settings.exportDataOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.createDatasetVersionCallable = callableFactory.createUnaryCallable(createDatasetVersionTransportSettings, settings.createDatasetVersionSettings(), clientContext);
        this.createDatasetVersionOperationCallable = callableFactory.createOperationCallable(createDatasetVersionTransportSettings, settings.createDatasetVersionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateDatasetVersionCallable = callableFactory.createUnaryCallable(updateDatasetVersionTransportSettings, settings.updateDatasetVersionSettings(), clientContext);
        this.deleteDatasetVersionCallable = callableFactory.createUnaryCallable(deleteDatasetVersionTransportSettings, settings.deleteDatasetVersionSettings(), clientContext);
        this.deleteDatasetVersionOperationCallable = callableFactory.createOperationCallable(deleteDatasetVersionTransportSettings, settings.deleteDatasetVersionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getDatasetVersionCallable = callableFactory.createUnaryCallable(getDatasetVersionTransportSettings, settings.getDatasetVersionSettings(), clientContext);
        this.listDatasetVersionsCallable = callableFactory.createUnaryCallable(listDatasetVersionsTransportSettings, settings.listDatasetVersionsSettings(), clientContext);
        this.listDatasetVersionsPagedCallable = callableFactory.createPagedCallable(listDatasetVersionsTransportSettings, settings.listDatasetVersionsSettings(), clientContext);
        this.restoreDatasetVersionCallable = callableFactory.createUnaryCallable(restoreDatasetVersionTransportSettings, settings.restoreDatasetVersionSettings(), clientContext);
        this.restoreDatasetVersionOperationCallable = callableFactory.createOperationCallable(restoreDatasetVersionTransportSettings, settings.restoreDatasetVersionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listDataItemsCallable = callableFactory.createUnaryCallable(listDataItemsTransportSettings, settings.listDataItemsSettings(), clientContext);
        this.listDataItemsPagedCallable = callableFactory.createPagedCallable(listDataItemsTransportSettings, settings.listDataItemsSettings(), clientContext);
        this.searchDataItemsCallable = callableFactory.createUnaryCallable(searchDataItemsTransportSettings, settings.searchDataItemsSettings(), clientContext);
        this.searchDataItemsPagedCallable = callableFactory.createPagedCallable(searchDataItemsTransportSettings, settings.searchDataItemsSettings(), clientContext);
        this.listSavedQueriesCallable = callableFactory.createUnaryCallable(listSavedQueriesTransportSettings, settings.listSavedQueriesSettings(), clientContext);
        this.listSavedQueriesPagedCallable = callableFactory.createPagedCallable(listSavedQueriesTransportSettings, settings.listSavedQueriesSettings(), clientContext);
        this.deleteSavedQueryCallable = callableFactory.createUnaryCallable(deleteSavedQueryTransportSettings, settings.deleteSavedQuerySettings(), clientContext);
        this.deleteSavedQueryOperationCallable = callableFactory.createOperationCallable(deleteSavedQueryTransportSettings, settings.deleteSavedQueryOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getAnnotationSpecCallable = callableFactory.createUnaryCallable(getAnnotationSpecTransportSettings, settings.getAnnotationSpecSettings(), clientContext);
        this.listAnnotationsCallable = callableFactory.createUnaryCallable(listAnnotationsTransportSettings, settings.listAnnotationsSettings(), clientContext);
        this.listAnnotationsPagedCallable = callableFactory.createPagedCallable(listAnnotationsTransportSettings, settings.listAnnotationsSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateDatasetRequest, Operation> createDatasetCallable() {
        return this.createDatasetCallable;
    }

    @Override
    public OperationCallable<CreateDatasetRequest, Dataset, CreateDatasetOperationMetadata> createDatasetOperationCallable() {
        return this.createDatasetOperationCallable;
    }

    @Override
    public UnaryCallable<GetDatasetRequest, Dataset> getDatasetCallable() {
        return this.getDatasetCallable;
    }

    @Override
    public UnaryCallable<UpdateDatasetRequest, Dataset> updateDatasetCallable() {
        return this.updateDatasetCallable;
    }

    @Override
    public UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> listDatasetsCallable() {
        return this.listDatasetsCallable;
    }

    @Override
    public UnaryCallable<ListDatasetsRequest, DatasetServiceClient.ListDatasetsPagedResponse> listDatasetsPagedCallable() {
        return this.listDatasetsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteDatasetRequest, Operation> deleteDatasetCallable() {
        return this.deleteDatasetCallable;
    }

    @Override
    public OperationCallable<DeleteDatasetRequest, Empty, DeleteOperationMetadata> deleteDatasetOperationCallable() {
        return this.deleteDatasetOperationCallable;
    }

    @Override
    public UnaryCallable<ImportDataRequest, Operation> importDataCallable() {
        return this.importDataCallable;
    }

    @Override
    public OperationCallable<ImportDataRequest, ImportDataResponse, ImportDataOperationMetadata> importDataOperationCallable() {
        return this.importDataOperationCallable;
    }

    @Override
    public UnaryCallable<ExportDataRequest, Operation> exportDataCallable() {
        return this.exportDataCallable;
    }

    @Override
    public OperationCallable<ExportDataRequest, ExportDataResponse, ExportDataOperationMetadata> exportDataOperationCallable() {
        return this.exportDataOperationCallable;
    }

    @Override
    public UnaryCallable<CreateDatasetVersionRequest, Operation> createDatasetVersionCallable() {
        return this.createDatasetVersionCallable;
    }

    @Override
    public OperationCallable<CreateDatasetVersionRequest, DatasetVersion, CreateDatasetVersionOperationMetadata> createDatasetVersionOperationCallable() {
        return this.createDatasetVersionOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateDatasetVersionRequest, DatasetVersion> updateDatasetVersionCallable() {
        return this.updateDatasetVersionCallable;
    }

    @Override
    public UnaryCallable<DeleteDatasetVersionRequest, Operation> deleteDatasetVersionCallable() {
        return this.deleteDatasetVersionCallable;
    }

    @Override
    public OperationCallable<DeleteDatasetVersionRequest, Empty, DeleteOperationMetadata> deleteDatasetVersionOperationCallable() {
        return this.deleteDatasetVersionOperationCallable;
    }

    @Override
    public UnaryCallable<GetDatasetVersionRequest, DatasetVersion> getDatasetVersionCallable() {
        return this.getDatasetVersionCallable;
    }

    @Override
    public UnaryCallable<ListDatasetVersionsRequest, ListDatasetVersionsResponse> listDatasetVersionsCallable() {
        return this.listDatasetVersionsCallable;
    }

    @Override
    public UnaryCallable<ListDatasetVersionsRequest, DatasetServiceClient.ListDatasetVersionsPagedResponse> listDatasetVersionsPagedCallable() {
        return this.listDatasetVersionsPagedCallable;
    }

    @Override
    public UnaryCallable<RestoreDatasetVersionRequest, Operation> restoreDatasetVersionCallable() {
        return this.restoreDatasetVersionCallable;
    }

    @Override
    public OperationCallable<RestoreDatasetVersionRequest, DatasetVersion, RestoreDatasetVersionOperationMetadata> restoreDatasetVersionOperationCallable() {
        return this.restoreDatasetVersionOperationCallable;
    }

    @Override
    public UnaryCallable<ListDataItemsRequest, ListDataItemsResponse> listDataItemsCallable() {
        return this.listDataItemsCallable;
    }

    @Override
    public UnaryCallable<ListDataItemsRequest, DatasetServiceClient.ListDataItemsPagedResponse> listDataItemsPagedCallable() {
        return this.listDataItemsPagedCallable;
    }

    @Override
    public UnaryCallable<SearchDataItemsRequest, SearchDataItemsResponse> searchDataItemsCallable() {
        return this.searchDataItemsCallable;
    }

    @Override
    public UnaryCallable<SearchDataItemsRequest, DatasetServiceClient.SearchDataItemsPagedResponse> searchDataItemsPagedCallable() {
        return this.searchDataItemsPagedCallable;
    }

    @Override
    public UnaryCallable<ListSavedQueriesRequest, ListSavedQueriesResponse> listSavedQueriesCallable() {
        return this.listSavedQueriesCallable;
    }

    @Override
    public UnaryCallable<ListSavedQueriesRequest, DatasetServiceClient.ListSavedQueriesPagedResponse> listSavedQueriesPagedCallable() {
        return this.listSavedQueriesPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteSavedQueryRequest, Operation> deleteSavedQueryCallable() {
        return this.deleteSavedQueryCallable;
    }

    @Override
    public OperationCallable<DeleteSavedQueryRequest, Empty, DeleteOperationMetadata> deleteSavedQueryOperationCallable() {
        return this.deleteSavedQueryOperationCallable;
    }

    @Override
    public UnaryCallable<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecCallable() {
        return this.getAnnotationSpecCallable;
    }

    @Override
    public UnaryCallable<ListAnnotationsRequest, ListAnnotationsResponse> listAnnotationsCallable() {
        return this.listAnnotationsCallable;
    }

    @Override
    public UnaryCallable<ListAnnotationsRequest, DatasetServiceClient.ListAnnotationsPagedResponse> listAnnotationsPagedCallable() {
        return this.listAnnotationsPagedCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, DatasetServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

