/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.AppendEventRequest;
import com.google.cloud.aiplatform.v1beta1.AppendEventResponse;
import com.google.cloud.aiplatform.v1beta1.CreateSessionOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateSessionRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeleteSessionRequest;
import com.google.cloud.aiplatform.v1beta1.GetSessionRequest;
import com.google.cloud.aiplatform.v1beta1.ListEventsRequest;
import com.google.cloud.aiplatform.v1beta1.ListEventsResponse;
import com.google.cloud.aiplatform.v1beta1.ListSessionsRequest;
import com.google.cloud.aiplatform.v1beta1.ListSessionsResponse;
import com.google.cloud.aiplatform.v1beta1.Session;
import com.google.cloud.aiplatform.v1beta1.SessionEvent;
import com.google.cloud.aiplatform.v1beta1.SessionServiceClient;
import com.google.cloud.aiplatform.v1beta1.UpdateSessionRequest;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcSessionServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.SessionServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class SessionServiceStubSettings
extends StubSettings<SessionServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateSessionRequest, Operation> createSessionSettings;
    private final OperationCallSettings<CreateSessionRequest, Session, CreateSessionOperationMetadata> createSessionOperationSettings;
    private final UnaryCallSettings<GetSessionRequest, Session> getSessionSettings;
    private final PagedCallSettings<ListSessionsRequest, ListSessionsResponse, SessionServiceClient.ListSessionsPagedResponse> listSessionsSettings;
    private final UnaryCallSettings<UpdateSessionRequest, Session> updateSessionSettings;
    private final UnaryCallSettings<DeleteSessionRequest, Operation> deleteSessionSettings;
    private final OperationCallSettings<DeleteSessionRequest, Empty, DeleteOperationMetadata> deleteSessionOperationSettings;
    private final PagedCallSettings<ListEventsRequest, ListEventsResponse, SessionServiceClient.ListEventsPagedResponse> listEventsSettings;
    private final UnaryCallSettings<AppendEventRequest, AppendEventResponse> appendEventSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, SessionServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListSessionsRequest, ListSessionsResponse, Session> LIST_SESSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListSessionsRequest, ListSessionsResponse, Session>(){

        public String emptyToken() {
            return "";
        }

        public ListSessionsRequest injectToken(ListSessionsRequest payload, String token) {
            return ListSessionsRequest.newBuilder((ListSessionsRequest)payload).setPageToken(token).build();
        }

        public ListSessionsRequest injectPageSize(ListSessionsRequest payload, int pageSize) {
            return ListSessionsRequest.newBuilder((ListSessionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSessionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSessionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Session> extractResources(ListSessionsResponse payload) {
            return payload.getSessionsList();
        }
    };
    private static final PagedListDescriptor<ListEventsRequest, ListEventsResponse, SessionEvent> LIST_EVENTS_PAGE_STR_DESC = new PagedListDescriptor<ListEventsRequest, ListEventsResponse, SessionEvent>(){

        public String emptyToken() {
            return "";
        }

        public ListEventsRequest injectToken(ListEventsRequest payload, String token) {
            return ListEventsRequest.newBuilder((ListEventsRequest)payload).setPageToken(token).build();
        }

        public ListEventsRequest injectPageSize(ListEventsRequest payload, int pageSize) {
            return ListEventsRequest.newBuilder((ListEventsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEventsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEventsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SessionEvent> extractResources(ListEventsResponse payload) {
            return payload.getSessionEventsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListSessionsRequest, ListSessionsResponse, SessionServiceClient.ListSessionsPagedResponse> LIST_SESSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListSessionsRequest, ListSessionsResponse, SessionServiceClient.ListSessionsPagedResponse>(){

        public ApiFuture<SessionServiceClient.ListSessionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSessionsRequest, ListSessionsResponse> callable, ListSessionsRequest request, ApiCallContext context, ApiFuture<ListSessionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SESSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SessionServiceClient.ListSessionsPagedResponse.createAsync((PageContext<ListSessionsRequest, ListSessionsResponse, Session>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListEventsRequest, ListEventsResponse, SessionServiceClient.ListEventsPagedResponse> LIST_EVENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEventsRequest, ListEventsResponse, SessionServiceClient.ListEventsPagedResponse>(){

        public ApiFuture<SessionServiceClient.ListEventsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEventsRequest, ListEventsResponse> callable, ListEventsRequest request, ApiCallContext context, ApiFuture<ListEventsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EVENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SessionServiceClient.ListEventsPagedResponse.createAsync((PageContext<ListEventsRequest, ListEventsResponse, SessionEvent>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, SessionServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, SessionServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<SessionServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SessionServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateSessionRequest, Operation> createSessionSettings() {
        return this.createSessionSettings;
    }

    public OperationCallSettings<CreateSessionRequest, Session, CreateSessionOperationMetadata> createSessionOperationSettings() {
        return this.createSessionOperationSettings;
    }

    public UnaryCallSettings<GetSessionRequest, Session> getSessionSettings() {
        return this.getSessionSettings;
    }

    public PagedCallSettings<ListSessionsRequest, ListSessionsResponse, SessionServiceClient.ListSessionsPagedResponse> listSessionsSettings() {
        return this.listSessionsSettings;
    }

    public UnaryCallSettings<UpdateSessionRequest, Session> updateSessionSettings() {
        return this.updateSessionSettings;
    }

    public UnaryCallSettings<DeleteSessionRequest, Operation> deleteSessionSettings() {
        return this.deleteSessionSettings;
    }

    public OperationCallSettings<DeleteSessionRequest, Empty, DeleteOperationMetadata> deleteSessionOperationSettings() {
        return this.deleteSessionOperationSettings;
    }

    public PagedCallSettings<ListEventsRequest, ListEventsResponse, SessionServiceClient.ListEventsPagedResponse> listEventsSettings() {
        return this.listEventsSettings;
    }

    public UnaryCallSettings<AppendEventRequest, AppendEventResponse> appendEventSettings() {
        return this.appendEventSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, SessionServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public SessionServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSessionServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "aiplatform";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SessionServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SessionServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SessionServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createSessionSettings = settingsBuilder.createSessionSettings().build();
        this.createSessionOperationSettings = settingsBuilder.createSessionOperationSettings().build();
        this.getSessionSettings = settingsBuilder.getSessionSettings().build();
        this.listSessionsSettings = settingsBuilder.listSessionsSettings().build();
        this.updateSessionSettings = settingsBuilder.updateSessionSettings().build();
        this.deleteSessionSettings = settingsBuilder.deleteSessionSettings().build();
        this.deleteSessionOperationSettings = settingsBuilder.deleteSessionOperationSettings().build();
        this.listEventsSettings = settingsBuilder.listEventsSettings().build();
        this.appendEventSettings = settingsBuilder.appendEventSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SessionServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateSessionRequest, Operation> createSessionSettings;
        private final OperationCallSettings.Builder<CreateSessionRequest, Session, CreateSessionOperationMetadata> createSessionOperationSettings;
        private final UnaryCallSettings.Builder<GetSessionRequest, Session> getSessionSettings;
        private final PagedCallSettings.Builder<ListSessionsRequest, ListSessionsResponse, SessionServiceClient.ListSessionsPagedResponse> listSessionsSettings;
        private final UnaryCallSettings.Builder<UpdateSessionRequest, Session> updateSessionSettings;
        private final UnaryCallSettings.Builder<DeleteSessionRequest, Operation> deleteSessionSettings;
        private final OperationCallSettings.Builder<DeleteSessionRequest, Empty, DeleteOperationMetadata> deleteSessionOperationSettings;
        private final PagedCallSettings.Builder<ListEventsRequest, ListEventsResponse, SessionServiceClient.ListEventsPagedResponse> listEventsSettings;
        private final UnaryCallSettings.Builder<AppendEventRequest, AppendEventResponse> appendEventSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, SessionServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSessionOperationSettings = OperationCallSettings.newBuilder();
            this.getSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSessionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SESSIONS_PAGE_STR_FACT);
            this.updateSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSessionOperationSettings = OperationCallSettings.newBuilder();
            this.listEventsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EVENTS_PAGE_STR_FACT);
            this.appendEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSessionSettings, this.getSessionSettings, this.listSessionsSettings, this.updateSessionSettings, this.deleteSessionSettings, this.listEventsSettings, this.appendEventSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(SessionServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createSessionSettings = settings.createSessionSettings.toBuilder();
            this.createSessionOperationSettings = settings.createSessionOperationSettings.toBuilder();
            this.getSessionSettings = settings.getSessionSettings.toBuilder();
            this.listSessionsSettings = settings.listSessionsSettings.toBuilder();
            this.updateSessionSettings = settings.updateSessionSettings.toBuilder();
            this.deleteSessionSettings = settings.deleteSessionSettings.toBuilder();
            this.deleteSessionOperationSettings = settings.deleteSessionOperationSettings.toBuilder();
            this.listEventsSettings = settings.listEventsSettings.toBuilder();
            this.appendEventSettings = settings.appendEventSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSessionSettings, this.getSessionSettings, this.listSessionsSettings, this.updateSessionSettings, this.deleteSessionSettings, this.listEventsSettings, this.appendEventSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SessionServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SessionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SessionServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SessionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listSessionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listEventsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.appendEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createSessionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Session.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateSessionOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteSessionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateSessionRequest, Operation> createSessionSettings() {
            return this.createSessionSettings;
        }

        public OperationCallSettings.Builder<CreateSessionRequest, Session, CreateSessionOperationMetadata> createSessionOperationSettings() {
            return this.createSessionOperationSettings;
        }

        public UnaryCallSettings.Builder<GetSessionRequest, Session> getSessionSettings() {
            return this.getSessionSettings;
        }

        public PagedCallSettings.Builder<ListSessionsRequest, ListSessionsResponse, SessionServiceClient.ListSessionsPagedResponse> listSessionsSettings() {
            return this.listSessionsSettings;
        }

        public UnaryCallSettings.Builder<UpdateSessionRequest, Session> updateSessionSettings() {
            return this.updateSessionSettings;
        }

        public UnaryCallSettings.Builder<DeleteSessionRequest, Operation> deleteSessionSettings() {
            return this.deleteSessionSettings;
        }

        public OperationCallSettings.Builder<DeleteSessionRequest, Empty, DeleteOperationMetadata> deleteSessionOperationSettings() {
            return this.deleteSessionOperationSettings;
        }

        public PagedCallSettings.Builder<ListEventsRequest, ListEventsResponse, SessionServiceClient.ListEventsPagedResponse> listEventsSettings() {
            return this.listEventsSettings;
        }

        public UnaryCallSettings.Builder<AppendEventRequest, AppendEventResponse> appendEventSettings() {
            return this.appendEventSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, SessionServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public SessionServiceStubSettings build() throws IOException {
            return new SessionServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

