/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.DeleteExtensionRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.Extension;
import com.google.cloud.aiplatform.v1beta1.ExtensionRegistryServiceClient;
import com.google.cloud.aiplatform.v1beta1.GetExtensionRequest;
import com.google.cloud.aiplatform.v1beta1.ImportExtensionOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.ImportExtensionRequest;
import com.google.cloud.aiplatform.v1beta1.ListExtensionsRequest;
import com.google.cloud.aiplatform.v1beta1.ListExtensionsResponse;
import com.google.cloud.aiplatform.v1beta1.UpdateExtensionRequest;
import com.google.cloud.aiplatform.v1beta1.stub.ExtensionRegistryServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcExtensionRegistryServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class ExtensionRegistryServiceStubSettings
extends StubSettings<ExtensionRegistryServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<ImportExtensionRequest, Operation> importExtensionSettings;
    private final OperationCallSettings<ImportExtensionRequest, Extension, ImportExtensionOperationMetadata> importExtensionOperationSettings;
    private final UnaryCallSettings<GetExtensionRequest, Extension> getExtensionSettings;
    private final PagedCallSettings<ListExtensionsRequest, ListExtensionsResponse, ExtensionRegistryServiceClient.ListExtensionsPagedResponse> listExtensionsSettings;
    private final UnaryCallSettings<UpdateExtensionRequest, Extension> updateExtensionSettings;
    private final UnaryCallSettings<DeleteExtensionRequest, Operation> deleteExtensionSettings;
    private final OperationCallSettings<DeleteExtensionRequest, Empty, DeleteOperationMetadata> deleteExtensionOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ExtensionRegistryServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListExtensionsRequest, ListExtensionsResponse, Extension> LIST_EXTENSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListExtensionsRequest, ListExtensionsResponse, Extension>(){

        public String emptyToken() {
            return "";
        }

        public ListExtensionsRequest injectToken(ListExtensionsRequest payload, String token) {
            return ListExtensionsRequest.newBuilder((ListExtensionsRequest)payload).setPageToken(token).build();
        }

        public ListExtensionsRequest injectPageSize(ListExtensionsRequest payload, int pageSize) {
            return ListExtensionsRequest.newBuilder((ListExtensionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListExtensionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListExtensionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Extension> extractResources(ListExtensionsResponse payload) {
            return payload.getExtensionsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListExtensionsRequest, ListExtensionsResponse, ExtensionRegistryServiceClient.ListExtensionsPagedResponse> LIST_EXTENSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListExtensionsRequest, ListExtensionsResponse, ExtensionRegistryServiceClient.ListExtensionsPagedResponse>(){

        public ApiFuture<ExtensionRegistryServiceClient.ListExtensionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListExtensionsRequest, ListExtensionsResponse> callable, ListExtensionsRequest request, ApiCallContext context, ApiFuture<ListExtensionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EXTENSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ExtensionRegistryServiceClient.ListExtensionsPagedResponse.createAsync((PageContext<ListExtensionsRequest, ListExtensionsResponse, Extension>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ExtensionRegistryServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ExtensionRegistryServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<ExtensionRegistryServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ExtensionRegistryServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<ImportExtensionRequest, Operation> importExtensionSettings() {
        return this.importExtensionSettings;
    }

    public OperationCallSettings<ImportExtensionRequest, Extension, ImportExtensionOperationMetadata> importExtensionOperationSettings() {
        return this.importExtensionOperationSettings;
    }

    public UnaryCallSettings<GetExtensionRequest, Extension> getExtensionSettings() {
        return this.getExtensionSettings;
    }

    public PagedCallSettings<ListExtensionsRequest, ListExtensionsResponse, ExtensionRegistryServiceClient.ListExtensionsPagedResponse> listExtensionsSettings() {
        return this.listExtensionsSettings;
    }

    public UnaryCallSettings<UpdateExtensionRequest, Extension> updateExtensionSettings() {
        return this.updateExtensionSettings;
    }

    public UnaryCallSettings<DeleteExtensionRequest, Operation> deleteExtensionSettings() {
        return this.deleteExtensionSettings;
    }

    public OperationCallSettings<DeleteExtensionRequest, Empty, DeleteOperationMetadata> deleteExtensionOperationSettings() {
        return this.deleteExtensionOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ExtensionRegistryServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public ExtensionRegistryServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcExtensionRegistryServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "aiplatform";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ExtensionRegistryServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ExtensionRegistryServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ExtensionRegistryServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.importExtensionSettings = settingsBuilder.importExtensionSettings().build();
        this.importExtensionOperationSettings = settingsBuilder.importExtensionOperationSettings().build();
        this.getExtensionSettings = settingsBuilder.getExtensionSettings().build();
        this.listExtensionsSettings = settingsBuilder.listExtensionsSettings().build();
        this.updateExtensionSettings = settingsBuilder.updateExtensionSettings().build();
        this.deleteExtensionSettings = settingsBuilder.deleteExtensionSettings().build();
        this.deleteExtensionOperationSettings = settingsBuilder.deleteExtensionOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ExtensionRegistryServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ImportExtensionRequest, Operation> importExtensionSettings;
        private final OperationCallSettings.Builder<ImportExtensionRequest, Extension, ImportExtensionOperationMetadata> importExtensionOperationSettings;
        private final UnaryCallSettings.Builder<GetExtensionRequest, Extension> getExtensionSettings;
        private final PagedCallSettings.Builder<ListExtensionsRequest, ListExtensionsResponse, ExtensionRegistryServiceClient.ListExtensionsPagedResponse> listExtensionsSettings;
        private final UnaryCallSettings.Builder<UpdateExtensionRequest, Extension> updateExtensionSettings;
        private final UnaryCallSettings.Builder<DeleteExtensionRequest, Operation> deleteExtensionSettings;
        private final OperationCallSettings.Builder<DeleteExtensionRequest, Empty, DeleteOperationMetadata> deleteExtensionOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ExtensionRegistryServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.importExtensionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importExtensionOperationSettings = OperationCallSettings.newBuilder();
            this.getExtensionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listExtensionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EXTENSIONS_PAGE_STR_FACT);
            this.updateExtensionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteExtensionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteExtensionOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.importExtensionSettings, this.getExtensionSettings, this.listExtensionsSettings, this.updateExtensionSettings, this.deleteExtensionSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ExtensionRegistryServiceStubSettings settings) {
            super((StubSettings)settings);
            this.importExtensionSettings = settings.importExtensionSettings.toBuilder();
            this.importExtensionOperationSettings = settings.importExtensionOperationSettings.toBuilder();
            this.getExtensionSettings = settings.getExtensionSettings.toBuilder();
            this.listExtensionsSettings = settings.listExtensionsSettings.toBuilder();
            this.updateExtensionSettings = settings.updateExtensionSettings.toBuilder();
            this.deleteExtensionSettings = settings.deleteExtensionSettings.toBuilder();
            this.deleteExtensionOperationSettings = settings.deleteExtensionOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.importExtensionSettings, this.getExtensionSettings, this.listExtensionsSettings, this.updateExtensionSettings, this.deleteExtensionSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ExtensionRegistryServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ExtensionRegistryServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ExtensionRegistryServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ExtensionRegistryServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.importExtensionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getExtensionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listExtensionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateExtensionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteExtensionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.importExtensionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Extension.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportExtensionOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteExtensionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ImportExtensionRequest, Operation> importExtensionSettings() {
            return this.importExtensionSettings;
        }

        public OperationCallSettings.Builder<ImportExtensionRequest, Extension, ImportExtensionOperationMetadata> importExtensionOperationSettings() {
            return this.importExtensionOperationSettings;
        }

        public UnaryCallSettings.Builder<GetExtensionRequest, Extension> getExtensionSettings() {
            return this.getExtensionSettings;
        }

        public PagedCallSettings.Builder<ListExtensionsRequest, ListExtensionsResponse, ExtensionRegistryServiceClient.ListExtensionsPagedResponse> listExtensionsSettings() {
            return this.listExtensionsSettings;
        }

        public UnaryCallSettings.Builder<UpdateExtensionRequest, Extension> updateExtensionSettings() {
            return this.updateExtensionSettings;
        }

        public UnaryCallSettings.Builder<DeleteExtensionRequest, Operation> deleteExtensionSettings() {
            return this.deleteExtensionSettings;
        }

        public OperationCallSettings.Builder<DeleteExtensionRequest, Empty, DeleteOperationMetadata> deleteExtensionOperationSettings() {
            return this.deleteExtensionOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ExtensionRegistryServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public ExtensionRegistryServiceStubSettings build() throws IOException {
            return new ExtensionRegistryServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

