/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.DeleteExtensionRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.Extension;
import com.google.cloud.aiplatform.v1beta1.ExtensionRegistryServiceClient;
import com.google.cloud.aiplatform.v1beta1.GetExtensionRequest;
import com.google.cloud.aiplatform.v1beta1.ImportExtensionOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.ImportExtensionRequest;
import com.google.cloud.aiplatform.v1beta1.ListExtensionsRequest;
import com.google.cloud.aiplatform.v1beta1.ListExtensionsResponse;
import com.google.cloud.aiplatform.v1beta1.UpdateExtensionRequest;
import com.google.cloud.aiplatform.v1beta1.stub.ExtensionRegistryServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.ExtensionRegistryServiceStubSettings;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcExtensionRegistryServiceCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcExtensionRegistryServiceStub
extends ExtensionRegistryServiceStub {
    private static final MethodDescriptor<ImportExtensionRequest, Operation> importExtensionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ExtensionRegistryService/ImportExtension").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportExtensionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetExtensionRequest, Extension> getExtensionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ExtensionRegistryService/GetExtension").setRequestMarshaller(ProtoUtils.marshaller((Message)GetExtensionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Extension.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListExtensionsRequest, ListExtensionsResponse> listExtensionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ExtensionRegistryService/ListExtensions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListExtensionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListExtensionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateExtensionRequest, Extension> updateExtensionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ExtensionRegistryService/UpdateExtension").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateExtensionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Extension.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteExtensionRequest, Operation> deleteExtensionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ExtensionRegistryService/DeleteExtension").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteExtensionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ImportExtensionRequest, Operation> importExtensionCallable;
    private final OperationCallable<ImportExtensionRequest, Extension, ImportExtensionOperationMetadata> importExtensionOperationCallable;
    private final UnaryCallable<GetExtensionRequest, Extension> getExtensionCallable;
    private final UnaryCallable<ListExtensionsRequest, ListExtensionsResponse> listExtensionsCallable;
    private final UnaryCallable<ListExtensionsRequest, ExtensionRegistryServiceClient.ListExtensionsPagedResponse> listExtensionsPagedCallable;
    private final UnaryCallable<UpdateExtensionRequest, Extension> updateExtensionCallable;
    private final UnaryCallable<DeleteExtensionRequest, Operation> deleteExtensionCallable;
    private final OperationCallable<DeleteExtensionRequest, Empty, DeleteOperationMetadata> deleteExtensionOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ExtensionRegistryServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcExtensionRegistryServiceStub create(ExtensionRegistryServiceStubSettings settings) throws IOException {
        return new GrpcExtensionRegistryServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcExtensionRegistryServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcExtensionRegistryServiceStub(ExtensionRegistryServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcExtensionRegistryServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcExtensionRegistryServiceStub(ExtensionRegistryServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcExtensionRegistryServiceStub(ExtensionRegistryServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcExtensionRegistryServiceCallableFactory());
    }

    protected GrpcExtensionRegistryServiceStub(ExtensionRegistryServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings importExtensionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importExtensionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getExtensionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getExtensionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listExtensionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listExtensionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateExtensionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateExtensionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("extension.name", String.valueOf(request.getExtension().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteExtensionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteExtensionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.importExtensionCallable = callableFactory.createUnaryCallable(importExtensionTransportSettings, settings.importExtensionSettings(), clientContext);
        this.importExtensionOperationCallable = callableFactory.createOperationCallable(importExtensionTransportSettings, settings.importExtensionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getExtensionCallable = callableFactory.createUnaryCallable(getExtensionTransportSettings, settings.getExtensionSettings(), clientContext);
        this.listExtensionsCallable = callableFactory.createUnaryCallable(listExtensionsTransportSettings, settings.listExtensionsSettings(), clientContext);
        this.listExtensionsPagedCallable = callableFactory.createPagedCallable(listExtensionsTransportSettings, settings.listExtensionsSettings(), clientContext);
        this.updateExtensionCallable = callableFactory.createUnaryCallable(updateExtensionTransportSettings, settings.updateExtensionSettings(), clientContext);
        this.deleteExtensionCallable = callableFactory.createUnaryCallable(deleteExtensionTransportSettings, settings.deleteExtensionSettings(), clientContext);
        this.deleteExtensionOperationCallable = callableFactory.createOperationCallable(deleteExtensionTransportSettings, settings.deleteExtensionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ImportExtensionRequest, Operation> importExtensionCallable() {
        return this.importExtensionCallable;
    }

    @Override
    public OperationCallable<ImportExtensionRequest, Extension, ImportExtensionOperationMetadata> importExtensionOperationCallable() {
        return this.importExtensionOperationCallable;
    }

    @Override
    public UnaryCallable<GetExtensionRequest, Extension> getExtensionCallable() {
        return this.getExtensionCallable;
    }

    @Override
    public UnaryCallable<ListExtensionsRequest, ListExtensionsResponse> listExtensionsCallable() {
        return this.listExtensionsCallable;
    }

    @Override
    public UnaryCallable<ListExtensionsRequest, ExtensionRegistryServiceClient.ListExtensionsPagedResponse> listExtensionsPagedCallable() {
        return this.listExtensionsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateExtensionRequest, Extension> updateExtensionCallable() {
        return this.updateExtensionCallable;
    }

    @Override
    public UnaryCallable<DeleteExtensionRequest, Operation> deleteExtensionCallable() {
        return this.deleteExtensionCallable;
    }

    @Override
    public OperationCallable<DeleteExtensionRequest, Empty, DeleteOperationMetadata> deleteExtensionOperationCallable() {
        return this.deleteExtensionOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ExtensionRegistryServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

