/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.CreateFeatureGroupOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateFeatureGroupRequest;
import com.google.cloud.aiplatform.v1.CreateFeatureOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateFeatureRequest;
import com.google.cloud.aiplatform.v1.DeleteFeatureGroupRequest;
import com.google.cloud.aiplatform.v1.DeleteFeatureRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.EntityTypeName;
import com.google.cloud.aiplatform.v1.Feature;
import com.google.cloud.aiplatform.v1.FeatureGroup;
import com.google.cloud.aiplatform.v1.FeatureGroupName;
import com.google.cloud.aiplatform.v1.FeatureName;
import com.google.cloud.aiplatform.v1.FeatureRegistryServiceSettings;
import com.google.cloud.aiplatform.v1.GetFeatureGroupRequest;
import com.google.cloud.aiplatform.v1.GetFeatureRequest;
import com.google.cloud.aiplatform.v1.ListFeatureGroupsRequest;
import com.google.cloud.aiplatform.v1.ListFeatureGroupsResponse;
import com.google.cloud.aiplatform.v1.ListFeaturesRequest;
import com.google.cloud.aiplatform.v1.ListFeaturesResponse;
import com.google.cloud.aiplatform.v1.LocationName;
import com.google.cloud.aiplatform.v1.UpdateFeatureGroupOperationMetadata;
import com.google.cloud.aiplatform.v1.UpdateFeatureGroupRequest;
import com.google.cloud.aiplatform.v1.UpdateFeatureOperationMetadata;
import com.google.cloud.aiplatform.v1.UpdateFeatureRequest;
import com.google.cloud.aiplatform.v1.stub.FeatureRegistryServiceStub;
import com.google.cloud.aiplatform.v1.stub.FeatureRegistryServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FeatureRegistryServiceClient
implements BackgroundResource {
    private final FeatureRegistryServiceSettings settings;
    private final FeatureRegistryServiceStub stub;
    private final OperationsClient operationsClient;

    public static final FeatureRegistryServiceClient create() throws IOException {
        return FeatureRegistryServiceClient.create(FeatureRegistryServiceSettings.newBuilder().build());
    }

    public static final FeatureRegistryServiceClient create(FeatureRegistryServiceSettings settings) throws IOException {
        return new FeatureRegistryServiceClient(settings);
    }

    public static final FeatureRegistryServiceClient create(FeatureRegistryServiceStub stub) {
        return new FeatureRegistryServiceClient(stub);
    }

    protected FeatureRegistryServiceClient(FeatureRegistryServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FeatureRegistryServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected FeatureRegistryServiceClient(FeatureRegistryServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final FeatureRegistryServiceSettings getSettings() {
        return this.settings;
    }

    public FeatureRegistryServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<FeatureGroup, CreateFeatureGroupOperationMetadata> createFeatureGroupAsync(LocationName parent, FeatureGroup featureGroup, String featureGroupId) {
        CreateFeatureGroupRequest request = CreateFeatureGroupRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFeatureGroup(featureGroup).setFeatureGroupId(featureGroupId).build();
        return this.createFeatureGroupAsync(request);
    }

    public final OperationFuture<FeatureGroup, CreateFeatureGroupOperationMetadata> createFeatureGroupAsync(String parent, FeatureGroup featureGroup, String featureGroupId) {
        CreateFeatureGroupRequest request = CreateFeatureGroupRequest.newBuilder().setParent(parent).setFeatureGroup(featureGroup).setFeatureGroupId(featureGroupId).build();
        return this.createFeatureGroupAsync(request);
    }

    public final OperationFuture<FeatureGroup, CreateFeatureGroupOperationMetadata> createFeatureGroupAsync(CreateFeatureGroupRequest request) {
        return this.createFeatureGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateFeatureGroupRequest, FeatureGroup, CreateFeatureGroupOperationMetadata> createFeatureGroupOperationCallable() {
        return this.stub.createFeatureGroupOperationCallable();
    }

    public final UnaryCallable<CreateFeatureGroupRequest, Operation> createFeatureGroupCallable() {
        return this.stub.createFeatureGroupCallable();
    }

    public final FeatureGroup getFeatureGroup(FeatureGroupName name) {
        GetFeatureGroupRequest request = GetFeatureGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFeatureGroup(request);
    }

    public final FeatureGroup getFeatureGroup(String name) {
        GetFeatureGroupRequest request = GetFeatureGroupRequest.newBuilder().setName(name).build();
        return this.getFeatureGroup(request);
    }

    public final FeatureGroup getFeatureGroup(GetFeatureGroupRequest request) {
        return (FeatureGroup)this.getFeatureGroupCallable().call((Object)request);
    }

    public final UnaryCallable<GetFeatureGroupRequest, FeatureGroup> getFeatureGroupCallable() {
        return this.stub.getFeatureGroupCallable();
    }

    public final ListFeatureGroupsPagedResponse listFeatureGroups(LocationName parent) {
        ListFeatureGroupsRequest request = ListFeatureGroupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFeatureGroups(request);
    }

    public final ListFeatureGroupsPagedResponse listFeatureGroups(String parent) {
        ListFeatureGroupsRequest request = ListFeatureGroupsRequest.newBuilder().setParent(parent).build();
        return this.listFeatureGroups(request);
    }

    public final ListFeatureGroupsPagedResponse listFeatureGroups(ListFeatureGroupsRequest request) {
        return (ListFeatureGroupsPagedResponse)((Object)this.listFeatureGroupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFeatureGroupsRequest, ListFeatureGroupsPagedResponse> listFeatureGroupsPagedCallable() {
        return this.stub.listFeatureGroupsPagedCallable();
    }

    public final UnaryCallable<ListFeatureGroupsRequest, ListFeatureGroupsResponse> listFeatureGroupsCallable() {
        return this.stub.listFeatureGroupsCallable();
    }

    public final OperationFuture<FeatureGroup, UpdateFeatureGroupOperationMetadata> updateFeatureGroupAsync(FeatureGroup featureGroup, FieldMask updateMask) {
        UpdateFeatureGroupRequest request = UpdateFeatureGroupRequest.newBuilder().setFeatureGroup(featureGroup).setUpdateMask(updateMask).build();
        return this.updateFeatureGroupAsync(request);
    }

    public final OperationFuture<FeatureGroup, UpdateFeatureGroupOperationMetadata> updateFeatureGroupAsync(UpdateFeatureGroupRequest request) {
        return this.updateFeatureGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateFeatureGroupRequest, FeatureGroup, UpdateFeatureGroupOperationMetadata> updateFeatureGroupOperationCallable() {
        return this.stub.updateFeatureGroupOperationCallable();
    }

    public final UnaryCallable<UpdateFeatureGroupRequest, Operation> updateFeatureGroupCallable() {
        return this.stub.updateFeatureGroupCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteFeatureGroupAsync(FeatureGroupName name, boolean force) {
        DeleteFeatureGroupRequest request = DeleteFeatureGroupRequest.newBuilder().setName(name == null ? null : name.toString()).setForce(force).build();
        return this.deleteFeatureGroupAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteFeatureGroupAsync(String name, boolean force) {
        DeleteFeatureGroupRequest request = DeleteFeatureGroupRequest.newBuilder().setName(name).setForce(force).build();
        return this.deleteFeatureGroupAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteFeatureGroupAsync(DeleteFeatureGroupRequest request) {
        return this.deleteFeatureGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteFeatureGroupRequest, Empty, DeleteOperationMetadata> deleteFeatureGroupOperationCallable() {
        return this.stub.deleteFeatureGroupOperationCallable();
    }

    public final UnaryCallable<DeleteFeatureGroupRequest, Operation> deleteFeatureGroupCallable() {
        return this.stub.deleteFeatureGroupCallable();
    }

    public final OperationFuture<Feature, CreateFeatureOperationMetadata> createFeatureAsync(EntityTypeName parent, Feature feature, String featureId) {
        CreateFeatureRequest request = CreateFeatureRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFeature(feature).setFeatureId(featureId).build();
        return this.createFeatureAsync(request);
    }

    public final OperationFuture<Feature, CreateFeatureOperationMetadata> createFeatureAsync(FeatureGroupName parent, Feature feature, String featureId) {
        CreateFeatureRequest request = CreateFeatureRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFeature(feature).setFeatureId(featureId).build();
        return this.createFeatureAsync(request);
    }

    public final OperationFuture<Feature, CreateFeatureOperationMetadata> createFeatureAsync(String parent, Feature feature, String featureId) {
        CreateFeatureRequest request = CreateFeatureRequest.newBuilder().setParent(parent).setFeature(feature).setFeatureId(featureId).build();
        return this.createFeatureAsync(request);
    }

    public final OperationFuture<Feature, CreateFeatureOperationMetadata> createFeatureAsync(CreateFeatureRequest request) {
        return this.createFeatureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateFeatureRequest, Feature, CreateFeatureOperationMetadata> createFeatureOperationCallable() {
        return this.stub.createFeatureOperationCallable();
    }

    public final UnaryCallable<CreateFeatureRequest, Operation> createFeatureCallable() {
        return this.stub.createFeatureCallable();
    }

    public final Feature getFeature(FeatureName name) {
        GetFeatureRequest request = GetFeatureRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFeature(request);
    }

    public final Feature getFeature(String name) {
        GetFeatureRequest request = GetFeatureRequest.newBuilder().setName(name).build();
        return this.getFeature(request);
    }

    public final Feature getFeature(GetFeatureRequest request) {
        return (Feature)this.getFeatureCallable().call((Object)request);
    }

    public final UnaryCallable<GetFeatureRequest, Feature> getFeatureCallable() {
        return this.stub.getFeatureCallable();
    }

    public final ListFeaturesPagedResponse listFeatures(EntityTypeName parent) {
        ListFeaturesRequest request = ListFeaturesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFeatures(request);
    }

    public final ListFeaturesPagedResponse listFeatures(FeatureGroupName parent) {
        ListFeaturesRequest request = ListFeaturesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFeatures(request);
    }

    public final ListFeaturesPagedResponse listFeatures(String parent) {
        ListFeaturesRequest request = ListFeaturesRequest.newBuilder().setParent(parent).build();
        return this.listFeatures(request);
    }

    public final ListFeaturesPagedResponse listFeatures(ListFeaturesRequest request) {
        return (ListFeaturesPagedResponse)((Object)this.listFeaturesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFeaturesRequest, ListFeaturesPagedResponse> listFeaturesPagedCallable() {
        return this.stub.listFeaturesPagedCallable();
    }

    public final UnaryCallable<ListFeaturesRequest, ListFeaturesResponse> listFeaturesCallable() {
        return this.stub.listFeaturesCallable();
    }

    public final OperationFuture<Feature, UpdateFeatureOperationMetadata> updateFeatureAsync(Feature feature, FieldMask updateMask) {
        UpdateFeatureRequest request = UpdateFeatureRequest.newBuilder().setFeature(feature).setUpdateMask(updateMask).build();
        return this.updateFeatureAsync(request);
    }

    public final OperationFuture<Feature, UpdateFeatureOperationMetadata> updateFeatureAsync(UpdateFeatureRequest request) {
        return this.updateFeatureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateFeatureRequest, Feature, UpdateFeatureOperationMetadata> updateFeatureOperationCallable() {
        return this.stub.updateFeatureOperationCallable();
    }

    public final UnaryCallable<UpdateFeatureRequest, Operation> updateFeatureCallable() {
        return this.stub.updateFeatureCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteFeatureAsync(FeatureName name) {
        DeleteFeatureRequest request = DeleteFeatureRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteFeatureAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteFeatureAsync(String name) {
        DeleteFeatureRequest request = DeleteFeatureRequest.newBuilder().setName(name).build();
        return this.deleteFeatureAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteFeatureAsync(DeleteFeatureRequest request) {
        return this.deleteFeatureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteFeatureRequest, Empty, DeleteOperationMetadata> deleteFeatureOperationCallable() {
        return this.stub.deleteFeatureOperationCallable();
    }

    public final UnaryCallable<DeleteFeatureRequest, Operation> deleteFeatureCallable() {
        return this.stub.deleteFeatureCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFeaturesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFeaturesRequest, ListFeaturesResponse, Feature, ListFeaturesPage, ListFeaturesFixedSizeCollection> {
        private ListFeaturesFixedSizeCollection(List<ListFeaturesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFeaturesFixedSizeCollection createEmptyCollection() {
            return new ListFeaturesFixedSizeCollection(null, 0);
        }

        protected ListFeaturesFixedSizeCollection createCollection(List<ListFeaturesPage> pages, int collectionSize) {
            return new ListFeaturesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFeaturesPage
    extends AbstractPage<ListFeaturesRequest, ListFeaturesResponse, Feature, ListFeaturesPage> {
        private ListFeaturesPage(PageContext<ListFeaturesRequest, ListFeaturesResponse, Feature> context, ListFeaturesResponse response) {
            super(context, (Object)response);
        }

        private static ListFeaturesPage createEmptyPage() {
            return new ListFeaturesPage(null, null);
        }

        protected ListFeaturesPage createPage(PageContext<ListFeaturesRequest, ListFeaturesResponse, Feature> context, ListFeaturesResponse response) {
            return new ListFeaturesPage(context, response);
        }

        public ApiFuture<ListFeaturesPage> createPageAsync(PageContext<ListFeaturesRequest, ListFeaturesResponse, Feature> context, ApiFuture<ListFeaturesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFeaturesPagedResponse
    extends AbstractPagedListResponse<ListFeaturesRequest, ListFeaturesResponse, Feature, ListFeaturesPage, ListFeaturesFixedSizeCollection> {
        public static ApiFuture<ListFeaturesPagedResponse> createAsync(PageContext<ListFeaturesRequest, ListFeaturesResponse, Feature> context, ApiFuture<ListFeaturesResponse> futureResponse) {
            ApiFuture<ListFeaturesPage> futurePage = ListFeaturesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFeaturesPagedResponse((ListFeaturesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListFeaturesPagedResponse(ListFeaturesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFeaturesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFeatureGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFeatureGroupsRequest, ListFeatureGroupsResponse, FeatureGroup, ListFeatureGroupsPage, ListFeatureGroupsFixedSizeCollection> {
        private ListFeatureGroupsFixedSizeCollection(List<ListFeatureGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFeatureGroupsFixedSizeCollection createEmptyCollection() {
            return new ListFeatureGroupsFixedSizeCollection(null, 0);
        }

        protected ListFeatureGroupsFixedSizeCollection createCollection(List<ListFeatureGroupsPage> pages, int collectionSize) {
            return new ListFeatureGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFeatureGroupsPage
    extends AbstractPage<ListFeatureGroupsRequest, ListFeatureGroupsResponse, FeatureGroup, ListFeatureGroupsPage> {
        private ListFeatureGroupsPage(PageContext<ListFeatureGroupsRequest, ListFeatureGroupsResponse, FeatureGroup> context, ListFeatureGroupsResponse response) {
            super(context, (Object)response);
        }

        private static ListFeatureGroupsPage createEmptyPage() {
            return new ListFeatureGroupsPage(null, null);
        }

        protected ListFeatureGroupsPage createPage(PageContext<ListFeatureGroupsRequest, ListFeatureGroupsResponse, FeatureGroup> context, ListFeatureGroupsResponse response) {
            return new ListFeatureGroupsPage(context, response);
        }

        public ApiFuture<ListFeatureGroupsPage> createPageAsync(PageContext<ListFeatureGroupsRequest, ListFeatureGroupsResponse, FeatureGroup> context, ApiFuture<ListFeatureGroupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFeatureGroupsPagedResponse
    extends AbstractPagedListResponse<ListFeatureGroupsRequest, ListFeatureGroupsResponse, FeatureGroup, ListFeatureGroupsPage, ListFeatureGroupsFixedSizeCollection> {
        public static ApiFuture<ListFeatureGroupsPagedResponse> createAsync(PageContext<ListFeatureGroupsRequest, ListFeatureGroupsResponse, FeatureGroup> context, ApiFuture<ListFeatureGroupsResponse> futureResponse) {
            ApiFuture<ListFeatureGroupsPage> futurePage = ListFeatureGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFeatureGroupsPagedResponse((ListFeatureGroupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListFeatureGroupsPagedResponse(ListFeatureGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFeatureGroupsFixedSizeCollection.createEmptyCollection());
        }
    }
}

