/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.CreateDeploymentResourcePoolOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateDeploymentResourcePoolRequest;
import com.google.cloud.aiplatform.v1.DeleteDeploymentResourcePoolRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.DeployedModel;
import com.google.cloud.aiplatform.v1.DeploymentResourcePool;
import com.google.cloud.aiplatform.v1.DeploymentResourcePoolServiceClient;
import com.google.cloud.aiplatform.v1.GetDeploymentResourcePoolRequest;
import com.google.cloud.aiplatform.v1.ListDeploymentResourcePoolsRequest;
import com.google.cloud.aiplatform.v1.ListDeploymentResourcePoolsResponse;
import com.google.cloud.aiplatform.v1.QueryDeployedModelsRequest;
import com.google.cloud.aiplatform.v1.QueryDeployedModelsResponse;
import com.google.cloud.aiplatform.v1.stub.DeploymentResourcePoolServiceStub;
import com.google.cloud.aiplatform.v1.stub.GrpcDeploymentResourcePoolServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class DeploymentResourcePoolServiceStubSettings
extends StubSettings<DeploymentResourcePoolServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateDeploymentResourcePoolRequest, Operation> createDeploymentResourcePoolSettings;
    private final OperationCallSettings<CreateDeploymentResourcePoolRequest, DeploymentResourcePool, CreateDeploymentResourcePoolOperationMetadata> createDeploymentResourcePoolOperationSettings;
    private final UnaryCallSettings<GetDeploymentResourcePoolRequest, DeploymentResourcePool> getDeploymentResourcePoolSettings;
    private final PagedCallSettings<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsResponse, DeploymentResourcePoolServiceClient.ListDeploymentResourcePoolsPagedResponse> listDeploymentResourcePoolsSettings;
    private final UnaryCallSettings<DeleteDeploymentResourcePoolRequest, Operation> deleteDeploymentResourcePoolSettings;
    private final OperationCallSettings<DeleteDeploymentResourcePoolRequest, Empty, DeleteOperationMetadata> deleteDeploymentResourcePoolOperationSettings;
    private final PagedCallSettings<QueryDeployedModelsRequest, QueryDeployedModelsResponse, DeploymentResourcePoolServiceClient.QueryDeployedModelsPagedResponse> queryDeployedModelsSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DeploymentResourcePoolServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsResponse, DeploymentResourcePool> LIST_DEPLOYMENT_RESOURCE_POOLS_PAGE_STR_DESC = new PagedListDescriptor<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsResponse, DeploymentResourcePool>(){

        public String emptyToken() {
            return "";
        }

        public ListDeploymentResourcePoolsRequest injectToken(ListDeploymentResourcePoolsRequest payload, String token) {
            return ListDeploymentResourcePoolsRequest.newBuilder((ListDeploymentResourcePoolsRequest)payload).setPageToken(token).build();
        }

        public ListDeploymentResourcePoolsRequest injectPageSize(ListDeploymentResourcePoolsRequest payload, int pageSize) {
            return ListDeploymentResourcePoolsRequest.newBuilder((ListDeploymentResourcePoolsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDeploymentResourcePoolsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDeploymentResourcePoolsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DeploymentResourcePool> extractResources(ListDeploymentResourcePoolsResponse payload) {
            return payload.getDeploymentResourcePoolsList() == null ? ImmutableList.of() : payload.getDeploymentResourcePoolsList();
        }
    };
    private static final PagedListDescriptor<QueryDeployedModelsRequest, QueryDeployedModelsResponse, DeployedModel> QUERY_DEPLOYED_MODELS_PAGE_STR_DESC = new PagedListDescriptor<QueryDeployedModelsRequest, QueryDeployedModelsResponse, DeployedModel>(){

        public String emptyToken() {
            return "";
        }

        public QueryDeployedModelsRequest injectToken(QueryDeployedModelsRequest payload, String token) {
            return QueryDeployedModelsRequest.newBuilder((QueryDeployedModelsRequest)payload).setPageToken(token).build();
        }

        public QueryDeployedModelsRequest injectPageSize(QueryDeployedModelsRequest payload, int pageSize) {
            return QueryDeployedModelsRequest.newBuilder((QueryDeployedModelsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(QueryDeployedModelsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(QueryDeployedModelsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DeployedModel> extractResources(QueryDeployedModelsResponse payload) {
            return payload.getDeployedModelsList() == null ? ImmutableList.of() : payload.getDeployedModelsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsResponse, DeploymentResourcePoolServiceClient.ListDeploymentResourcePoolsPagedResponse> LIST_DEPLOYMENT_RESOURCE_POOLS_PAGE_STR_FACT = new PagedListResponseFactory<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsResponse, DeploymentResourcePoolServiceClient.ListDeploymentResourcePoolsPagedResponse>(){

        public ApiFuture<DeploymentResourcePoolServiceClient.ListDeploymentResourcePoolsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsResponse> callable, ListDeploymentResourcePoolsRequest request, ApiCallContext context, ApiFuture<ListDeploymentResourcePoolsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DEPLOYMENT_RESOURCE_POOLS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeploymentResourcePoolServiceClient.ListDeploymentResourcePoolsPagedResponse.createAsync((PageContext<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsResponse, DeploymentResourcePool>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<QueryDeployedModelsRequest, QueryDeployedModelsResponse, DeploymentResourcePoolServiceClient.QueryDeployedModelsPagedResponse> QUERY_DEPLOYED_MODELS_PAGE_STR_FACT = new PagedListResponseFactory<QueryDeployedModelsRequest, QueryDeployedModelsResponse, DeploymentResourcePoolServiceClient.QueryDeployedModelsPagedResponse>(){

        public ApiFuture<DeploymentResourcePoolServiceClient.QueryDeployedModelsPagedResponse> getFuturePagedResponse(UnaryCallable<QueryDeployedModelsRequest, QueryDeployedModelsResponse> callable, QueryDeployedModelsRequest request, ApiCallContext context, ApiFuture<QueryDeployedModelsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)QUERY_DEPLOYED_MODELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeploymentResourcePoolServiceClient.QueryDeployedModelsPagedResponse.createAsync((PageContext<QueryDeployedModelsRequest, QueryDeployedModelsResponse, DeployedModel>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DeploymentResourcePoolServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DeploymentResourcePoolServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<DeploymentResourcePoolServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeploymentResourcePoolServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateDeploymentResourcePoolRequest, Operation> createDeploymentResourcePoolSettings() {
        return this.createDeploymentResourcePoolSettings;
    }

    public OperationCallSettings<CreateDeploymentResourcePoolRequest, DeploymentResourcePool, CreateDeploymentResourcePoolOperationMetadata> createDeploymentResourcePoolOperationSettings() {
        return this.createDeploymentResourcePoolOperationSettings;
    }

    public UnaryCallSettings<GetDeploymentResourcePoolRequest, DeploymentResourcePool> getDeploymentResourcePoolSettings() {
        return this.getDeploymentResourcePoolSettings;
    }

    public PagedCallSettings<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsResponse, DeploymentResourcePoolServiceClient.ListDeploymentResourcePoolsPagedResponse> listDeploymentResourcePoolsSettings() {
        return this.listDeploymentResourcePoolsSettings;
    }

    public UnaryCallSettings<DeleteDeploymentResourcePoolRequest, Operation> deleteDeploymentResourcePoolSettings() {
        return this.deleteDeploymentResourcePoolSettings;
    }

    public OperationCallSettings<DeleteDeploymentResourcePoolRequest, Empty, DeleteOperationMetadata> deleteDeploymentResourcePoolOperationSettings() {
        return this.deleteDeploymentResourcePoolOperationSettings;
    }

    public PagedCallSettings<QueryDeployedModelsRequest, QueryDeployedModelsResponse, DeploymentResourcePoolServiceClient.QueryDeployedModelsPagedResponse> queryDeployedModelsSettings() {
        return this.queryDeployedModelsSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DeploymentResourcePoolServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public DeploymentResourcePoolServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDeploymentResourcePoolServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "aiplatform";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DeploymentResourcePoolServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DeploymentResourcePoolServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DeploymentResourcePoolServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createDeploymentResourcePoolSettings = settingsBuilder.createDeploymentResourcePoolSettings().build();
        this.createDeploymentResourcePoolOperationSettings = settingsBuilder.createDeploymentResourcePoolOperationSettings().build();
        this.getDeploymentResourcePoolSettings = settingsBuilder.getDeploymentResourcePoolSettings().build();
        this.listDeploymentResourcePoolsSettings = settingsBuilder.listDeploymentResourcePoolsSettings().build();
        this.deleteDeploymentResourcePoolSettings = settingsBuilder.deleteDeploymentResourcePoolSettings().build();
        this.deleteDeploymentResourcePoolOperationSettings = settingsBuilder.deleteDeploymentResourcePoolOperationSettings().build();
        this.queryDeployedModelsSettings = settingsBuilder.queryDeployedModelsSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DeploymentResourcePoolServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateDeploymentResourcePoolRequest, Operation> createDeploymentResourcePoolSettings;
        private final OperationCallSettings.Builder<CreateDeploymentResourcePoolRequest, DeploymentResourcePool, CreateDeploymentResourcePoolOperationMetadata> createDeploymentResourcePoolOperationSettings;
        private final UnaryCallSettings.Builder<GetDeploymentResourcePoolRequest, DeploymentResourcePool> getDeploymentResourcePoolSettings;
        private final PagedCallSettings.Builder<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsResponse, DeploymentResourcePoolServiceClient.ListDeploymentResourcePoolsPagedResponse> listDeploymentResourcePoolsSettings;
        private final UnaryCallSettings.Builder<DeleteDeploymentResourcePoolRequest, Operation> deleteDeploymentResourcePoolSettings;
        private final OperationCallSettings.Builder<DeleteDeploymentResourcePoolRequest, Empty, DeleteOperationMetadata> deleteDeploymentResourcePoolOperationSettings;
        private final PagedCallSettings.Builder<QueryDeployedModelsRequest, QueryDeployedModelsResponse, DeploymentResourcePoolServiceClient.QueryDeployedModelsPagedResponse> queryDeployedModelsSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DeploymentResourcePoolServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createDeploymentResourcePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDeploymentResourcePoolOperationSettings = OperationCallSettings.newBuilder();
            this.getDeploymentResourcePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDeploymentResourcePoolsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DEPLOYMENT_RESOURCE_POOLS_PAGE_STR_FACT);
            this.deleteDeploymentResourcePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDeploymentResourcePoolOperationSettings = OperationCallSettings.newBuilder();
            this.queryDeployedModelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)QUERY_DEPLOYED_MODELS_PAGE_STR_FACT);
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDeploymentResourcePoolSettings, this.getDeploymentResourcePoolSettings, this.listDeploymentResourcePoolsSettings, this.deleteDeploymentResourcePoolSettings, this.queryDeployedModelsSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DeploymentResourcePoolServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createDeploymentResourcePoolSettings = settings.createDeploymentResourcePoolSettings.toBuilder();
            this.createDeploymentResourcePoolOperationSettings = settings.createDeploymentResourcePoolOperationSettings.toBuilder();
            this.getDeploymentResourcePoolSettings = settings.getDeploymentResourcePoolSettings.toBuilder();
            this.listDeploymentResourcePoolsSettings = settings.listDeploymentResourcePoolsSettings.toBuilder();
            this.deleteDeploymentResourcePoolSettings = settings.deleteDeploymentResourcePoolSettings.toBuilder();
            this.deleteDeploymentResourcePoolOperationSettings = settings.deleteDeploymentResourcePoolOperationSettings.toBuilder();
            this.queryDeployedModelsSettings = settings.queryDeployedModelsSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDeploymentResourcePoolSettings, this.getDeploymentResourcePoolSettings, this.listDeploymentResourcePoolsSettings, this.deleteDeploymentResourcePoolSettings, this.queryDeployedModelsSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DeploymentResourcePoolServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DeploymentResourcePoolServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DeploymentResourcePoolServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DeploymentResourcePoolServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createDeploymentResourcePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDeploymentResourcePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listDeploymentResourcePoolsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteDeploymentResourcePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.queryDeployedModelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createDeploymentResourcePoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DeploymentResourcePool.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateDeploymentResourcePoolOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteDeploymentResourcePoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateDeploymentResourcePoolRequest, Operation> createDeploymentResourcePoolSettings() {
            return this.createDeploymentResourcePoolSettings;
        }

        public OperationCallSettings.Builder<CreateDeploymentResourcePoolRequest, DeploymentResourcePool, CreateDeploymentResourcePoolOperationMetadata> createDeploymentResourcePoolOperationSettings() {
            return this.createDeploymentResourcePoolOperationSettings;
        }

        public UnaryCallSettings.Builder<GetDeploymentResourcePoolRequest, DeploymentResourcePool> getDeploymentResourcePoolSettings() {
            return this.getDeploymentResourcePoolSettings;
        }

        public PagedCallSettings.Builder<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsResponse, DeploymentResourcePoolServiceClient.ListDeploymentResourcePoolsPagedResponse> listDeploymentResourcePoolsSettings() {
            return this.listDeploymentResourcePoolsSettings;
        }

        public UnaryCallSettings.Builder<DeleteDeploymentResourcePoolRequest, Operation> deleteDeploymentResourcePoolSettings() {
            return this.deleteDeploymentResourcePoolSettings;
        }

        public OperationCallSettings.Builder<DeleteDeploymentResourcePoolRequest, Empty, DeleteOperationMetadata> deleteDeploymentResourcePoolOperationSettings() {
            return this.deleteDeploymentResourcePoolOperationSettings;
        }

        public PagedCallSettings.Builder<QueryDeployedModelsRequest, QueryDeployedModelsResponse, DeploymentResourcePoolServiceClient.QueryDeployedModelsPagedResponse> queryDeployedModelsSettings() {
            return this.queryDeployedModelsSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DeploymentResourcePoolServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public DeploymentResourcePoolServiceStubSettings build() throws IOException {
            return new DeploymentResourcePoolServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

