/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.Annotation;
import com.google.cloud.aiplatform.v1.AnnotationSpec;
import com.google.cloud.aiplatform.v1.CreateDatasetOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateDatasetRequest;
import com.google.cloud.aiplatform.v1.CreateDatasetVersionOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateDatasetVersionRequest;
import com.google.cloud.aiplatform.v1.DataItem;
import com.google.cloud.aiplatform.v1.DataItemView;
import com.google.cloud.aiplatform.v1.Dataset;
import com.google.cloud.aiplatform.v1.DatasetServiceClient;
import com.google.cloud.aiplatform.v1.DatasetVersion;
import com.google.cloud.aiplatform.v1.DeleteDatasetRequest;
import com.google.cloud.aiplatform.v1.DeleteDatasetVersionRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.DeleteSavedQueryRequest;
import com.google.cloud.aiplatform.v1.ExportDataOperationMetadata;
import com.google.cloud.aiplatform.v1.ExportDataRequest;
import com.google.cloud.aiplatform.v1.ExportDataResponse;
import com.google.cloud.aiplatform.v1.GetAnnotationSpecRequest;
import com.google.cloud.aiplatform.v1.GetDatasetRequest;
import com.google.cloud.aiplatform.v1.GetDatasetVersionRequest;
import com.google.cloud.aiplatform.v1.ImportDataOperationMetadata;
import com.google.cloud.aiplatform.v1.ImportDataRequest;
import com.google.cloud.aiplatform.v1.ImportDataResponse;
import com.google.cloud.aiplatform.v1.ListAnnotationsRequest;
import com.google.cloud.aiplatform.v1.ListAnnotationsResponse;
import com.google.cloud.aiplatform.v1.ListDataItemsRequest;
import com.google.cloud.aiplatform.v1.ListDataItemsResponse;
import com.google.cloud.aiplatform.v1.ListDatasetVersionsRequest;
import com.google.cloud.aiplatform.v1.ListDatasetVersionsResponse;
import com.google.cloud.aiplatform.v1.ListDatasetsRequest;
import com.google.cloud.aiplatform.v1.ListDatasetsResponse;
import com.google.cloud.aiplatform.v1.ListSavedQueriesRequest;
import com.google.cloud.aiplatform.v1.ListSavedQueriesResponse;
import com.google.cloud.aiplatform.v1.RestoreDatasetVersionOperationMetadata;
import com.google.cloud.aiplatform.v1.RestoreDatasetVersionRequest;
import com.google.cloud.aiplatform.v1.SavedQuery;
import com.google.cloud.aiplatform.v1.SearchDataItemsRequest;
import com.google.cloud.aiplatform.v1.SearchDataItemsResponse;
import com.google.cloud.aiplatform.v1.UpdateDatasetRequest;
import com.google.cloud.aiplatform.v1.stub.DatasetServiceStub;
import com.google.cloud.aiplatform.v1.stub.GrpcDatasetServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class DatasetServiceStubSettings
extends StubSettings<DatasetServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateDatasetRequest, Operation> createDatasetSettings;
    private final OperationCallSettings<CreateDatasetRequest, Dataset, CreateDatasetOperationMetadata> createDatasetOperationSettings;
    private final UnaryCallSettings<GetDatasetRequest, Dataset> getDatasetSettings;
    private final UnaryCallSettings<UpdateDatasetRequest, Dataset> updateDatasetSettings;
    private final PagedCallSettings<ListDatasetsRequest, ListDatasetsResponse, DatasetServiceClient.ListDatasetsPagedResponse> listDatasetsSettings;
    private final UnaryCallSettings<DeleteDatasetRequest, Operation> deleteDatasetSettings;
    private final OperationCallSettings<DeleteDatasetRequest, Empty, DeleteOperationMetadata> deleteDatasetOperationSettings;
    private final UnaryCallSettings<ImportDataRequest, Operation> importDataSettings;
    private final OperationCallSettings<ImportDataRequest, ImportDataResponse, ImportDataOperationMetadata> importDataOperationSettings;
    private final UnaryCallSettings<ExportDataRequest, Operation> exportDataSettings;
    private final OperationCallSettings<ExportDataRequest, ExportDataResponse, ExportDataOperationMetadata> exportDataOperationSettings;
    private final UnaryCallSettings<CreateDatasetVersionRequest, Operation> createDatasetVersionSettings;
    private final OperationCallSettings<CreateDatasetVersionRequest, DatasetVersion, CreateDatasetVersionOperationMetadata> createDatasetVersionOperationSettings;
    private final UnaryCallSettings<DeleteDatasetVersionRequest, Operation> deleteDatasetVersionSettings;
    private final OperationCallSettings<DeleteDatasetVersionRequest, Empty, DeleteOperationMetadata> deleteDatasetVersionOperationSettings;
    private final UnaryCallSettings<GetDatasetVersionRequest, DatasetVersion> getDatasetVersionSettings;
    private final PagedCallSettings<ListDatasetVersionsRequest, ListDatasetVersionsResponse, DatasetServiceClient.ListDatasetVersionsPagedResponse> listDatasetVersionsSettings;
    private final UnaryCallSettings<RestoreDatasetVersionRequest, Operation> restoreDatasetVersionSettings;
    private final OperationCallSettings<RestoreDatasetVersionRequest, DatasetVersion, RestoreDatasetVersionOperationMetadata> restoreDatasetVersionOperationSettings;
    private final PagedCallSettings<ListDataItemsRequest, ListDataItemsResponse, DatasetServiceClient.ListDataItemsPagedResponse> listDataItemsSettings;
    private final PagedCallSettings<SearchDataItemsRequest, SearchDataItemsResponse, DatasetServiceClient.SearchDataItemsPagedResponse> searchDataItemsSettings;
    private final PagedCallSettings<ListSavedQueriesRequest, ListSavedQueriesResponse, DatasetServiceClient.ListSavedQueriesPagedResponse> listSavedQueriesSettings;
    private final UnaryCallSettings<DeleteSavedQueryRequest, Operation> deleteSavedQuerySettings;
    private final OperationCallSettings<DeleteSavedQueryRequest, Empty, DeleteOperationMetadata> deleteSavedQueryOperationSettings;
    private final UnaryCallSettings<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecSettings;
    private final PagedCallSettings<ListAnnotationsRequest, ListAnnotationsResponse, DatasetServiceClient.ListAnnotationsPagedResponse> listAnnotationsSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DatasetServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListDatasetsRequest, ListDatasetsResponse, Dataset> LIST_DATASETS_PAGE_STR_DESC = new PagedListDescriptor<ListDatasetsRequest, ListDatasetsResponse, Dataset>(){

        public String emptyToken() {
            return "";
        }

        public ListDatasetsRequest injectToken(ListDatasetsRequest payload, String token) {
            return ListDatasetsRequest.newBuilder((ListDatasetsRequest)payload).setPageToken(token).build();
        }

        public ListDatasetsRequest injectPageSize(ListDatasetsRequest payload, int pageSize) {
            return ListDatasetsRequest.newBuilder((ListDatasetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDatasetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDatasetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Dataset> extractResources(ListDatasetsResponse payload) {
            return payload.getDatasetsList() == null ? ImmutableList.of() : payload.getDatasetsList();
        }
    };
    private static final PagedListDescriptor<ListDatasetVersionsRequest, ListDatasetVersionsResponse, DatasetVersion> LIST_DATASET_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListDatasetVersionsRequest, ListDatasetVersionsResponse, DatasetVersion>(){

        public String emptyToken() {
            return "";
        }

        public ListDatasetVersionsRequest injectToken(ListDatasetVersionsRequest payload, String token) {
            return ListDatasetVersionsRequest.newBuilder((ListDatasetVersionsRequest)payload).setPageToken(token).build();
        }

        public ListDatasetVersionsRequest injectPageSize(ListDatasetVersionsRequest payload, int pageSize) {
            return ListDatasetVersionsRequest.newBuilder((ListDatasetVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDatasetVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDatasetVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DatasetVersion> extractResources(ListDatasetVersionsResponse payload) {
            return payload.getDatasetVersionsList() == null ? ImmutableList.of() : payload.getDatasetVersionsList();
        }
    };
    private static final PagedListDescriptor<ListDataItemsRequest, ListDataItemsResponse, DataItem> LIST_DATA_ITEMS_PAGE_STR_DESC = new PagedListDescriptor<ListDataItemsRequest, ListDataItemsResponse, DataItem>(){

        public String emptyToken() {
            return "";
        }

        public ListDataItemsRequest injectToken(ListDataItemsRequest payload, String token) {
            return ListDataItemsRequest.newBuilder((ListDataItemsRequest)payload).setPageToken(token).build();
        }

        public ListDataItemsRequest injectPageSize(ListDataItemsRequest payload, int pageSize) {
            return ListDataItemsRequest.newBuilder((ListDataItemsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDataItemsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDataItemsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataItem> extractResources(ListDataItemsResponse payload) {
            return payload.getDataItemsList() == null ? ImmutableList.of() : payload.getDataItemsList();
        }
    };
    private static final PagedListDescriptor<SearchDataItemsRequest, SearchDataItemsResponse, DataItemView> SEARCH_DATA_ITEMS_PAGE_STR_DESC = new PagedListDescriptor<SearchDataItemsRequest, SearchDataItemsResponse, DataItemView>(){

        public String emptyToken() {
            return "";
        }

        public SearchDataItemsRequest injectToken(SearchDataItemsRequest payload, String token) {
            return SearchDataItemsRequest.newBuilder((SearchDataItemsRequest)payload).setPageToken(token).build();
        }

        public SearchDataItemsRequest injectPageSize(SearchDataItemsRequest payload, int pageSize) {
            return SearchDataItemsRequest.newBuilder((SearchDataItemsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchDataItemsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchDataItemsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataItemView> extractResources(SearchDataItemsResponse payload) {
            return payload.getDataItemViewsList() == null ? ImmutableList.of() : payload.getDataItemViewsList();
        }
    };
    private static final PagedListDescriptor<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery> LIST_SAVED_QUERIES_PAGE_STR_DESC = new PagedListDescriptor<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery>(){

        public String emptyToken() {
            return "";
        }

        public ListSavedQueriesRequest injectToken(ListSavedQueriesRequest payload, String token) {
            return ListSavedQueriesRequest.newBuilder((ListSavedQueriesRequest)payload).setPageToken(token).build();
        }

        public ListSavedQueriesRequest injectPageSize(ListSavedQueriesRequest payload, int pageSize) {
            return ListSavedQueriesRequest.newBuilder((ListSavedQueriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSavedQueriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSavedQueriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SavedQuery> extractResources(ListSavedQueriesResponse payload) {
            return payload.getSavedQueriesList() == null ? ImmutableList.of() : payload.getSavedQueriesList();
        }
    };
    private static final PagedListDescriptor<ListAnnotationsRequest, ListAnnotationsResponse, Annotation> LIST_ANNOTATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListAnnotationsRequest, ListAnnotationsResponse, Annotation>(){

        public String emptyToken() {
            return "";
        }

        public ListAnnotationsRequest injectToken(ListAnnotationsRequest payload, String token) {
            return ListAnnotationsRequest.newBuilder((ListAnnotationsRequest)payload).setPageToken(token).build();
        }

        public ListAnnotationsRequest injectPageSize(ListAnnotationsRequest payload, int pageSize) {
            return ListAnnotationsRequest.newBuilder((ListAnnotationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAnnotationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAnnotationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Annotation> extractResources(ListAnnotationsResponse payload) {
            return payload.getAnnotationsList() == null ? ImmutableList.of() : payload.getAnnotationsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListDatasetsRequest, ListDatasetsResponse, DatasetServiceClient.ListDatasetsPagedResponse> LIST_DATASETS_PAGE_STR_FACT = new PagedListResponseFactory<ListDatasetsRequest, ListDatasetsResponse, DatasetServiceClient.ListDatasetsPagedResponse>(){

        public ApiFuture<DatasetServiceClient.ListDatasetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> callable, ListDatasetsRequest request, ApiCallContext context, ApiFuture<ListDatasetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATASETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatasetServiceClient.ListDatasetsPagedResponse.createAsync((PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDatasetVersionsRequest, ListDatasetVersionsResponse, DatasetServiceClient.ListDatasetVersionsPagedResponse> LIST_DATASET_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListDatasetVersionsRequest, ListDatasetVersionsResponse, DatasetServiceClient.ListDatasetVersionsPagedResponse>(){

        public ApiFuture<DatasetServiceClient.ListDatasetVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDatasetVersionsRequest, ListDatasetVersionsResponse> callable, ListDatasetVersionsRequest request, ApiCallContext context, ApiFuture<ListDatasetVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATASET_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatasetServiceClient.ListDatasetVersionsPagedResponse.createAsync((PageContext<ListDatasetVersionsRequest, ListDatasetVersionsResponse, DatasetVersion>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDataItemsRequest, ListDataItemsResponse, DatasetServiceClient.ListDataItemsPagedResponse> LIST_DATA_ITEMS_PAGE_STR_FACT = new PagedListResponseFactory<ListDataItemsRequest, ListDataItemsResponse, DatasetServiceClient.ListDataItemsPagedResponse>(){

        public ApiFuture<DatasetServiceClient.ListDataItemsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDataItemsRequest, ListDataItemsResponse> callable, ListDataItemsRequest request, ApiCallContext context, ApiFuture<ListDataItemsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATA_ITEMS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatasetServiceClient.ListDataItemsPagedResponse.createAsync((PageContext<ListDataItemsRequest, ListDataItemsResponse, DataItem>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchDataItemsRequest, SearchDataItemsResponse, DatasetServiceClient.SearchDataItemsPagedResponse> SEARCH_DATA_ITEMS_PAGE_STR_FACT = new PagedListResponseFactory<SearchDataItemsRequest, SearchDataItemsResponse, DatasetServiceClient.SearchDataItemsPagedResponse>(){

        public ApiFuture<DatasetServiceClient.SearchDataItemsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchDataItemsRequest, SearchDataItemsResponse> callable, SearchDataItemsRequest request, ApiCallContext context, ApiFuture<SearchDataItemsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_DATA_ITEMS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatasetServiceClient.SearchDataItemsPagedResponse.createAsync((PageContext<SearchDataItemsRequest, SearchDataItemsResponse, DataItemView>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSavedQueriesRequest, ListSavedQueriesResponse, DatasetServiceClient.ListSavedQueriesPagedResponse> LIST_SAVED_QUERIES_PAGE_STR_FACT = new PagedListResponseFactory<ListSavedQueriesRequest, ListSavedQueriesResponse, DatasetServiceClient.ListSavedQueriesPagedResponse>(){

        public ApiFuture<DatasetServiceClient.ListSavedQueriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSavedQueriesRequest, ListSavedQueriesResponse> callable, ListSavedQueriesRequest request, ApiCallContext context, ApiFuture<ListSavedQueriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SAVED_QUERIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatasetServiceClient.ListSavedQueriesPagedResponse.createAsync((PageContext<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAnnotationsRequest, ListAnnotationsResponse, DatasetServiceClient.ListAnnotationsPagedResponse> LIST_ANNOTATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListAnnotationsRequest, ListAnnotationsResponse, DatasetServiceClient.ListAnnotationsPagedResponse>(){

        public ApiFuture<DatasetServiceClient.ListAnnotationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAnnotationsRequest, ListAnnotationsResponse> callable, ListAnnotationsRequest request, ApiCallContext context, ApiFuture<ListAnnotationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ANNOTATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatasetServiceClient.ListAnnotationsPagedResponse.createAsync((PageContext<ListAnnotationsRequest, ListAnnotationsResponse, Annotation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DatasetServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DatasetServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<DatasetServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatasetServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateDatasetRequest, Operation> createDatasetSettings() {
        return this.createDatasetSettings;
    }

    public OperationCallSettings<CreateDatasetRequest, Dataset, CreateDatasetOperationMetadata> createDatasetOperationSettings() {
        return this.createDatasetOperationSettings;
    }

    public UnaryCallSettings<GetDatasetRequest, Dataset> getDatasetSettings() {
        return this.getDatasetSettings;
    }

    public UnaryCallSettings<UpdateDatasetRequest, Dataset> updateDatasetSettings() {
        return this.updateDatasetSettings;
    }

    public PagedCallSettings<ListDatasetsRequest, ListDatasetsResponse, DatasetServiceClient.ListDatasetsPagedResponse> listDatasetsSettings() {
        return this.listDatasetsSettings;
    }

    public UnaryCallSettings<DeleteDatasetRequest, Operation> deleteDatasetSettings() {
        return this.deleteDatasetSettings;
    }

    public OperationCallSettings<DeleteDatasetRequest, Empty, DeleteOperationMetadata> deleteDatasetOperationSettings() {
        return this.deleteDatasetOperationSettings;
    }

    public UnaryCallSettings<ImportDataRequest, Operation> importDataSettings() {
        return this.importDataSettings;
    }

    public OperationCallSettings<ImportDataRequest, ImportDataResponse, ImportDataOperationMetadata> importDataOperationSettings() {
        return this.importDataOperationSettings;
    }

    public UnaryCallSettings<ExportDataRequest, Operation> exportDataSettings() {
        return this.exportDataSettings;
    }

    public OperationCallSettings<ExportDataRequest, ExportDataResponse, ExportDataOperationMetadata> exportDataOperationSettings() {
        return this.exportDataOperationSettings;
    }

    public UnaryCallSettings<CreateDatasetVersionRequest, Operation> createDatasetVersionSettings() {
        return this.createDatasetVersionSettings;
    }

    public OperationCallSettings<CreateDatasetVersionRequest, DatasetVersion, CreateDatasetVersionOperationMetadata> createDatasetVersionOperationSettings() {
        return this.createDatasetVersionOperationSettings;
    }

    public UnaryCallSettings<DeleteDatasetVersionRequest, Operation> deleteDatasetVersionSettings() {
        return this.deleteDatasetVersionSettings;
    }

    public OperationCallSettings<DeleteDatasetVersionRequest, Empty, DeleteOperationMetadata> deleteDatasetVersionOperationSettings() {
        return this.deleteDatasetVersionOperationSettings;
    }

    public UnaryCallSettings<GetDatasetVersionRequest, DatasetVersion> getDatasetVersionSettings() {
        return this.getDatasetVersionSettings;
    }

    public PagedCallSettings<ListDatasetVersionsRequest, ListDatasetVersionsResponse, DatasetServiceClient.ListDatasetVersionsPagedResponse> listDatasetVersionsSettings() {
        return this.listDatasetVersionsSettings;
    }

    public UnaryCallSettings<RestoreDatasetVersionRequest, Operation> restoreDatasetVersionSettings() {
        return this.restoreDatasetVersionSettings;
    }

    public OperationCallSettings<RestoreDatasetVersionRequest, DatasetVersion, RestoreDatasetVersionOperationMetadata> restoreDatasetVersionOperationSettings() {
        return this.restoreDatasetVersionOperationSettings;
    }

    public PagedCallSettings<ListDataItemsRequest, ListDataItemsResponse, DatasetServiceClient.ListDataItemsPagedResponse> listDataItemsSettings() {
        return this.listDataItemsSettings;
    }

    public PagedCallSettings<SearchDataItemsRequest, SearchDataItemsResponse, DatasetServiceClient.SearchDataItemsPagedResponse> searchDataItemsSettings() {
        return this.searchDataItemsSettings;
    }

    public PagedCallSettings<ListSavedQueriesRequest, ListSavedQueriesResponse, DatasetServiceClient.ListSavedQueriesPagedResponse> listSavedQueriesSettings() {
        return this.listSavedQueriesSettings;
    }

    public UnaryCallSettings<DeleteSavedQueryRequest, Operation> deleteSavedQuerySettings() {
        return this.deleteSavedQuerySettings;
    }

    public OperationCallSettings<DeleteSavedQueryRequest, Empty, DeleteOperationMetadata> deleteSavedQueryOperationSettings() {
        return this.deleteSavedQueryOperationSettings;
    }

    public UnaryCallSettings<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecSettings() {
        return this.getAnnotationSpecSettings;
    }

    public PagedCallSettings<ListAnnotationsRequest, ListAnnotationsResponse, DatasetServiceClient.ListAnnotationsPagedResponse> listAnnotationsSettings() {
        return this.listAnnotationsSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DatasetServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public DatasetServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDatasetServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "aiplatform";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DatasetServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DatasetServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DatasetServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createDatasetSettings = settingsBuilder.createDatasetSettings().build();
        this.createDatasetOperationSettings = settingsBuilder.createDatasetOperationSettings().build();
        this.getDatasetSettings = settingsBuilder.getDatasetSettings().build();
        this.updateDatasetSettings = settingsBuilder.updateDatasetSettings().build();
        this.listDatasetsSettings = settingsBuilder.listDatasetsSettings().build();
        this.deleteDatasetSettings = settingsBuilder.deleteDatasetSettings().build();
        this.deleteDatasetOperationSettings = settingsBuilder.deleteDatasetOperationSettings().build();
        this.importDataSettings = settingsBuilder.importDataSettings().build();
        this.importDataOperationSettings = settingsBuilder.importDataOperationSettings().build();
        this.exportDataSettings = settingsBuilder.exportDataSettings().build();
        this.exportDataOperationSettings = settingsBuilder.exportDataOperationSettings().build();
        this.createDatasetVersionSettings = settingsBuilder.createDatasetVersionSettings().build();
        this.createDatasetVersionOperationSettings = settingsBuilder.createDatasetVersionOperationSettings().build();
        this.deleteDatasetVersionSettings = settingsBuilder.deleteDatasetVersionSettings().build();
        this.deleteDatasetVersionOperationSettings = settingsBuilder.deleteDatasetVersionOperationSettings().build();
        this.getDatasetVersionSettings = settingsBuilder.getDatasetVersionSettings().build();
        this.listDatasetVersionsSettings = settingsBuilder.listDatasetVersionsSettings().build();
        this.restoreDatasetVersionSettings = settingsBuilder.restoreDatasetVersionSettings().build();
        this.restoreDatasetVersionOperationSettings = settingsBuilder.restoreDatasetVersionOperationSettings().build();
        this.listDataItemsSettings = settingsBuilder.listDataItemsSettings().build();
        this.searchDataItemsSettings = settingsBuilder.searchDataItemsSettings().build();
        this.listSavedQueriesSettings = settingsBuilder.listSavedQueriesSettings().build();
        this.deleteSavedQuerySettings = settingsBuilder.deleteSavedQuerySettings().build();
        this.deleteSavedQueryOperationSettings = settingsBuilder.deleteSavedQueryOperationSettings().build();
        this.getAnnotationSpecSettings = settingsBuilder.getAnnotationSpecSettings().build();
        this.listAnnotationsSettings = settingsBuilder.listAnnotationsSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DatasetServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateDatasetRequest, Operation> createDatasetSettings;
        private final OperationCallSettings.Builder<CreateDatasetRequest, Dataset, CreateDatasetOperationMetadata> createDatasetOperationSettings;
        private final UnaryCallSettings.Builder<GetDatasetRequest, Dataset> getDatasetSettings;
        private final UnaryCallSettings.Builder<UpdateDatasetRequest, Dataset> updateDatasetSettings;
        private final PagedCallSettings.Builder<ListDatasetsRequest, ListDatasetsResponse, DatasetServiceClient.ListDatasetsPagedResponse> listDatasetsSettings;
        private final UnaryCallSettings.Builder<DeleteDatasetRequest, Operation> deleteDatasetSettings;
        private final OperationCallSettings.Builder<DeleteDatasetRequest, Empty, DeleteOperationMetadata> deleteDatasetOperationSettings;
        private final UnaryCallSettings.Builder<ImportDataRequest, Operation> importDataSettings;
        private final OperationCallSettings.Builder<ImportDataRequest, ImportDataResponse, ImportDataOperationMetadata> importDataOperationSettings;
        private final UnaryCallSettings.Builder<ExportDataRequest, Operation> exportDataSettings;
        private final OperationCallSettings.Builder<ExportDataRequest, ExportDataResponse, ExportDataOperationMetadata> exportDataOperationSettings;
        private final UnaryCallSettings.Builder<CreateDatasetVersionRequest, Operation> createDatasetVersionSettings;
        private final OperationCallSettings.Builder<CreateDatasetVersionRequest, DatasetVersion, CreateDatasetVersionOperationMetadata> createDatasetVersionOperationSettings;
        private final UnaryCallSettings.Builder<DeleteDatasetVersionRequest, Operation> deleteDatasetVersionSettings;
        private final OperationCallSettings.Builder<DeleteDatasetVersionRequest, Empty, DeleteOperationMetadata> deleteDatasetVersionOperationSettings;
        private final UnaryCallSettings.Builder<GetDatasetVersionRequest, DatasetVersion> getDatasetVersionSettings;
        private final PagedCallSettings.Builder<ListDatasetVersionsRequest, ListDatasetVersionsResponse, DatasetServiceClient.ListDatasetVersionsPagedResponse> listDatasetVersionsSettings;
        private final UnaryCallSettings.Builder<RestoreDatasetVersionRequest, Operation> restoreDatasetVersionSettings;
        private final OperationCallSettings.Builder<RestoreDatasetVersionRequest, DatasetVersion, RestoreDatasetVersionOperationMetadata> restoreDatasetVersionOperationSettings;
        private final PagedCallSettings.Builder<ListDataItemsRequest, ListDataItemsResponse, DatasetServiceClient.ListDataItemsPagedResponse> listDataItemsSettings;
        private final PagedCallSettings.Builder<SearchDataItemsRequest, SearchDataItemsResponse, DatasetServiceClient.SearchDataItemsPagedResponse> searchDataItemsSettings;
        private final PagedCallSettings.Builder<ListSavedQueriesRequest, ListSavedQueriesResponse, DatasetServiceClient.ListSavedQueriesPagedResponse> listSavedQueriesSettings;
        private final UnaryCallSettings.Builder<DeleteSavedQueryRequest, Operation> deleteSavedQuerySettings;
        private final OperationCallSettings.Builder<DeleteSavedQueryRequest, Empty, DeleteOperationMetadata> deleteSavedQueryOperationSettings;
        private final UnaryCallSettings.Builder<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecSettings;
        private final PagedCallSettings.Builder<ListAnnotationsRequest, ListAnnotationsResponse, DatasetServiceClient.ListAnnotationsPagedResponse> listAnnotationsSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DatasetServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDatasetOperationSettings = OperationCallSettings.newBuilder();
            this.getDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDatasetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATASETS_PAGE_STR_FACT);
            this.deleteDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDatasetOperationSettings = OperationCallSettings.newBuilder();
            this.importDataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importDataOperationSettings = OperationCallSettings.newBuilder();
            this.exportDataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportDataOperationSettings = OperationCallSettings.newBuilder();
            this.createDatasetVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDatasetVersionOperationSettings = OperationCallSettings.newBuilder();
            this.deleteDatasetVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDatasetVersionOperationSettings = OperationCallSettings.newBuilder();
            this.getDatasetVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDatasetVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATASET_VERSIONS_PAGE_STR_FACT);
            this.restoreDatasetVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restoreDatasetVersionOperationSettings = OperationCallSettings.newBuilder();
            this.listDataItemsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATA_ITEMS_PAGE_STR_FACT);
            this.searchDataItemsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_DATA_ITEMS_PAGE_STR_FACT);
            this.listSavedQueriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SAVED_QUERIES_PAGE_STR_FACT);
            this.deleteSavedQuerySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSavedQueryOperationSettings = OperationCallSettings.newBuilder();
            this.getAnnotationSpecSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAnnotationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ANNOTATIONS_PAGE_STR_FACT);
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDatasetSettings, this.getDatasetSettings, this.updateDatasetSettings, this.listDatasetsSettings, this.deleteDatasetSettings, this.importDataSettings, this.exportDataSettings, this.createDatasetVersionSettings, this.deleteDatasetVersionSettings, this.getDatasetVersionSettings, this.listDatasetVersionsSettings, this.restoreDatasetVersionSettings, (Object[])new UnaryCallSettings.Builder[]{this.listDataItemsSettings, this.searchDataItemsSettings, this.listSavedQueriesSettings, this.deleteSavedQuerySettings, this.getAnnotationSpecSettings, this.listAnnotationsSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(DatasetServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createDatasetSettings = settings.createDatasetSettings.toBuilder();
            this.createDatasetOperationSettings = settings.createDatasetOperationSettings.toBuilder();
            this.getDatasetSettings = settings.getDatasetSettings.toBuilder();
            this.updateDatasetSettings = settings.updateDatasetSettings.toBuilder();
            this.listDatasetsSettings = settings.listDatasetsSettings.toBuilder();
            this.deleteDatasetSettings = settings.deleteDatasetSettings.toBuilder();
            this.deleteDatasetOperationSettings = settings.deleteDatasetOperationSettings.toBuilder();
            this.importDataSettings = settings.importDataSettings.toBuilder();
            this.importDataOperationSettings = settings.importDataOperationSettings.toBuilder();
            this.exportDataSettings = settings.exportDataSettings.toBuilder();
            this.exportDataOperationSettings = settings.exportDataOperationSettings.toBuilder();
            this.createDatasetVersionSettings = settings.createDatasetVersionSettings.toBuilder();
            this.createDatasetVersionOperationSettings = settings.createDatasetVersionOperationSettings.toBuilder();
            this.deleteDatasetVersionSettings = settings.deleteDatasetVersionSettings.toBuilder();
            this.deleteDatasetVersionOperationSettings = settings.deleteDatasetVersionOperationSettings.toBuilder();
            this.getDatasetVersionSettings = settings.getDatasetVersionSettings.toBuilder();
            this.listDatasetVersionsSettings = settings.listDatasetVersionsSettings.toBuilder();
            this.restoreDatasetVersionSettings = settings.restoreDatasetVersionSettings.toBuilder();
            this.restoreDatasetVersionOperationSettings = settings.restoreDatasetVersionOperationSettings.toBuilder();
            this.listDataItemsSettings = settings.listDataItemsSettings.toBuilder();
            this.searchDataItemsSettings = settings.searchDataItemsSettings.toBuilder();
            this.listSavedQueriesSettings = settings.listSavedQueriesSettings.toBuilder();
            this.deleteSavedQuerySettings = settings.deleteSavedQuerySettings.toBuilder();
            this.deleteSavedQueryOperationSettings = settings.deleteSavedQueryOperationSettings.toBuilder();
            this.getAnnotationSpecSettings = settings.getAnnotationSpecSettings.toBuilder();
            this.listAnnotationsSettings = settings.listAnnotationsSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDatasetSettings, this.getDatasetSettings, this.updateDatasetSettings, this.listDatasetsSettings, this.deleteDatasetSettings, this.importDataSettings, this.exportDataSettings, this.createDatasetVersionSettings, this.deleteDatasetVersionSettings, this.getDatasetVersionSettings, this.listDatasetVersionsSettings, this.restoreDatasetVersionSettings, (Object[])new UnaryCallSettings.Builder[]{this.listDataItemsSettings, this.searchDataItemsSettings, this.listSavedQueriesSettings, this.deleteSavedQuerySettings, this.getAnnotationSpecSettings, this.listAnnotationsSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DatasetServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DatasetServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DatasetServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DatasetServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DatasetServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listDatasetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.importDataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.exportDataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createDatasetVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteDatasetVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDatasetVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listDatasetVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.restoreDatasetVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listDataItemsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.searchDataItemsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listSavedQueriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteSavedQuerySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getAnnotationSpecSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listAnnotationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createDatasetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Dataset.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateDatasetOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteDatasetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.importDataOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportDataResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportDataOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.exportDataOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportDataResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ExportDataOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createDatasetVersionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DatasetVersion.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateDatasetVersionOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteDatasetVersionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.restoreDatasetVersionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DatasetVersion.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(RestoreDatasetVersionOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteSavedQueryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateDatasetRequest, Operation> createDatasetSettings() {
            return this.createDatasetSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateDatasetRequest, Dataset, CreateDatasetOperationMetadata> createDatasetOperationSettings() {
            return this.createDatasetOperationSettings;
        }

        public UnaryCallSettings.Builder<GetDatasetRequest, Dataset> getDatasetSettings() {
            return this.getDatasetSettings;
        }

        public UnaryCallSettings.Builder<UpdateDatasetRequest, Dataset> updateDatasetSettings() {
            return this.updateDatasetSettings;
        }

        public PagedCallSettings.Builder<ListDatasetsRequest, ListDatasetsResponse, DatasetServiceClient.ListDatasetsPagedResponse> listDatasetsSettings() {
            return this.listDatasetsSettings;
        }

        public UnaryCallSettings.Builder<DeleteDatasetRequest, Operation> deleteDatasetSettings() {
            return this.deleteDatasetSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteDatasetRequest, Empty, DeleteOperationMetadata> deleteDatasetOperationSettings() {
            return this.deleteDatasetOperationSettings;
        }

        public UnaryCallSettings.Builder<ImportDataRequest, Operation> importDataSettings() {
            return this.importDataSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ImportDataRequest, ImportDataResponse, ImportDataOperationMetadata> importDataOperationSettings() {
            return this.importDataOperationSettings;
        }

        public UnaryCallSettings.Builder<ExportDataRequest, Operation> exportDataSettings() {
            return this.exportDataSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ExportDataRequest, ExportDataResponse, ExportDataOperationMetadata> exportDataOperationSettings() {
            return this.exportDataOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateDatasetVersionRequest, Operation> createDatasetVersionSettings() {
            return this.createDatasetVersionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateDatasetVersionRequest, DatasetVersion, CreateDatasetVersionOperationMetadata> createDatasetVersionOperationSettings() {
            return this.createDatasetVersionOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteDatasetVersionRequest, Operation> deleteDatasetVersionSettings() {
            return this.deleteDatasetVersionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteDatasetVersionRequest, Empty, DeleteOperationMetadata> deleteDatasetVersionOperationSettings() {
            return this.deleteDatasetVersionOperationSettings;
        }

        public UnaryCallSettings.Builder<GetDatasetVersionRequest, DatasetVersion> getDatasetVersionSettings() {
            return this.getDatasetVersionSettings;
        }

        public PagedCallSettings.Builder<ListDatasetVersionsRequest, ListDatasetVersionsResponse, DatasetServiceClient.ListDatasetVersionsPagedResponse> listDatasetVersionsSettings() {
            return this.listDatasetVersionsSettings;
        }

        public UnaryCallSettings.Builder<RestoreDatasetVersionRequest, Operation> restoreDatasetVersionSettings() {
            return this.restoreDatasetVersionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RestoreDatasetVersionRequest, DatasetVersion, RestoreDatasetVersionOperationMetadata> restoreDatasetVersionOperationSettings() {
            return this.restoreDatasetVersionOperationSettings;
        }

        public PagedCallSettings.Builder<ListDataItemsRequest, ListDataItemsResponse, DatasetServiceClient.ListDataItemsPagedResponse> listDataItemsSettings() {
            return this.listDataItemsSettings;
        }

        public PagedCallSettings.Builder<SearchDataItemsRequest, SearchDataItemsResponse, DatasetServiceClient.SearchDataItemsPagedResponse> searchDataItemsSettings() {
            return this.searchDataItemsSettings;
        }

        public PagedCallSettings.Builder<ListSavedQueriesRequest, ListSavedQueriesResponse, DatasetServiceClient.ListSavedQueriesPagedResponse> listSavedQueriesSettings() {
            return this.listSavedQueriesSettings;
        }

        public UnaryCallSettings.Builder<DeleteSavedQueryRequest, Operation> deleteSavedQuerySettings() {
            return this.deleteSavedQuerySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteSavedQueryRequest, Empty, DeleteOperationMetadata> deleteSavedQueryOperationSettings() {
            return this.deleteSavedQueryOperationSettings;
        }

        public UnaryCallSettings.Builder<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecSettings() {
            return this.getAnnotationSpecSettings;
        }

        public PagedCallSettings.Builder<ListAnnotationsRequest, ListAnnotationsResponse, DatasetServiceClient.ListAnnotationsPagedResponse> listAnnotationsSettings() {
            return this.listAnnotationsSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DatasetServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public DatasetServiceStubSettings build() throws IOException {
            return new DatasetServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

