/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.HttpBody;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.DirectPredictRequest;
import com.google.cloud.aiplatform.v1.DirectPredictResponse;
import com.google.cloud.aiplatform.v1.DirectRawPredictRequest;
import com.google.cloud.aiplatform.v1.DirectRawPredictResponse;
import com.google.cloud.aiplatform.v1.EndpointName;
import com.google.cloud.aiplatform.v1.ExplainRequest;
import com.google.cloud.aiplatform.v1.ExplainResponse;
import com.google.cloud.aiplatform.v1.PredictRequest;
import com.google.cloud.aiplatform.v1.PredictResponse;
import com.google.cloud.aiplatform.v1.PredictionServiceSettings;
import com.google.cloud.aiplatform.v1.RawPredictRequest;
import com.google.cloud.aiplatform.v1.StreamingPredictRequest;
import com.google.cloud.aiplatform.v1.StreamingPredictResponse;
import com.google.cloud.aiplatform.v1.StreamingRawPredictRequest;
import com.google.cloud.aiplatform.v1.StreamingRawPredictResponse;
import com.google.cloud.aiplatform.v1.stub.PredictionServiceStub;
import com.google.cloud.aiplatform.v1.stub.PredictionServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Value;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class PredictionServiceClient
implements BackgroundResource {
    private final PredictionServiceSettings settings;
    private final PredictionServiceStub stub;

    public static final PredictionServiceClient create() throws IOException {
        return PredictionServiceClient.create(PredictionServiceSettings.newBuilder().build());
    }

    public static final PredictionServiceClient create(PredictionServiceSettings settings) throws IOException {
        return new PredictionServiceClient(settings);
    }

    public static final PredictionServiceClient create(PredictionServiceStub stub) {
        return new PredictionServiceClient(stub);
    }

    protected PredictionServiceClient(PredictionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PredictionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected PredictionServiceClient(PredictionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PredictionServiceSettings getSettings() {
        return this.settings;
    }

    public PredictionServiceStub getStub() {
        return this.stub;
    }

    public final PredictResponse predict(EndpointName endpoint, List<Value> instances, Value parameters) {
        PredictRequest request = PredictRequest.newBuilder().setEndpoint(endpoint == null ? null : endpoint.toString()).addAllInstances(instances).setParameters(parameters).build();
        return this.predict(request);
    }

    public final PredictResponse predict(String endpoint, List<Value> instances, Value parameters) {
        PredictRequest request = PredictRequest.newBuilder().setEndpoint(endpoint).addAllInstances(instances).setParameters(parameters).build();
        return this.predict(request);
    }

    public final PredictResponse predict(PredictRequest request) {
        return (PredictResponse)this.predictCallable().call((Object)request);
    }

    public final UnaryCallable<PredictRequest, PredictResponse> predictCallable() {
        return this.stub.predictCallable();
    }

    public final HttpBody rawPredict(EndpointName endpoint, HttpBody httpBody) {
        RawPredictRequest request = RawPredictRequest.newBuilder().setEndpoint(endpoint == null ? null : endpoint.toString()).setHttpBody(httpBody).build();
        return this.rawPredict(request);
    }

    public final HttpBody rawPredict(String endpoint, HttpBody httpBody) {
        RawPredictRequest request = RawPredictRequest.newBuilder().setEndpoint(endpoint).setHttpBody(httpBody).build();
        return this.rawPredict(request);
    }

    public final HttpBody rawPredict(RawPredictRequest request) {
        return (HttpBody)this.rawPredictCallable().call((Object)request);
    }

    public final UnaryCallable<RawPredictRequest, HttpBody> rawPredictCallable() {
        return this.stub.rawPredictCallable();
    }

    public final DirectPredictResponse directPredict(DirectPredictRequest request) {
        return (DirectPredictResponse)this.directPredictCallable().call((Object)request);
    }

    public final UnaryCallable<DirectPredictRequest, DirectPredictResponse> directPredictCallable() {
        return this.stub.directPredictCallable();
    }

    public final DirectRawPredictResponse directRawPredict(DirectRawPredictRequest request) {
        return (DirectRawPredictResponse)this.directRawPredictCallable().call((Object)request);
    }

    public final UnaryCallable<DirectRawPredictRequest, DirectRawPredictResponse> directRawPredictCallable() {
        return this.stub.directRawPredictCallable();
    }

    public final BidiStreamingCallable<StreamingPredictRequest, StreamingPredictResponse> streamingPredictCallable() {
        return this.stub.streamingPredictCallable();
    }

    public final ServerStreamingCallable<StreamingPredictRequest, StreamingPredictResponse> serverStreamingPredictCallable() {
        return this.stub.serverStreamingPredictCallable();
    }

    public final BidiStreamingCallable<StreamingRawPredictRequest, StreamingRawPredictResponse> streamingRawPredictCallable() {
        return this.stub.streamingRawPredictCallable();
    }

    public final ExplainResponse explain(EndpointName endpoint, List<Value> instances, Value parameters, String deployedModelId) {
        ExplainRequest request = ExplainRequest.newBuilder().setEndpoint(endpoint == null ? null : endpoint.toString()).addAllInstances(instances).setParameters(parameters).setDeployedModelId(deployedModelId).build();
        return this.explain(request);
    }

    public final ExplainResponse explain(String endpoint, List<Value> instances, Value parameters, String deployedModelId) {
        ExplainRequest request = ExplainRequest.newBuilder().setEndpoint(endpoint).addAllInstances(instances).setParameters(parameters).setDeployedModelId(deployedModelId).build();
        return this.explain(request);
    }

    public final ExplainResponse explain(ExplainRequest request) {
        return (ExplainResponse)this.explainCallable().call((Object)request);
    }

    public final UnaryCallable<ExplainRequest, ExplainResponse> explainCallable() {
        return this.stub.explainCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

