/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.BatchCreateTensorboardRunsRequest;
import com.google.cloud.aiplatform.v1.BatchCreateTensorboardRunsResponse;
import com.google.cloud.aiplatform.v1.BatchCreateTensorboardTimeSeriesRequest;
import com.google.cloud.aiplatform.v1.BatchCreateTensorboardTimeSeriesResponse;
import com.google.cloud.aiplatform.v1.BatchReadTensorboardTimeSeriesDataRequest;
import com.google.cloud.aiplatform.v1.BatchReadTensorboardTimeSeriesDataResponse;
import com.google.cloud.aiplatform.v1.CreateTensorboardExperimentRequest;
import com.google.cloud.aiplatform.v1.CreateTensorboardOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateTensorboardRequest;
import com.google.cloud.aiplatform.v1.CreateTensorboardRunRequest;
import com.google.cloud.aiplatform.v1.CreateTensorboardTimeSeriesRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.DeleteTensorboardExperimentRequest;
import com.google.cloud.aiplatform.v1.DeleteTensorboardRequest;
import com.google.cloud.aiplatform.v1.DeleteTensorboardRunRequest;
import com.google.cloud.aiplatform.v1.DeleteTensorboardTimeSeriesRequest;
import com.google.cloud.aiplatform.v1.ExportTensorboardTimeSeriesDataRequest;
import com.google.cloud.aiplatform.v1.ExportTensorboardTimeSeriesDataResponse;
import com.google.cloud.aiplatform.v1.GetTensorboardExperimentRequest;
import com.google.cloud.aiplatform.v1.GetTensorboardRequest;
import com.google.cloud.aiplatform.v1.GetTensorboardRunRequest;
import com.google.cloud.aiplatform.v1.GetTensorboardTimeSeriesRequest;
import com.google.cloud.aiplatform.v1.ListTensorboardExperimentsRequest;
import com.google.cloud.aiplatform.v1.ListTensorboardExperimentsResponse;
import com.google.cloud.aiplatform.v1.ListTensorboardRunsRequest;
import com.google.cloud.aiplatform.v1.ListTensorboardRunsResponse;
import com.google.cloud.aiplatform.v1.ListTensorboardTimeSeriesRequest;
import com.google.cloud.aiplatform.v1.ListTensorboardTimeSeriesResponse;
import com.google.cloud.aiplatform.v1.ListTensorboardsRequest;
import com.google.cloud.aiplatform.v1.ListTensorboardsResponse;
import com.google.cloud.aiplatform.v1.ReadTensorboardBlobDataRequest;
import com.google.cloud.aiplatform.v1.ReadTensorboardBlobDataResponse;
import com.google.cloud.aiplatform.v1.ReadTensorboardTimeSeriesDataRequest;
import com.google.cloud.aiplatform.v1.ReadTensorboardTimeSeriesDataResponse;
import com.google.cloud.aiplatform.v1.ReadTensorboardUsageRequest;
import com.google.cloud.aiplatform.v1.ReadTensorboardUsageResponse;
import com.google.cloud.aiplatform.v1.Tensorboard;
import com.google.cloud.aiplatform.v1.TensorboardExperiment;
import com.google.cloud.aiplatform.v1.TensorboardRun;
import com.google.cloud.aiplatform.v1.TensorboardServiceClient;
import com.google.cloud.aiplatform.v1.TensorboardTimeSeries;
import com.google.cloud.aiplatform.v1.TimeSeriesDataPoint;
import com.google.cloud.aiplatform.v1.UpdateTensorboardExperimentRequest;
import com.google.cloud.aiplatform.v1.UpdateTensorboardOperationMetadata;
import com.google.cloud.aiplatform.v1.UpdateTensorboardRequest;
import com.google.cloud.aiplatform.v1.UpdateTensorboardRunRequest;
import com.google.cloud.aiplatform.v1.UpdateTensorboardTimeSeriesRequest;
import com.google.cloud.aiplatform.v1.WriteTensorboardExperimentDataRequest;
import com.google.cloud.aiplatform.v1.WriteTensorboardExperimentDataResponse;
import com.google.cloud.aiplatform.v1.WriteTensorboardRunDataRequest;
import com.google.cloud.aiplatform.v1.WriteTensorboardRunDataResponse;
import com.google.cloud.aiplatform.v1.stub.GrpcTensorboardServiceStub;
import com.google.cloud.aiplatform.v1.stub.TensorboardServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class TensorboardServiceStubSettings
extends StubSettings<TensorboardServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final UnaryCallSettings<CreateTensorboardRequest, Operation> createTensorboardSettings;
    private final OperationCallSettings<CreateTensorboardRequest, Tensorboard, CreateTensorboardOperationMetadata> createTensorboardOperationSettings;
    private final UnaryCallSettings<GetTensorboardRequest, Tensorboard> getTensorboardSettings;
    private final UnaryCallSettings<UpdateTensorboardRequest, Operation> updateTensorboardSettings;
    private final OperationCallSettings<UpdateTensorboardRequest, Tensorboard, UpdateTensorboardOperationMetadata> updateTensorboardOperationSettings;
    private final PagedCallSettings<ListTensorboardsRequest, ListTensorboardsResponse, TensorboardServiceClient.ListTensorboardsPagedResponse> listTensorboardsSettings;
    private final UnaryCallSettings<DeleteTensorboardRequest, Operation> deleteTensorboardSettings;
    private final OperationCallSettings<DeleteTensorboardRequest, Empty, DeleteOperationMetadata> deleteTensorboardOperationSettings;
    private final UnaryCallSettings<ReadTensorboardUsageRequest, ReadTensorboardUsageResponse> readTensorboardUsageSettings;
    private final UnaryCallSettings<CreateTensorboardExperimentRequest, TensorboardExperiment> createTensorboardExperimentSettings;
    private final UnaryCallSettings<GetTensorboardExperimentRequest, TensorboardExperiment> getTensorboardExperimentSettings;
    private final UnaryCallSettings<UpdateTensorboardExperimentRequest, TensorboardExperiment> updateTensorboardExperimentSettings;
    private final PagedCallSettings<ListTensorboardExperimentsRequest, ListTensorboardExperimentsResponse, TensorboardServiceClient.ListTensorboardExperimentsPagedResponse> listTensorboardExperimentsSettings;
    private final UnaryCallSettings<DeleteTensorboardExperimentRequest, Operation> deleteTensorboardExperimentSettings;
    private final OperationCallSettings<DeleteTensorboardExperimentRequest, Empty, DeleteOperationMetadata> deleteTensorboardExperimentOperationSettings;
    private final UnaryCallSettings<CreateTensorboardRunRequest, TensorboardRun> createTensorboardRunSettings;
    private final UnaryCallSettings<BatchCreateTensorboardRunsRequest, BatchCreateTensorboardRunsResponse> batchCreateTensorboardRunsSettings;
    private final UnaryCallSettings<GetTensorboardRunRequest, TensorboardRun> getTensorboardRunSettings;
    private final UnaryCallSettings<UpdateTensorboardRunRequest, TensorboardRun> updateTensorboardRunSettings;
    private final PagedCallSettings<ListTensorboardRunsRequest, ListTensorboardRunsResponse, TensorboardServiceClient.ListTensorboardRunsPagedResponse> listTensorboardRunsSettings;
    private final UnaryCallSettings<DeleteTensorboardRunRequest, Operation> deleteTensorboardRunSettings;
    private final OperationCallSettings<DeleteTensorboardRunRequest, Empty, DeleteOperationMetadata> deleteTensorboardRunOperationSettings;
    private final UnaryCallSettings<BatchCreateTensorboardTimeSeriesRequest, BatchCreateTensorboardTimeSeriesResponse> batchCreateTensorboardTimeSeriesSettings;
    private final UnaryCallSettings<CreateTensorboardTimeSeriesRequest, TensorboardTimeSeries> createTensorboardTimeSeriesSettings;
    private final UnaryCallSettings<GetTensorboardTimeSeriesRequest, TensorboardTimeSeries> getTensorboardTimeSeriesSettings;
    private final UnaryCallSettings<UpdateTensorboardTimeSeriesRequest, TensorboardTimeSeries> updateTensorboardTimeSeriesSettings;
    private final PagedCallSettings<ListTensorboardTimeSeriesRequest, ListTensorboardTimeSeriesResponse, TensorboardServiceClient.ListTensorboardTimeSeriesPagedResponse> listTensorboardTimeSeriesSettings;
    private final UnaryCallSettings<DeleteTensorboardTimeSeriesRequest, Operation> deleteTensorboardTimeSeriesSettings;
    private final OperationCallSettings<DeleteTensorboardTimeSeriesRequest, Empty, DeleteOperationMetadata> deleteTensorboardTimeSeriesOperationSettings;
    private final UnaryCallSettings<BatchReadTensorboardTimeSeriesDataRequest, BatchReadTensorboardTimeSeriesDataResponse> batchReadTensorboardTimeSeriesDataSettings;
    private final UnaryCallSettings<ReadTensorboardTimeSeriesDataRequest, ReadTensorboardTimeSeriesDataResponse> readTensorboardTimeSeriesDataSettings;
    private final ServerStreamingCallSettings<ReadTensorboardBlobDataRequest, ReadTensorboardBlobDataResponse> readTensorboardBlobDataSettings;
    private final UnaryCallSettings<WriteTensorboardExperimentDataRequest, WriteTensorboardExperimentDataResponse> writeTensorboardExperimentDataSettings;
    private final UnaryCallSettings<WriteTensorboardRunDataRequest, WriteTensorboardRunDataResponse> writeTensorboardRunDataSettings;
    private final PagedCallSettings<ExportTensorboardTimeSeriesDataRequest, ExportTensorboardTimeSeriesDataResponse, TensorboardServiceClient.ExportTensorboardTimeSeriesDataPagedResponse> exportTensorboardTimeSeriesDataSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, TensorboardServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListTensorboardsRequest, ListTensorboardsResponse, Tensorboard> LIST_TENSORBOARDS_PAGE_STR_DESC = new PagedListDescriptor<ListTensorboardsRequest, ListTensorboardsResponse, Tensorboard>(){

        public String emptyToken() {
            return "";
        }

        public ListTensorboardsRequest injectToken(ListTensorboardsRequest payload, String token) {
            return ListTensorboardsRequest.newBuilder((ListTensorboardsRequest)payload).setPageToken(token).build();
        }

        public ListTensorboardsRequest injectPageSize(ListTensorboardsRequest payload, int pageSize) {
            return ListTensorboardsRequest.newBuilder((ListTensorboardsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTensorboardsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTensorboardsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Tensorboard> extractResources(ListTensorboardsResponse payload) {
            return payload.getTensorboardsList() == null ? ImmutableList.of() : payload.getTensorboardsList();
        }
    };
    private static final PagedListDescriptor<ListTensorboardExperimentsRequest, ListTensorboardExperimentsResponse, TensorboardExperiment> LIST_TENSORBOARD_EXPERIMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListTensorboardExperimentsRequest, ListTensorboardExperimentsResponse, TensorboardExperiment>(){

        public String emptyToken() {
            return "";
        }

        public ListTensorboardExperimentsRequest injectToken(ListTensorboardExperimentsRequest payload, String token) {
            return ListTensorboardExperimentsRequest.newBuilder((ListTensorboardExperimentsRequest)payload).setPageToken(token).build();
        }

        public ListTensorboardExperimentsRequest injectPageSize(ListTensorboardExperimentsRequest payload, int pageSize) {
            return ListTensorboardExperimentsRequest.newBuilder((ListTensorboardExperimentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTensorboardExperimentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTensorboardExperimentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TensorboardExperiment> extractResources(ListTensorboardExperimentsResponse payload) {
            return payload.getTensorboardExperimentsList() == null ? ImmutableList.of() : payload.getTensorboardExperimentsList();
        }
    };
    private static final PagedListDescriptor<ListTensorboardRunsRequest, ListTensorboardRunsResponse, TensorboardRun> LIST_TENSORBOARD_RUNS_PAGE_STR_DESC = new PagedListDescriptor<ListTensorboardRunsRequest, ListTensorboardRunsResponse, TensorboardRun>(){

        public String emptyToken() {
            return "";
        }

        public ListTensorboardRunsRequest injectToken(ListTensorboardRunsRequest payload, String token) {
            return ListTensorboardRunsRequest.newBuilder((ListTensorboardRunsRequest)payload).setPageToken(token).build();
        }

        public ListTensorboardRunsRequest injectPageSize(ListTensorboardRunsRequest payload, int pageSize) {
            return ListTensorboardRunsRequest.newBuilder((ListTensorboardRunsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTensorboardRunsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTensorboardRunsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TensorboardRun> extractResources(ListTensorboardRunsResponse payload) {
            return payload.getTensorboardRunsList() == null ? ImmutableList.of() : payload.getTensorboardRunsList();
        }
    };
    private static final PagedListDescriptor<ListTensorboardTimeSeriesRequest, ListTensorboardTimeSeriesResponse, TensorboardTimeSeries> LIST_TENSORBOARD_TIME_SERIES_PAGE_STR_DESC = new PagedListDescriptor<ListTensorboardTimeSeriesRequest, ListTensorboardTimeSeriesResponse, TensorboardTimeSeries>(){

        public String emptyToken() {
            return "";
        }

        public ListTensorboardTimeSeriesRequest injectToken(ListTensorboardTimeSeriesRequest payload, String token) {
            return ListTensorboardTimeSeriesRequest.newBuilder((ListTensorboardTimeSeriesRequest)payload).setPageToken(token).build();
        }

        public ListTensorboardTimeSeriesRequest injectPageSize(ListTensorboardTimeSeriesRequest payload, int pageSize) {
            return ListTensorboardTimeSeriesRequest.newBuilder((ListTensorboardTimeSeriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTensorboardTimeSeriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTensorboardTimeSeriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TensorboardTimeSeries> extractResources(ListTensorboardTimeSeriesResponse payload) {
            return payload.getTensorboardTimeSeriesList() == null ? ImmutableList.of() : payload.getTensorboardTimeSeriesList();
        }
    };
    private static final PagedListDescriptor<ExportTensorboardTimeSeriesDataRequest, ExportTensorboardTimeSeriesDataResponse, TimeSeriesDataPoint> EXPORT_TENSORBOARD_TIME_SERIES_DATA_PAGE_STR_DESC = new PagedListDescriptor<ExportTensorboardTimeSeriesDataRequest, ExportTensorboardTimeSeriesDataResponse, TimeSeriesDataPoint>(){

        public String emptyToken() {
            return "";
        }

        public ExportTensorboardTimeSeriesDataRequest injectToken(ExportTensorboardTimeSeriesDataRequest payload, String token) {
            return ExportTensorboardTimeSeriesDataRequest.newBuilder((ExportTensorboardTimeSeriesDataRequest)payload).setPageToken(token).build();
        }

        public ExportTensorboardTimeSeriesDataRequest injectPageSize(ExportTensorboardTimeSeriesDataRequest payload, int pageSize) {
            return ExportTensorboardTimeSeriesDataRequest.newBuilder((ExportTensorboardTimeSeriesDataRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ExportTensorboardTimeSeriesDataRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ExportTensorboardTimeSeriesDataResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TimeSeriesDataPoint> extractResources(ExportTensorboardTimeSeriesDataResponse payload) {
            return payload.getTimeSeriesDataPointsList() == null ? ImmutableList.of() : payload.getTimeSeriesDataPointsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListTensorboardsRequest, ListTensorboardsResponse, TensorboardServiceClient.ListTensorboardsPagedResponse> LIST_TENSORBOARDS_PAGE_STR_FACT = new PagedListResponseFactory<ListTensorboardsRequest, ListTensorboardsResponse, TensorboardServiceClient.ListTensorboardsPagedResponse>(){

        public ApiFuture<TensorboardServiceClient.ListTensorboardsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTensorboardsRequest, ListTensorboardsResponse> callable, ListTensorboardsRequest request, ApiCallContext context, ApiFuture<ListTensorboardsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TENSORBOARDS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TensorboardServiceClient.ListTensorboardsPagedResponse.createAsync((PageContext<ListTensorboardsRequest, ListTensorboardsResponse, Tensorboard>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTensorboardExperimentsRequest, ListTensorboardExperimentsResponse, TensorboardServiceClient.ListTensorboardExperimentsPagedResponse> LIST_TENSORBOARD_EXPERIMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListTensorboardExperimentsRequest, ListTensorboardExperimentsResponse, TensorboardServiceClient.ListTensorboardExperimentsPagedResponse>(){

        public ApiFuture<TensorboardServiceClient.ListTensorboardExperimentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTensorboardExperimentsRequest, ListTensorboardExperimentsResponse> callable, ListTensorboardExperimentsRequest request, ApiCallContext context, ApiFuture<ListTensorboardExperimentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TENSORBOARD_EXPERIMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TensorboardServiceClient.ListTensorboardExperimentsPagedResponse.createAsync((PageContext<ListTensorboardExperimentsRequest, ListTensorboardExperimentsResponse, TensorboardExperiment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTensorboardRunsRequest, ListTensorboardRunsResponse, TensorboardServiceClient.ListTensorboardRunsPagedResponse> LIST_TENSORBOARD_RUNS_PAGE_STR_FACT = new PagedListResponseFactory<ListTensorboardRunsRequest, ListTensorboardRunsResponse, TensorboardServiceClient.ListTensorboardRunsPagedResponse>(){

        public ApiFuture<TensorboardServiceClient.ListTensorboardRunsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTensorboardRunsRequest, ListTensorboardRunsResponse> callable, ListTensorboardRunsRequest request, ApiCallContext context, ApiFuture<ListTensorboardRunsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TENSORBOARD_RUNS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TensorboardServiceClient.ListTensorboardRunsPagedResponse.createAsync((PageContext<ListTensorboardRunsRequest, ListTensorboardRunsResponse, TensorboardRun>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTensorboardTimeSeriesRequest, ListTensorboardTimeSeriesResponse, TensorboardServiceClient.ListTensorboardTimeSeriesPagedResponse> LIST_TENSORBOARD_TIME_SERIES_PAGE_STR_FACT = new PagedListResponseFactory<ListTensorboardTimeSeriesRequest, ListTensorboardTimeSeriesResponse, TensorboardServiceClient.ListTensorboardTimeSeriesPagedResponse>(){

        public ApiFuture<TensorboardServiceClient.ListTensorboardTimeSeriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTensorboardTimeSeriesRequest, ListTensorboardTimeSeriesResponse> callable, ListTensorboardTimeSeriesRequest request, ApiCallContext context, ApiFuture<ListTensorboardTimeSeriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TENSORBOARD_TIME_SERIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TensorboardServiceClient.ListTensorboardTimeSeriesPagedResponse.createAsync((PageContext<ListTensorboardTimeSeriesRequest, ListTensorboardTimeSeriesResponse, TensorboardTimeSeries>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ExportTensorboardTimeSeriesDataRequest, ExportTensorboardTimeSeriesDataResponse, TensorboardServiceClient.ExportTensorboardTimeSeriesDataPagedResponse> EXPORT_TENSORBOARD_TIME_SERIES_DATA_PAGE_STR_FACT = new PagedListResponseFactory<ExportTensorboardTimeSeriesDataRequest, ExportTensorboardTimeSeriesDataResponse, TensorboardServiceClient.ExportTensorboardTimeSeriesDataPagedResponse>(){

        public ApiFuture<TensorboardServiceClient.ExportTensorboardTimeSeriesDataPagedResponse> getFuturePagedResponse(UnaryCallable<ExportTensorboardTimeSeriesDataRequest, ExportTensorboardTimeSeriesDataResponse> callable, ExportTensorboardTimeSeriesDataRequest request, ApiCallContext context, ApiFuture<ExportTensorboardTimeSeriesDataResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)EXPORT_TENSORBOARD_TIME_SERIES_DATA_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TensorboardServiceClient.ExportTensorboardTimeSeriesDataPagedResponse.createAsync((PageContext<ExportTensorboardTimeSeriesDataRequest, ExportTensorboardTimeSeriesDataResponse, TimeSeriesDataPoint>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, TensorboardServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, TensorboardServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<TensorboardServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TensorboardServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateTensorboardRequest, Operation> createTensorboardSettings() {
        return this.createTensorboardSettings;
    }

    public OperationCallSettings<CreateTensorboardRequest, Tensorboard, CreateTensorboardOperationMetadata> createTensorboardOperationSettings() {
        return this.createTensorboardOperationSettings;
    }

    public UnaryCallSettings<GetTensorboardRequest, Tensorboard> getTensorboardSettings() {
        return this.getTensorboardSettings;
    }

    public UnaryCallSettings<UpdateTensorboardRequest, Operation> updateTensorboardSettings() {
        return this.updateTensorboardSettings;
    }

    public OperationCallSettings<UpdateTensorboardRequest, Tensorboard, UpdateTensorboardOperationMetadata> updateTensorboardOperationSettings() {
        return this.updateTensorboardOperationSettings;
    }

    public PagedCallSettings<ListTensorboardsRequest, ListTensorboardsResponse, TensorboardServiceClient.ListTensorboardsPagedResponse> listTensorboardsSettings() {
        return this.listTensorboardsSettings;
    }

    public UnaryCallSettings<DeleteTensorboardRequest, Operation> deleteTensorboardSettings() {
        return this.deleteTensorboardSettings;
    }

    public OperationCallSettings<DeleteTensorboardRequest, Empty, DeleteOperationMetadata> deleteTensorboardOperationSettings() {
        return this.deleteTensorboardOperationSettings;
    }

    public UnaryCallSettings<ReadTensorboardUsageRequest, ReadTensorboardUsageResponse> readTensorboardUsageSettings() {
        return this.readTensorboardUsageSettings;
    }

    public UnaryCallSettings<CreateTensorboardExperimentRequest, TensorboardExperiment> createTensorboardExperimentSettings() {
        return this.createTensorboardExperimentSettings;
    }

    public UnaryCallSettings<GetTensorboardExperimentRequest, TensorboardExperiment> getTensorboardExperimentSettings() {
        return this.getTensorboardExperimentSettings;
    }

    public UnaryCallSettings<UpdateTensorboardExperimentRequest, TensorboardExperiment> updateTensorboardExperimentSettings() {
        return this.updateTensorboardExperimentSettings;
    }

    public PagedCallSettings<ListTensorboardExperimentsRequest, ListTensorboardExperimentsResponse, TensorboardServiceClient.ListTensorboardExperimentsPagedResponse> listTensorboardExperimentsSettings() {
        return this.listTensorboardExperimentsSettings;
    }

    public UnaryCallSettings<DeleteTensorboardExperimentRequest, Operation> deleteTensorboardExperimentSettings() {
        return this.deleteTensorboardExperimentSettings;
    }

    public OperationCallSettings<DeleteTensorboardExperimentRequest, Empty, DeleteOperationMetadata> deleteTensorboardExperimentOperationSettings() {
        return this.deleteTensorboardExperimentOperationSettings;
    }

    public UnaryCallSettings<CreateTensorboardRunRequest, TensorboardRun> createTensorboardRunSettings() {
        return this.createTensorboardRunSettings;
    }

    public UnaryCallSettings<BatchCreateTensorboardRunsRequest, BatchCreateTensorboardRunsResponse> batchCreateTensorboardRunsSettings() {
        return this.batchCreateTensorboardRunsSettings;
    }

    public UnaryCallSettings<GetTensorboardRunRequest, TensorboardRun> getTensorboardRunSettings() {
        return this.getTensorboardRunSettings;
    }

    public UnaryCallSettings<UpdateTensorboardRunRequest, TensorboardRun> updateTensorboardRunSettings() {
        return this.updateTensorboardRunSettings;
    }

    public PagedCallSettings<ListTensorboardRunsRequest, ListTensorboardRunsResponse, TensorboardServiceClient.ListTensorboardRunsPagedResponse> listTensorboardRunsSettings() {
        return this.listTensorboardRunsSettings;
    }

    public UnaryCallSettings<DeleteTensorboardRunRequest, Operation> deleteTensorboardRunSettings() {
        return this.deleteTensorboardRunSettings;
    }

    public OperationCallSettings<DeleteTensorboardRunRequest, Empty, DeleteOperationMetadata> deleteTensorboardRunOperationSettings() {
        return this.deleteTensorboardRunOperationSettings;
    }

    public UnaryCallSettings<BatchCreateTensorboardTimeSeriesRequest, BatchCreateTensorboardTimeSeriesResponse> batchCreateTensorboardTimeSeriesSettings() {
        return this.batchCreateTensorboardTimeSeriesSettings;
    }

    public UnaryCallSettings<CreateTensorboardTimeSeriesRequest, TensorboardTimeSeries> createTensorboardTimeSeriesSettings() {
        return this.createTensorboardTimeSeriesSettings;
    }

    public UnaryCallSettings<GetTensorboardTimeSeriesRequest, TensorboardTimeSeries> getTensorboardTimeSeriesSettings() {
        return this.getTensorboardTimeSeriesSettings;
    }

    public UnaryCallSettings<UpdateTensorboardTimeSeriesRequest, TensorboardTimeSeries> updateTensorboardTimeSeriesSettings() {
        return this.updateTensorboardTimeSeriesSettings;
    }

    public PagedCallSettings<ListTensorboardTimeSeriesRequest, ListTensorboardTimeSeriesResponse, TensorboardServiceClient.ListTensorboardTimeSeriesPagedResponse> listTensorboardTimeSeriesSettings() {
        return this.listTensorboardTimeSeriesSettings;
    }

    public UnaryCallSettings<DeleteTensorboardTimeSeriesRequest, Operation> deleteTensorboardTimeSeriesSettings() {
        return this.deleteTensorboardTimeSeriesSettings;
    }

    public OperationCallSettings<DeleteTensorboardTimeSeriesRequest, Empty, DeleteOperationMetadata> deleteTensorboardTimeSeriesOperationSettings() {
        return this.deleteTensorboardTimeSeriesOperationSettings;
    }

    public UnaryCallSettings<BatchReadTensorboardTimeSeriesDataRequest, BatchReadTensorboardTimeSeriesDataResponse> batchReadTensorboardTimeSeriesDataSettings() {
        return this.batchReadTensorboardTimeSeriesDataSettings;
    }

    public UnaryCallSettings<ReadTensorboardTimeSeriesDataRequest, ReadTensorboardTimeSeriesDataResponse> readTensorboardTimeSeriesDataSettings() {
        return this.readTensorboardTimeSeriesDataSettings;
    }

    public ServerStreamingCallSettings<ReadTensorboardBlobDataRequest, ReadTensorboardBlobDataResponse> readTensorboardBlobDataSettings() {
        return this.readTensorboardBlobDataSettings;
    }

    public UnaryCallSettings<WriteTensorboardExperimentDataRequest, WriteTensorboardExperimentDataResponse> writeTensorboardExperimentDataSettings() {
        return this.writeTensorboardExperimentDataSettings;
    }

    public UnaryCallSettings<WriteTensorboardRunDataRequest, WriteTensorboardRunDataResponse> writeTensorboardRunDataSettings() {
        return this.writeTensorboardRunDataSettings;
    }

    public PagedCallSettings<ExportTensorboardTimeSeriesDataRequest, ExportTensorboardTimeSeriesDataResponse, TensorboardServiceClient.ExportTensorboardTimeSeriesDataPagedResponse> exportTensorboardTimeSeriesDataSettings() {
        return this.exportTensorboardTimeSeriesDataSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, TensorboardServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public TensorboardServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcTensorboardServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TensorboardServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TensorboardServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TensorboardServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createTensorboardSettings = settingsBuilder.createTensorboardSettings().build();
        this.createTensorboardOperationSettings = settingsBuilder.createTensorboardOperationSettings().build();
        this.getTensorboardSettings = settingsBuilder.getTensorboardSettings().build();
        this.updateTensorboardSettings = settingsBuilder.updateTensorboardSettings().build();
        this.updateTensorboardOperationSettings = settingsBuilder.updateTensorboardOperationSettings().build();
        this.listTensorboardsSettings = settingsBuilder.listTensorboardsSettings().build();
        this.deleteTensorboardSettings = settingsBuilder.deleteTensorboardSettings().build();
        this.deleteTensorboardOperationSettings = settingsBuilder.deleteTensorboardOperationSettings().build();
        this.readTensorboardUsageSettings = settingsBuilder.readTensorboardUsageSettings().build();
        this.createTensorboardExperimentSettings = settingsBuilder.createTensorboardExperimentSettings().build();
        this.getTensorboardExperimentSettings = settingsBuilder.getTensorboardExperimentSettings().build();
        this.updateTensorboardExperimentSettings = settingsBuilder.updateTensorboardExperimentSettings().build();
        this.listTensorboardExperimentsSettings = settingsBuilder.listTensorboardExperimentsSettings().build();
        this.deleteTensorboardExperimentSettings = settingsBuilder.deleteTensorboardExperimentSettings().build();
        this.deleteTensorboardExperimentOperationSettings = settingsBuilder.deleteTensorboardExperimentOperationSettings().build();
        this.createTensorboardRunSettings = settingsBuilder.createTensorboardRunSettings().build();
        this.batchCreateTensorboardRunsSettings = settingsBuilder.batchCreateTensorboardRunsSettings().build();
        this.getTensorboardRunSettings = settingsBuilder.getTensorboardRunSettings().build();
        this.updateTensorboardRunSettings = settingsBuilder.updateTensorboardRunSettings().build();
        this.listTensorboardRunsSettings = settingsBuilder.listTensorboardRunsSettings().build();
        this.deleteTensorboardRunSettings = settingsBuilder.deleteTensorboardRunSettings().build();
        this.deleteTensorboardRunOperationSettings = settingsBuilder.deleteTensorboardRunOperationSettings().build();
        this.batchCreateTensorboardTimeSeriesSettings = settingsBuilder.batchCreateTensorboardTimeSeriesSettings().build();
        this.createTensorboardTimeSeriesSettings = settingsBuilder.createTensorboardTimeSeriesSettings().build();
        this.getTensorboardTimeSeriesSettings = settingsBuilder.getTensorboardTimeSeriesSettings().build();
        this.updateTensorboardTimeSeriesSettings = settingsBuilder.updateTensorboardTimeSeriesSettings().build();
        this.listTensorboardTimeSeriesSettings = settingsBuilder.listTensorboardTimeSeriesSettings().build();
        this.deleteTensorboardTimeSeriesSettings = settingsBuilder.deleteTensorboardTimeSeriesSettings().build();
        this.deleteTensorboardTimeSeriesOperationSettings = settingsBuilder.deleteTensorboardTimeSeriesOperationSettings().build();
        this.batchReadTensorboardTimeSeriesDataSettings = settingsBuilder.batchReadTensorboardTimeSeriesDataSettings().build();
        this.readTensorboardTimeSeriesDataSettings = settingsBuilder.readTensorboardTimeSeriesDataSettings().build();
        this.readTensorboardBlobDataSettings = settingsBuilder.readTensorboardBlobDataSettings().build();
        this.writeTensorboardExperimentDataSettings = settingsBuilder.writeTensorboardExperimentDataSettings().build();
        this.writeTensorboardRunDataSettings = settingsBuilder.writeTensorboardRunDataSettings().build();
        this.exportTensorboardTimeSeriesDataSettings = settingsBuilder.exportTensorboardTimeSeriesDataSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TensorboardServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateTensorboardRequest, Operation> createTensorboardSettings;
        private final OperationCallSettings.Builder<CreateTensorboardRequest, Tensorboard, CreateTensorboardOperationMetadata> createTensorboardOperationSettings;
        private final UnaryCallSettings.Builder<GetTensorboardRequest, Tensorboard> getTensorboardSettings;
        private final UnaryCallSettings.Builder<UpdateTensorboardRequest, Operation> updateTensorboardSettings;
        private final OperationCallSettings.Builder<UpdateTensorboardRequest, Tensorboard, UpdateTensorboardOperationMetadata> updateTensorboardOperationSettings;
        private final PagedCallSettings.Builder<ListTensorboardsRequest, ListTensorboardsResponse, TensorboardServiceClient.ListTensorboardsPagedResponse> listTensorboardsSettings;
        private final UnaryCallSettings.Builder<DeleteTensorboardRequest, Operation> deleteTensorboardSettings;
        private final OperationCallSettings.Builder<DeleteTensorboardRequest, Empty, DeleteOperationMetadata> deleteTensorboardOperationSettings;
        private final UnaryCallSettings.Builder<ReadTensorboardUsageRequest, ReadTensorboardUsageResponse> readTensorboardUsageSettings;
        private final UnaryCallSettings.Builder<CreateTensorboardExperimentRequest, TensorboardExperiment> createTensorboardExperimentSettings;
        private final UnaryCallSettings.Builder<GetTensorboardExperimentRequest, TensorboardExperiment> getTensorboardExperimentSettings;
        private final UnaryCallSettings.Builder<UpdateTensorboardExperimentRequest, TensorboardExperiment> updateTensorboardExperimentSettings;
        private final PagedCallSettings.Builder<ListTensorboardExperimentsRequest, ListTensorboardExperimentsResponse, TensorboardServiceClient.ListTensorboardExperimentsPagedResponse> listTensorboardExperimentsSettings;
        private final UnaryCallSettings.Builder<DeleteTensorboardExperimentRequest, Operation> deleteTensorboardExperimentSettings;
        private final OperationCallSettings.Builder<DeleteTensorboardExperimentRequest, Empty, DeleteOperationMetadata> deleteTensorboardExperimentOperationSettings;
        private final UnaryCallSettings.Builder<CreateTensorboardRunRequest, TensorboardRun> createTensorboardRunSettings;
        private final UnaryCallSettings.Builder<BatchCreateTensorboardRunsRequest, BatchCreateTensorboardRunsResponse> batchCreateTensorboardRunsSettings;
        private final UnaryCallSettings.Builder<GetTensorboardRunRequest, TensorboardRun> getTensorboardRunSettings;
        private final UnaryCallSettings.Builder<UpdateTensorboardRunRequest, TensorboardRun> updateTensorboardRunSettings;
        private final PagedCallSettings.Builder<ListTensorboardRunsRequest, ListTensorboardRunsResponse, TensorboardServiceClient.ListTensorboardRunsPagedResponse> listTensorboardRunsSettings;
        private final UnaryCallSettings.Builder<DeleteTensorboardRunRequest, Operation> deleteTensorboardRunSettings;
        private final OperationCallSettings.Builder<DeleteTensorboardRunRequest, Empty, DeleteOperationMetadata> deleteTensorboardRunOperationSettings;
        private final UnaryCallSettings.Builder<BatchCreateTensorboardTimeSeriesRequest, BatchCreateTensorboardTimeSeriesResponse> batchCreateTensorboardTimeSeriesSettings;
        private final UnaryCallSettings.Builder<CreateTensorboardTimeSeriesRequest, TensorboardTimeSeries> createTensorboardTimeSeriesSettings;
        private final UnaryCallSettings.Builder<GetTensorboardTimeSeriesRequest, TensorboardTimeSeries> getTensorboardTimeSeriesSettings;
        private final UnaryCallSettings.Builder<UpdateTensorboardTimeSeriesRequest, TensorboardTimeSeries> updateTensorboardTimeSeriesSettings;
        private final PagedCallSettings.Builder<ListTensorboardTimeSeriesRequest, ListTensorboardTimeSeriesResponse, TensorboardServiceClient.ListTensorboardTimeSeriesPagedResponse> listTensorboardTimeSeriesSettings;
        private final UnaryCallSettings.Builder<DeleteTensorboardTimeSeriesRequest, Operation> deleteTensorboardTimeSeriesSettings;
        private final OperationCallSettings.Builder<DeleteTensorboardTimeSeriesRequest, Empty, DeleteOperationMetadata> deleteTensorboardTimeSeriesOperationSettings;
        private final UnaryCallSettings.Builder<BatchReadTensorboardTimeSeriesDataRequest, BatchReadTensorboardTimeSeriesDataResponse> batchReadTensorboardTimeSeriesDataSettings;
        private final UnaryCallSettings.Builder<ReadTensorboardTimeSeriesDataRequest, ReadTensorboardTimeSeriesDataResponse> readTensorboardTimeSeriesDataSettings;
        private final ServerStreamingCallSettings.Builder<ReadTensorboardBlobDataRequest, ReadTensorboardBlobDataResponse> readTensorboardBlobDataSettings;
        private final UnaryCallSettings.Builder<WriteTensorboardExperimentDataRequest, WriteTensorboardExperimentDataResponse> writeTensorboardExperimentDataSettings;
        private final UnaryCallSettings.Builder<WriteTensorboardRunDataRequest, WriteTensorboardRunDataResponse> writeTensorboardRunDataSettings;
        private final PagedCallSettings.Builder<ExportTensorboardTimeSeriesDataRequest, ExportTensorboardTimeSeriesDataResponse, TensorboardServiceClient.ExportTensorboardTimeSeriesDataPagedResponse> exportTensorboardTimeSeriesDataSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, TensorboardServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createTensorboardSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTensorboardOperationSettings = OperationCallSettings.newBuilder();
            this.getTensorboardSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTensorboardSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTensorboardOperationSettings = OperationCallSettings.newBuilder();
            this.listTensorboardsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TENSORBOARDS_PAGE_STR_FACT);
            this.deleteTensorboardSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTensorboardOperationSettings = OperationCallSettings.newBuilder();
            this.readTensorboardUsageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTensorboardExperimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTensorboardExperimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTensorboardExperimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTensorboardExperimentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TENSORBOARD_EXPERIMENTS_PAGE_STR_FACT);
            this.deleteTensorboardExperimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTensorboardExperimentOperationSettings = OperationCallSettings.newBuilder();
            this.createTensorboardRunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCreateTensorboardRunsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTensorboardRunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTensorboardRunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTensorboardRunsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TENSORBOARD_RUNS_PAGE_STR_FACT);
            this.deleteTensorboardRunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTensorboardRunOperationSettings = OperationCallSettings.newBuilder();
            this.batchCreateTensorboardTimeSeriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTensorboardTimeSeriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTensorboardTimeSeriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTensorboardTimeSeriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTensorboardTimeSeriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TENSORBOARD_TIME_SERIES_PAGE_STR_FACT);
            this.deleteTensorboardTimeSeriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTensorboardTimeSeriesOperationSettings = OperationCallSettings.newBuilder();
            this.batchReadTensorboardTimeSeriesDataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.readTensorboardTimeSeriesDataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.readTensorboardBlobDataSettings = ServerStreamingCallSettings.newBuilder();
            this.writeTensorboardExperimentDataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.writeTensorboardRunDataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportTensorboardTimeSeriesDataSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)EXPORT_TENSORBOARD_TIME_SERIES_DATA_PAGE_STR_FACT);
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTensorboardSettings, this.getTensorboardSettings, this.updateTensorboardSettings, this.listTensorboardsSettings, this.deleteTensorboardSettings, this.readTensorboardUsageSettings, this.createTensorboardExperimentSettings, this.getTensorboardExperimentSettings, this.updateTensorboardExperimentSettings, this.listTensorboardExperimentsSettings, this.deleteTensorboardExperimentSettings, this.createTensorboardRunSettings, (Object[])new UnaryCallSettings.Builder[]{this.batchCreateTensorboardRunsSettings, this.getTensorboardRunSettings, this.updateTensorboardRunSettings, this.listTensorboardRunsSettings, this.deleteTensorboardRunSettings, this.batchCreateTensorboardTimeSeriesSettings, this.createTensorboardTimeSeriesSettings, this.getTensorboardTimeSeriesSettings, this.updateTensorboardTimeSeriesSettings, this.listTensorboardTimeSeriesSettings, this.deleteTensorboardTimeSeriesSettings, this.batchReadTensorboardTimeSeriesDataSettings, this.readTensorboardTimeSeriesDataSettings, this.writeTensorboardExperimentDataSettings, this.writeTensorboardRunDataSettings, this.exportTensorboardTimeSeriesDataSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(TensorboardServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createTensorboardSettings = settings.createTensorboardSettings.toBuilder();
            this.createTensorboardOperationSettings = settings.createTensorboardOperationSettings.toBuilder();
            this.getTensorboardSettings = settings.getTensorboardSettings.toBuilder();
            this.updateTensorboardSettings = settings.updateTensorboardSettings.toBuilder();
            this.updateTensorboardOperationSettings = settings.updateTensorboardOperationSettings.toBuilder();
            this.listTensorboardsSettings = settings.listTensorboardsSettings.toBuilder();
            this.deleteTensorboardSettings = settings.deleteTensorboardSettings.toBuilder();
            this.deleteTensorboardOperationSettings = settings.deleteTensorboardOperationSettings.toBuilder();
            this.readTensorboardUsageSettings = settings.readTensorboardUsageSettings.toBuilder();
            this.createTensorboardExperimentSettings = settings.createTensorboardExperimentSettings.toBuilder();
            this.getTensorboardExperimentSettings = settings.getTensorboardExperimentSettings.toBuilder();
            this.updateTensorboardExperimentSettings = settings.updateTensorboardExperimentSettings.toBuilder();
            this.listTensorboardExperimentsSettings = settings.listTensorboardExperimentsSettings.toBuilder();
            this.deleteTensorboardExperimentSettings = settings.deleteTensorboardExperimentSettings.toBuilder();
            this.deleteTensorboardExperimentOperationSettings = settings.deleteTensorboardExperimentOperationSettings.toBuilder();
            this.createTensorboardRunSettings = settings.createTensorboardRunSettings.toBuilder();
            this.batchCreateTensorboardRunsSettings = settings.batchCreateTensorboardRunsSettings.toBuilder();
            this.getTensorboardRunSettings = settings.getTensorboardRunSettings.toBuilder();
            this.updateTensorboardRunSettings = settings.updateTensorboardRunSettings.toBuilder();
            this.listTensorboardRunsSettings = settings.listTensorboardRunsSettings.toBuilder();
            this.deleteTensorboardRunSettings = settings.deleteTensorboardRunSettings.toBuilder();
            this.deleteTensorboardRunOperationSettings = settings.deleteTensorboardRunOperationSettings.toBuilder();
            this.batchCreateTensorboardTimeSeriesSettings = settings.batchCreateTensorboardTimeSeriesSettings.toBuilder();
            this.createTensorboardTimeSeriesSettings = settings.createTensorboardTimeSeriesSettings.toBuilder();
            this.getTensorboardTimeSeriesSettings = settings.getTensorboardTimeSeriesSettings.toBuilder();
            this.updateTensorboardTimeSeriesSettings = settings.updateTensorboardTimeSeriesSettings.toBuilder();
            this.listTensorboardTimeSeriesSettings = settings.listTensorboardTimeSeriesSettings.toBuilder();
            this.deleteTensorboardTimeSeriesSettings = settings.deleteTensorboardTimeSeriesSettings.toBuilder();
            this.deleteTensorboardTimeSeriesOperationSettings = settings.deleteTensorboardTimeSeriesOperationSettings.toBuilder();
            this.batchReadTensorboardTimeSeriesDataSettings = settings.batchReadTensorboardTimeSeriesDataSettings.toBuilder();
            this.readTensorboardTimeSeriesDataSettings = settings.readTensorboardTimeSeriesDataSettings.toBuilder();
            this.readTensorboardBlobDataSettings = settings.readTensorboardBlobDataSettings.toBuilder();
            this.writeTensorboardExperimentDataSettings = settings.writeTensorboardExperimentDataSettings.toBuilder();
            this.writeTensorboardRunDataSettings = settings.writeTensorboardRunDataSettings.toBuilder();
            this.exportTensorboardTimeSeriesDataSettings = settings.exportTensorboardTimeSeriesDataSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTensorboardSettings, this.getTensorboardSettings, this.updateTensorboardSettings, this.listTensorboardsSettings, this.deleteTensorboardSettings, this.readTensorboardUsageSettings, this.createTensorboardExperimentSettings, this.getTensorboardExperimentSettings, this.updateTensorboardExperimentSettings, this.listTensorboardExperimentsSettings, this.deleteTensorboardExperimentSettings, this.createTensorboardRunSettings, (Object[])new UnaryCallSettings.Builder[]{this.batchCreateTensorboardRunsSettings, this.getTensorboardRunSettings, this.updateTensorboardRunSettings, this.listTensorboardRunsSettings, this.deleteTensorboardRunSettings, this.batchCreateTensorboardTimeSeriesSettings, this.createTensorboardTimeSeriesSettings, this.getTensorboardTimeSeriesSettings, this.updateTensorboardTimeSeriesSettings, this.listTensorboardTimeSeriesSettings, this.deleteTensorboardTimeSeriesSettings, this.batchReadTensorboardTimeSeriesDataSettings, this.readTensorboardTimeSeriesDataSettings, this.writeTensorboardExperimentDataSettings, this.writeTensorboardRunDataSettings, this.exportTensorboardTimeSeriesDataSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TensorboardServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TensorboardServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TensorboardServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TensorboardServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(TensorboardServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createTensorboardSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getTensorboardSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateTensorboardSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listTensorboardsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteTensorboardSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.readTensorboardUsageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createTensorboardExperimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getTensorboardExperimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateTensorboardExperimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listTensorboardExperimentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteTensorboardExperimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createTensorboardRunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchCreateTensorboardRunsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getTensorboardRunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateTensorboardRunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listTensorboardRunsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteTensorboardRunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchCreateTensorboardTimeSeriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createTensorboardTimeSeriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getTensorboardTimeSeriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateTensorboardTimeSeriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listTensorboardTimeSeriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteTensorboardTimeSeriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchReadTensorboardTimeSeriesDataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.readTensorboardTimeSeriesDataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.readTensorboardBlobDataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.writeTensorboardExperimentDataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.writeTensorboardRunDataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.exportTensorboardTimeSeriesDataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createTensorboardOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Tensorboard.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateTensorboardOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateTensorboardOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Tensorboard.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateTensorboardOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteTensorboardOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteTensorboardExperimentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteTensorboardRunOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteTensorboardTimeSeriesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateTensorboardRequest, Operation> createTensorboardSettings() {
            return this.createTensorboardSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateTensorboardRequest, Tensorboard, CreateTensorboardOperationMetadata> createTensorboardOperationSettings() {
            return this.createTensorboardOperationSettings;
        }

        public UnaryCallSettings.Builder<GetTensorboardRequest, Tensorboard> getTensorboardSettings() {
            return this.getTensorboardSettings;
        }

        public UnaryCallSettings.Builder<UpdateTensorboardRequest, Operation> updateTensorboardSettings() {
            return this.updateTensorboardSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateTensorboardRequest, Tensorboard, UpdateTensorboardOperationMetadata> updateTensorboardOperationSettings() {
            return this.updateTensorboardOperationSettings;
        }

        public PagedCallSettings.Builder<ListTensorboardsRequest, ListTensorboardsResponse, TensorboardServiceClient.ListTensorboardsPagedResponse> listTensorboardsSettings() {
            return this.listTensorboardsSettings;
        }

        public UnaryCallSettings.Builder<DeleteTensorboardRequest, Operation> deleteTensorboardSettings() {
            return this.deleteTensorboardSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteTensorboardRequest, Empty, DeleteOperationMetadata> deleteTensorboardOperationSettings() {
            return this.deleteTensorboardOperationSettings;
        }

        public UnaryCallSettings.Builder<ReadTensorboardUsageRequest, ReadTensorboardUsageResponse> readTensorboardUsageSettings() {
            return this.readTensorboardUsageSettings;
        }

        public UnaryCallSettings.Builder<CreateTensorboardExperimentRequest, TensorboardExperiment> createTensorboardExperimentSettings() {
            return this.createTensorboardExperimentSettings;
        }

        public UnaryCallSettings.Builder<GetTensorboardExperimentRequest, TensorboardExperiment> getTensorboardExperimentSettings() {
            return this.getTensorboardExperimentSettings;
        }

        public UnaryCallSettings.Builder<UpdateTensorboardExperimentRequest, TensorboardExperiment> updateTensorboardExperimentSettings() {
            return this.updateTensorboardExperimentSettings;
        }

        public PagedCallSettings.Builder<ListTensorboardExperimentsRequest, ListTensorboardExperimentsResponse, TensorboardServiceClient.ListTensorboardExperimentsPagedResponse> listTensorboardExperimentsSettings() {
            return this.listTensorboardExperimentsSettings;
        }

        public UnaryCallSettings.Builder<DeleteTensorboardExperimentRequest, Operation> deleteTensorboardExperimentSettings() {
            return this.deleteTensorboardExperimentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteTensorboardExperimentRequest, Empty, DeleteOperationMetadata> deleteTensorboardExperimentOperationSettings() {
            return this.deleteTensorboardExperimentOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateTensorboardRunRequest, TensorboardRun> createTensorboardRunSettings() {
            return this.createTensorboardRunSettings;
        }

        public UnaryCallSettings.Builder<BatchCreateTensorboardRunsRequest, BatchCreateTensorboardRunsResponse> batchCreateTensorboardRunsSettings() {
            return this.batchCreateTensorboardRunsSettings;
        }

        public UnaryCallSettings.Builder<GetTensorboardRunRequest, TensorboardRun> getTensorboardRunSettings() {
            return this.getTensorboardRunSettings;
        }

        public UnaryCallSettings.Builder<UpdateTensorboardRunRequest, TensorboardRun> updateTensorboardRunSettings() {
            return this.updateTensorboardRunSettings;
        }

        public PagedCallSettings.Builder<ListTensorboardRunsRequest, ListTensorboardRunsResponse, TensorboardServiceClient.ListTensorboardRunsPagedResponse> listTensorboardRunsSettings() {
            return this.listTensorboardRunsSettings;
        }

        public UnaryCallSettings.Builder<DeleteTensorboardRunRequest, Operation> deleteTensorboardRunSettings() {
            return this.deleteTensorboardRunSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteTensorboardRunRequest, Empty, DeleteOperationMetadata> deleteTensorboardRunOperationSettings() {
            return this.deleteTensorboardRunOperationSettings;
        }

        public UnaryCallSettings.Builder<BatchCreateTensorboardTimeSeriesRequest, BatchCreateTensorboardTimeSeriesResponse> batchCreateTensorboardTimeSeriesSettings() {
            return this.batchCreateTensorboardTimeSeriesSettings;
        }

        public UnaryCallSettings.Builder<CreateTensorboardTimeSeriesRequest, TensorboardTimeSeries> createTensorboardTimeSeriesSettings() {
            return this.createTensorboardTimeSeriesSettings;
        }

        public UnaryCallSettings.Builder<GetTensorboardTimeSeriesRequest, TensorboardTimeSeries> getTensorboardTimeSeriesSettings() {
            return this.getTensorboardTimeSeriesSettings;
        }

        public UnaryCallSettings.Builder<UpdateTensorboardTimeSeriesRequest, TensorboardTimeSeries> updateTensorboardTimeSeriesSettings() {
            return this.updateTensorboardTimeSeriesSettings;
        }

        public PagedCallSettings.Builder<ListTensorboardTimeSeriesRequest, ListTensorboardTimeSeriesResponse, TensorboardServiceClient.ListTensorboardTimeSeriesPagedResponse> listTensorboardTimeSeriesSettings() {
            return this.listTensorboardTimeSeriesSettings;
        }

        public UnaryCallSettings.Builder<DeleteTensorboardTimeSeriesRequest, Operation> deleteTensorboardTimeSeriesSettings() {
            return this.deleteTensorboardTimeSeriesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteTensorboardTimeSeriesRequest, Empty, DeleteOperationMetadata> deleteTensorboardTimeSeriesOperationSettings() {
            return this.deleteTensorboardTimeSeriesOperationSettings;
        }

        public UnaryCallSettings.Builder<BatchReadTensorboardTimeSeriesDataRequest, BatchReadTensorboardTimeSeriesDataResponse> batchReadTensorboardTimeSeriesDataSettings() {
            return this.batchReadTensorboardTimeSeriesDataSettings;
        }

        public UnaryCallSettings.Builder<ReadTensorboardTimeSeriesDataRequest, ReadTensorboardTimeSeriesDataResponse> readTensorboardTimeSeriesDataSettings() {
            return this.readTensorboardTimeSeriesDataSettings;
        }

        public ServerStreamingCallSettings.Builder<ReadTensorboardBlobDataRequest, ReadTensorboardBlobDataResponse> readTensorboardBlobDataSettings() {
            return this.readTensorboardBlobDataSettings;
        }

        public UnaryCallSettings.Builder<WriteTensorboardExperimentDataRequest, WriteTensorboardExperimentDataResponse> writeTensorboardExperimentDataSettings() {
            return this.writeTensorboardExperimentDataSettings;
        }

        public UnaryCallSettings.Builder<WriteTensorboardRunDataRequest, WriteTensorboardRunDataResponse> writeTensorboardRunDataSettings() {
            return this.writeTensorboardRunDataSettings;
        }

        public PagedCallSettings.Builder<ExportTensorboardTimeSeriesDataRequest, ExportTensorboardTimeSeriesDataResponse, TensorboardServiceClient.ExportTensorboardTimeSeriesDataPagedResponse> exportTensorboardTimeSeriesDataSettings() {
            return this.exportTensorboardTimeSeriesDataSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, TensorboardServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public TensorboardServiceStubSettings build() throws IOException {
            return new TensorboardServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

