/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.BatchImportModelEvaluationSlicesRequest;
import com.google.cloud.aiplatform.v1.BatchImportModelEvaluationSlicesResponse;
import com.google.cloud.aiplatform.v1.CopyModelOperationMetadata;
import com.google.cloud.aiplatform.v1.CopyModelRequest;
import com.google.cloud.aiplatform.v1.CopyModelResponse;
import com.google.cloud.aiplatform.v1.DeleteModelRequest;
import com.google.cloud.aiplatform.v1.DeleteModelVersionRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.ExportModelOperationMetadata;
import com.google.cloud.aiplatform.v1.ExportModelRequest;
import com.google.cloud.aiplatform.v1.ExportModelResponse;
import com.google.cloud.aiplatform.v1.GetModelEvaluationRequest;
import com.google.cloud.aiplatform.v1.GetModelEvaluationSliceRequest;
import com.google.cloud.aiplatform.v1.GetModelRequest;
import com.google.cloud.aiplatform.v1.ImportModelEvaluationRequest;
import com.google.cloud.aiplatform.v1.ListModelEvaluationSlicesRequest;
import com.google.cloud.aiplatform.v1.ListModelEvaluationSlicesResponse;
import com.google.cloud.aiplatform.v1.ListModelEvaluationsRequest;
import com.google.cloud.aiplatform.v1.ListModelEvaluationsResponse;
import com.google.cloud.aiplatform.v1.ListModelVersionsRequest;
import com.google.cloud.aiplatform.v1.ListModelVersionsResponse;
import com.google.cloud.aiplatform.v1.ListModelsRequest;
import com.google.cloud.aiplatform.v1.ListModelsResponse;
import com.google.cloud.aiplatform.v1.MergeVersionAliasesRequest;
import com.google.cloud.aiplatform.v1.Model;
import com.google.cloud.aiplatform.v1.ModelEvaluation;
import com.google.cloud.aiplatform.v1.ModelEvaluationSlice;
import com.google.cloud.aiplatform.v1.ModelServiceClient;
import com.google.cloud.aiplatform.v1.UpdateModelRequest;
import com.google.cloud.aiplatform.v1.UploadModelOperationMetadata;
import com.google.cloud.aiplatform.v1.UploadModelRequest;
import com.google.cloud.aiplatform.v1.UploadModelResponse;
import com.google.cloud.aiplatform.v1.stub.GrpcModelServiceCallableFactory;
import com.google.cloud.aiplatform.v1.stub.ModelServiceStub;
import com.google.cloud.aiplatform.v1.stub.ModelServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcModelServiceStub
extends ModelServiceStub {
    private static final MethodDescriptor<UploadModelRequest, Operation> uploadModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.ModelService/UploadModel").setRequestMarshaller(ProtoUtils.marshaller((Message)UploadModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetModelRequest, Model> getModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.ModelService/GetModel").setRequestMarshaller(ProtoUtils.marshaller((Message)GetModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Model.getDefaultInstance())).build();
    private static final MethodDescriptor<ListModelsRequest, ListModelsResponse> listModelsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.ModelService/ListModels").setRequestMarshaller(ProtoUtils.marshaller((Message)ListModelsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListModelsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListModelVersionsRequest, ListModelVersionsResponse> listModelVersionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.ModelService/ListModelVersions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListModelVersionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListModelVersionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateModelRequest, Model> updateModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.ModelService/UpdateModel").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Model.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteModelRequest, Operation> deleteModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.ModelService/DeleteModel").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteModelVersionRequest, Operation> deleteModelVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.ModelService/DeleteModelVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteModelVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<MergeVersionAliasesRequest, Model> mergeVersionAliasesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.ModelService/MergeVersionAliases").setRequestMarshaller(ProtoUtils.marshaller((Message)MergeVersionAliasesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Model.getDefaultInstance())).build();
    private static final MethodDescriptor<ExportModelRequest, Operation> exportModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.ModelService/ExportModel").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<CopyModelRequest, Operation> copyModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.ModelService/CopyModel").setRequestMarshaller(ProtoUtils.marshaller((Message)CopyModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ImportModelEvaluationRequest, ModelEvaluation> importModelEvaluationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.ModelService/ImportModelEvaluation").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportModelEvaluationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ModelEvaluation.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchImportModelEvaluationSlicesRequest, BatchImportModelEvaluationSlicesResponse> batchImportModelEvaluationSlicesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.ModelService/BatchImportModelEvaluationSlices").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchImportModelEvaluationSlicesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BatchImportModelEvaluationSlicesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.ModelService/GetModelEvaluation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetModelEvaluationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ModelEvaluation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListModelEvaluationsRequest, ListModelEvaluationsResponse> listModelEvaluationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.ModelService/ListModelEvaluations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListModelEvaluationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListModelEvaluationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetModelEvaluationSliceRequest, ModelEvaluationSlice> getModelEvaluationSliceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.ModelService/GetModelEvaluationSlice").setRequestMarshaller(ProtoUtils.marshaller((Message)GetModelEvaluationSliceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ModelEvaluationSlice.getDefaultInstance())).build();
    private static final MethodDescriptor<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse> listModelEvaluationSlicesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1.ModelService/ListModelEvaluationSlices").setRequestMarshaller(ProtoUtils.marshaller((Message)ListModelEvaluationSlicesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListModelEvaluationSlicesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<UploadModelRequest, Operation> uploadModelCallable;
    private final OperationCallable<UploadModelRequest, UploadModelResponse, UploadModelOperationMetadata> uploadModelOperationCallable;
    private final UnaryCallable<GetModelRequest, Model> getModelCallable;
    private final UnaryCallable<ListModelsRequest, ListModelsResponse> listModelsCallable;
    private final UnaryCallable<ListModelsRequest, ModelServiceClient.ListModelsPagedResponse> listModelsPagedCallable;
    private final UnaryCallable<ListModelVersionsRequest, ListModelVersionsResponse> listModelVersionsCallable;
    private final UnaryCallable<ListModelVersionsRequest, ModelServiceClient.ListModelVersionsPagedResponse> listModelVersionsPagedCallable;
    private final UnaryCallable<UpdateModelRequest, Model> updateModelCallable;
    private final UnaryCallable<DeleteModelRequest, Operation> deleteModelCallable;
    private final OperationCallable<DeleteModelRequest, Empty, DeleteOperationMetadata> deleteModelOperationCallable;
    private final UnaryCallable<DeleteModelVersionRequest, Operation> deleteModelVersionCallable;
    private final OperationCallable<DeleteModelVersionRequest, Empty, DeleteOperationMetadata> deleteModelVersionOperationCallable;
    private final UnaryCallable<MergeVersionAliasesRequest, Model> mergeVersionAliasesCallable;
    private final UnaryCallable<ExportModelRequest, Operation> exportModelCallable;
    private final OperationCallable<ExportModelRequest, ExportModelResponse, ExportModelOperationMetadata> exportModelOperationCallable;
    private final UnaryCallable<CopyModelRequest, Operation> copyModelCallable;
    private final OperationCallable<CopyModelRequest, CopyModelResponse, CopyModelOperationMetadata> copyModelOperationCallable;
    private final UnaryCallable<ImportModelEvaluationRequest, ModelEvaluation> importModelEvaluationCallable;
    private final UnaryCallable<BatchImportModelEvaluationSlicesRequest, BatchImportModelEvaluationSlicesResponse> batchImportModelEvaluationSlicesCallable;
    private final UnaryCallable<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationCallable;
    private final UnaryCallable<ListModelEvaluationsRequest, ListModelEvaluationsResponse> listModelEvaluationsCallable;
    private final UnaryCallable<ListModelEvaluationsRequest, ModelServiceClient.ListModelEvaluationsPagedResponse> listModelEvaluationsPagedCallable;
    private final UnaryCallable<GetModelEvaluationSliceRequest, ModelEvaluationSlice> getModelEvaluationSliceCallable;
    private final UnaryCallable<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse> listModelEvaluationSlicesCallable;
    private final UnaryCallable<ListModelEvaluationSlicesRequest, ModelServiceClient.ListModelEvaluationSlicesPagedResponse> listModelEvaluationSlicesPagedCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ModelServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcModelServiceStub create(ModelServiceStubSettings settings) throws IOException {
        return new GrpcModelServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcModelServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcModelServiceStub(ModelServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcModelServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcModelServiceStub(ModelServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcModelServiceStub(ModelServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcModelServiceCallableFactory());
    }

    protected GrpcModelServiceStub(ModelServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings uploadModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(uploadModelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getModelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listModelsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listModelsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings listModelVersionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listModelVersionsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateModelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"model.name", (Object)String.valueOf(request.getModel().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteModelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteModelVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteModelVersionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings mergeVersionAliasesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mergeVersionAliasesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings exportModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportModelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings copyModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(copyModelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings importModelEvaluationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importModelEvaluationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings batchImportModelEvaluationSlicesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchImportModelEvaluationSlicesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getModelEvaluationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getModelEvaluationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listModelEvaluationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listModelEvaluationsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getModelEvaluationSliceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getModelEvaluationSliceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listModelEvaluationSlicesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listModelEvaluationSlicesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        this.uploadModelCallable = callableFactory.createUnaryCallable(uploadModelTransportSettings, settings.uploadModelSettings(), clientContext);
        this.uploadModelOperationCallable = callableFactory.createOperationCallable(uploadModelTransportSettings, settings.uploadModelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getModelCallable = callableFactory.createUnaryCallable(getModelTransportSettings, settings.getModelSettings(), clientContext);
        this.listModelsCallable = callableFactory.createUnaryCallable(listModelsTransportSettings, settings.listModelsSettings(), clientContext);
        this.listModelsPagedCallable = callableFactory.createPagedCallable(listModelsTransportSettings, settings.listModelsSettings(), clientContext);
        this.listModelVersionsCallable = callableFactory.createUnaryCallable(listModelVersionsTransportSettings, settings.listModelVersionsSettings(), clientContext);
        this.listModelVersionsPagedCallable = callableFactory.createPagedCallable(listModelVersionsTransportSettings, settings.listModelVersionsSettings(), clientContext);
        this.updateModelCallable = callableFactory.createUnaryCallable(updateModelTransportSettings, settings.updateModelSettings(), clientContext);
        this.deleteModelCallable = callableFactory.createUnaryCallable(deleteModelTransportSettings, settings.deleteModelSettings(), clientContext);
        this.deleteModelOperationCallable = callableFactory.createOperationCallable(deleteModelTransportSettings, settings.deleteModelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteModelVersionCallable = callableFactory.createUnaryCallable(deleteModelVersionTransportSettings, settings.deleteModelVersionSettings(), clientContext);
        this.deleteModelVersionOperationCallable = callableFactory.createOperationCallable(deleteModelVersionTransportSettings, settings.deleteModelVersionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.mergeVersionAliasesCallable = callableFactory.createUnaryCallable(mergeVersionAliasesTransportSettings, settings.mergeVersionAliasesSettings(), clientContext);
        this.exportModelCallable = callableFactory.createUnaryCallable(exportModelTransportSettings, settings.exportModelSettings(), clientContext);
        this.exportModelOperationCallable = callableFactory.createOperationCallable(exportModelTransportSettings, settings.exportModelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.copyModelCallable = callableFactory.createUnaryCallable(copyModelTransportSettings, settings.copyModelSettings(), clientContext);
        this.copyModelOperationCallable = callableFactory.createOperationCallable(copyModelTransportSettings, settings.copyModelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.importModelEvaluationCallable = callableFactory.createUnaryCallable(importModelEvaluationTransportSettings, settings.importModelEvaluationSettings(), clientContext);
        this.batchImportModelEvaluationSlicesCallable = callableFactory.createUnaryCallable(batchImportModelEvaluationSlicesTransportSettings, settings.batchImportModelEvaluationSlicesSettings(), clientContext);
        this.getModelEvaluationCallable = callableFactory.createUnaryCallable(getModelEvaluationTransportSettings, settings.getModelEvaluationSettings(), clientContext);
        this.listModelEvaluationsCallable = callableFactory.createUnaryCallable(listModelEvaluationsTransportSettings, settings.listModelEvaluationsSettings(), clientContext);
        this.listModelEvaluationsPagedCallable = callableFactory.createPagedCallable(listModelEvaluationsTransportSettings, settings.listModelEvaluationsSettings(), clientContext);
        this.getModelEvaluationSliceCallable = callableFactory.createUnaryCallable(getModelEvaluationSliceTransportSettings, settings.getModelEvaluationSliceSettings(), clientContext);
        this.listModelEvaluationSlicesCallable = callableFactory.createUnaryCallable(listModelEvaluationSlicesTransportSettings, settings.listModelEvaluationSlicesSettings(), clientContext);
        this.listModelEvaluationSlicesPagedCallable = callableFactory.createPagedCallable(listModelEvaluationSlicesTransportSettings, settings.listModelEvaluationSlicesSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<UploadModelRequest, Operation> uploadModelCallable() {
        return this.uploadModelCallable;
    }

    @Override
    public OperationCallable<UploadModelRequest, UploadModelResponse, UploadModelOperationMetadata> uploadModelOperationCallable() {
        return this.uploadModelOperationCallable;
    }

    @Override
    public UnaryCallable<GetModelRequest, Model> getModelCallable() {
        return this.getModelCallable;
    }

    @Override
    public UnaryCallable<ListModelsRequest, ListModelsResponse> listModelsCallable() {
        return this.listModelsCallable;
    }

    @Override
    public UnaryCallable<ListModelsRequest, ModelServiceClient.ListModelsPagedResponse> listModelsPagedCallable() {
        return this.listModelsPagedCallable;
    }

    @Override
    public UnaryCallable<ListModelVersionsRequest, ListModelVersionsResponse> listModelVersionsCallable() {
        return this.listModelVersionsCallable;
    }

    @Override
    public UnaryCallable<ListModelVersionsRequest, ModelServiceClient.ListModelVersionsPagedResponse> listModelVersionsPagedCallable() {
        return this.listModelVersionsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateModelRequest, Model> updateModelCallable() {
        return this.updateModelCallable;
    }

    @Override
    public UnaryCallable<DeleteModelRequest, Operation> deleteModelCallable() {
        return this.deleteModelCallable;
    }

    @Override
    public OperationCallable<DeleteModelRequest, Empty, DeleteOperationMetadata> deleteModelOperationCallable() {
        return this.deleteModelOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteModelVersionRequest, Operation> deleteModelVersionCallable() {
        return this.deleteModelVersionCallable;
    }

    @Override
    public OperationCallable<DeleteModelVersionRequest, Empty, DeleteOperationMetadata> deleteModelVersionOperationCallable() {
        return this.deleteModelVersionOperationCallable;
    }

    @Override
    public UnaryCallable<MergeVersionAliasesRequest, Model> mergeVersionAliasesCallable() {
        return this.mergeVersionAliasesCallable;
    }

    @Override
    public UnaryCallable<ExportModelRequest, Operation> exportModelCallable() {
        return this.exportModelCallable;
    }

    @Override
    public OperationCallable<ExportModelRequest, ExportModelResponse, ExportModelOperationMetadata> exportModelOperationCallable() {
        return this.exportModelOperationCallable;
    }

    @Override
    public UnaryCallable<CopyModelRequest, Operation> copyModelCallable() {
        return this.copyModelCallable;
    }

    @Override
    public OperationCallable<CopyModelRequest, CopyModelResponse, CopyModelOperationMetadata> copyModelOperationCallable() {
        return this.copyModelOperationCallable;
    }

    @Override
    public UnaryCallable<ImportModelEvaluationRequest, ModelEvaluation> importModelEvaluationCallable() {
        return this.importModelEvaluationCallable;
    }

    @Override
    public UnaryCallable<BatchImportModelEvaluationSlicesRequest, BatchImportModelEvaluationSlicesResponse> batchImportModelEvaluationSlicesCallable() {
        return this.batchImportModelEvaluationSlicesCallable;
    }

    @Override
    public UnaryCallable<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationCallable() {
        return this.getModelEvaluationCallable;
    }

    @Override
    public UnaryCallable<ListModelEvaluationsRequest, ListModelEvaluationsResponse> listModelEvaluationsCallable() {
        return this.listModelEvaluationsCallable;
    }

    @Override
    public UnaryCallable<ListModelEvaluationsRequest, ModelServiceClient.ListModelEvaluationsPagedResponse> listModelEvaluationsPagedCallable() {
        return this.listModelEvaluationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetModelEvaluationSliceRequest, ModelEvaluationSlice> getModelEvaluationSliceCallable() {
        return this.getModelEvaluationSliceCallable;
    }

    @Override
    public UnaryCallable<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse> listModelEvaluationSlicesCallable() {
        return this.listModelEvaluationSlicesCallable;
    }

    @Override
    public UnaryCallable<ListModelEvaluationSlicesRequest, ModelServiceClient.ListModelEvaluationSlicesPagedResponse> listModelEvaluationSlicesPagedCallable() {
        return this.listModelEvaluationSlicesPagedCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ModelServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

