/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.DeleteModelRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.ExportModelOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.ExportModelRequest;
import com.google.cloud.aiplatform.v1beta1.ExportModelResponse;
import com.google.cloud.aiplatform.v1beta1.GetModelEvaluationRequest;
import com.google.cloud.aiplatform.v1beta1.GetModelEvaluationSliceRequest;
import com.google.cloud.aiplatform.v1beta1.GetModelRequest;
import com.google.cloud.aiplatform.v1beta1.ImportModelEvaluationRequest;
import com.google.cloud.aiplatform.v1beta1.ListModelEvaluationSlicesRequest;
import com.google.cloud.aiplatform.v1beta1.ListModelEvaluationSlicesResponse;
import com.google.cloud.aiplatform.v1beta1.ListModelEvaluationsRequest;
import com.google.cloud.aiplatform.v1beta1.ListModelEvaluationsResponse;
import com.google.cloud.aiplatform.v1beta1.ListModelsRequest;
import com.google.cloud.aiplatform.v1beta1.ListModelsResponse;
import com.google.cloud.aiplatform.v1beta1.Model;
import com.google.cloud.aiplatform.v1beta1.ModelEvaluation;
import com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice;
import com.google.cloud.aiplatform.v1beta1.ModelServiceClient;
import com.google.cloud.aiplatform.v1beta1.UpdateModelRequest;
import com.google.cloud.aiplatform.v1beta1.UploadModelOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UploadModelRequest;
import com.google.cloud.aiplatform.v1beta1.UploadModelResponse;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcModelServiceCallableFactory;
import com.google.cloud.aiplatform.v1beta1.stub.ModelServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.ModelServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcModelServiceStub
extends ModelServiceStub {
    private static final MethodDescriptor<UploadModelRequest, Operation> uploadModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ModelService/UploadModel").setRequestMarshaller(ProtoUtils.marshaller((Message)UploadModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetModelRequest, Model> getModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ModelService/GetModel").setRequestMarshaller(ProtoUtils.marshaller((Message)GetModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Model.getDefaultInstance())).build();
    private static final MethodDescriptor<ListModelsRequest, ListModelsResponse> listModelsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ModelService/ListModels").setRequestMarshaller(ProtoUtils.marshaller((Message)ListModelsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListModelsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateModelRequest, Model> updateModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ModelService/UpdateModel").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Model.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteModelRequest, Operation> deleteModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ModelService/DeleteModel").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ExportModelRequest, Operation> exportModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ModelService/ExportModel").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ImportModelEvaluationRequest, ModelEvaluation> importModelEvaluationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ModelService/ImportModelEvaluation").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportModelEvaluationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ModelEvaluation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ModelService/GetModelEvaluation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetModelEvaluationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ModelEvaluation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListModelEvaluationsRequest, ListModelEvaluationsResponse> listModelEvaluationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ModelService/ListModelEvaluations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListModelEvaluationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListModelEvaluationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetModelEvaluationSliceRequest, ModelEvaluationSlice> getModelEvaluationSliceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ModelService/GetModelEvaluationSlice").setRequestMarshaller(ProtoUtils.marshaller((Message)GetModelEvaluationSliceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ModelEvaluationSlice.getDefaultInstance())).build();
    private static final MethodDescriptor<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse> listModelEvaluationSlicesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ModelService/ListModelEvaluationSlices").setRequestMarshaller(ProtoUtils.marshaller((Message)ListModelEvaluationSlicesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListModelEvaluationSlicesResponse.getDefaultInstance())).build();
    private final UnaryCallable<UploadModelRequest, Operation> uploadModelCallable;
    private final OperationCallable<UploadModelRequest, UploadModelResponse, UploadModelOperationMetadata> uploadModelOperationCallable;
    private final UnaryCallable<GetModelRequest, Model> getModelCallable;
    private final UnaryCallable<ListModelsRequest, ListModelsResponse> listModelsCallable;
    private final UnaryCallable<ListModelsRequest, ModelServiceClient.ListModelsPagedResponse> listModelsPagedCallable;
    private final UnaryCallable<UpdateModelRequest, Model> updateModelCallable;
    private final UnaryCallable<DeleteModelRequest, Operation> deleteModelCallable;
    private final OperationCallable<DeleteModelRequest, Empty, DeleteOperationMetadata> deleteModelOperationCallable;
    private final UnaryCallable<ExportModelRequest, Operation> exportModelCallable;
    private final OperationCallable<ExportModelRequest, ExportModelResponse, ExportModelOperationMetadata> exportModelOperationCallable;
    private final UnaryCallable<ImportModelEvaluationRequest, ModelEvaluation> importModelEvaluationCallable;
    private final UnaryCallable<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationCallable;
    private final UnaryCallable<ListModelEvaluationsRequest, ListModelEvaluationsResponse> listModelEvaluationsCallable;
    private final UnaryCallable<ListModelEvaluationsRequest, ModelServiceClient.ListModelEvaluationsPagedResponse> listModelEvaluationsPagedCallable;
    private final UnaryCallable<GetModelEvaluationSliceRequest, ModelEvaluationSlice> getModelEvaluationSliceCallable;
    private final UnaryCallable<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse> listModelEvaluationSlicesCallable;
    private final UnaryCallable<ListModelEvaluationSlicesRequest, ModelServiceClient.ListModelEvaluationSlicesPagedResponse> listModelEvaluationSlicesPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcModelServiceStub create(ModelServiceStubSettings settings) throws IOException {
        return new GrpcModelServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcModelServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcModelServiceStub(ModelServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcModelServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcModelServiceStub(ModelServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcModelServiceStub(ModelServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcModelServiceCallableFactory());
    }

    protected GrpcModelServiceStub(ModelServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings uploadModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(uploadModelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getModelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listModelsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listModelsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateModelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"model.name", (Object)String.valueOf(request.getModel().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteModelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings exportModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportModelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings importModelEvaluationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importModelEvaluationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getModelEvaluationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getModelEvaluationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listModelEvaluationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listModelEvaluationsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getModelEvaluationSliceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getModelEvaluationSliceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listModelEvaluationSlicesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listModelEvaluationSlicesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        this.uploadModelCallable = callableFactory.createUnaryCallable(uploadModelTransportSettings, settings.uploadModelSettings(), clientContext);
        this.uploadModelOperationCallable = callableFactory.createOperationCallable(uploadModelTransportSettings, settings.uploadModelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getModelCallable = callableFactory.createUnaryCallable(getModelTransportSettings, settings.getModelSettings(), clientContext);
        this.listModelsCallable = callableFactory.createUnaryCallable(listModelsTransportSettings, settings.listModelsSettings(), clientContext);
        this.listModelsPagedCallable = callableFactory.createPagedCallable(listModelsTransportSettings, settings.listModelsSettings(), clientContext);
        this.updateModelCallable = callableFactory.createUnaryCallable(updateModelTransportSettings, settings.updateModelSettings(), clientContext);
        this.deleteModelCallable = callableFactory.createUnaryCallable(deleteModelTransportSettings, settings.deleteModelSettings(), clientContext);
        this.deleteModelOperationCallable = callableFactory.createOperationCallable(deleteModelTransportSettings, settings.deleteModelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.exportModelCallable = callableFactory.createUnaryCallable(exportModelTransportSettings, settings.exportModelSettings(), clientContext);
        this.exportModelOperationCallable = callableFactory.createOperationCallable(exportModelTransportSettings, settings.exportModelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.importModelEvaluationCallable = callableFactory.createUnaryCallable(importModelEvaluationTransportSettings, settings.importModelEvaluationSettings(), clientContext);
        this.getModelEvaluationCallable = callableFactory.createUnaryCallable(getModelEvaluationTransportSettings, settings.getModelEvaluationSettings(), clientContext);
        this.listModelEvaluationsCallable = callableFactory.createUnaryCallable(listModelEvaluationsTransportSettings, settings.listModelEvaluationsSettings(), clientContext);
        this.listModelEvaluationsPagedCallable = callableFactory.createPagedCallable(listModelEvaluationsTransportSettings, settings.listModelEvaluationsSettings(), clientContext);
        this.getModelEvaluationSliceCallable = callableFactory.createUnaryCallable(getModelEvaluationSliceTransportSettings, settings.getModelEvaluationSliceSettings(), clientContext);
        this.listModelEvaluationSlicesCallable = callableFactory.createUnaryCallable(listModelEvaluationSlicesTransportSettings, settings.listModelEvaluationSlicesSettings(), clientContext);
        this.listModelEvaluationSlicesPagedCallable = callableFactory.createPagedCallable(listModelEvaluationSlicesTransportSettings, settings.listModelEvaluationSlicesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<UploadModelRequest, Operation> uploadModelCallable() {
        return this.uploadModelCallable;
    }

    @Override
    public OperationCallable<UploadModelRequest, UploadModelResponse, UploadModelOperationMetadata> uploadModelOperationCallable() {
        return this.uploadModelOperationCallable;
    }

    @Override
    public UnaryCallable<GetModelRequest, Model> getModelCallable() {
        return this.getModelCallable;
    }

    @Override
    public UnaryCallable<ListModelsRequest, ListModelsResponse> listModelsCallable() {
        return this.listModelsCallable;
    }

    @Override
    public UnaryCallable<ListModelsRequest, ModelServiceClient.ListModelsPagedResponse> listModelsPagedCallable() {
        return this.listModelsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateModelRequest, Model> updateModelCallable() {
        return this.updateModelCallable;
    }

    @Override
    public UnaryCallable<DeleteModelRequest, Operation> deleteModelCallable() {
        return this.deleteModelCallable;
    }

    @Override
    public OperationCallable<DeleteModelRequest, Empty, DeleteOperationMetadata> deleteModelOperationCallable() {
        return this.deleteModelOperationCallable;
    }

    @Override
    public UnaryCallable<ExportModelRequest, Operation> exportModelCallable() {
        return this.exportModelCallable;
    }

    @Override
    public OperationCallable<ExportModelRequest, ExportModelResponse, ExportModelOperationMetadata> exportModelOperationCallable() {
        return this.exportModelOperationCallable;
    }

    @Override
    public UnaryCallable<ImportModelEvaluationRequest, ModelEvaluation> importModelEvaluationCallable() {
        return this.importModelEvaluationCallable;
    }

    @Override
    public UnaryCallable<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationCallable() {
        return this.getModelEvaluationCallable;
    }

    @Override
    public UnaryCallable<ListModelEvaluationsRequest, ListModelEvaluationsResponse> listModelEvaluationsCallable() {
        return this.listModelEvaluationsCallable;
    }

    @Override
    public UnaryCallable<ListModelEvaluationsRequest, ModelServiceClient.ListModelEvaluationsPagedResponse> listModelEvaluationsPagedCallable() {
        return this.listModelEvaluationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetModelEvaluationSliceRequest, ModelEvaluationSlice> getModelEvaluationSliceCallable() {
        return this.getModelEvaluationSliceCallable;
    }

    @Override
    public UnaryCallable<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse> listModelEvaluationSlicesCallable() {
        return this.listModelEvaluationSlicesCallable;
    }

    @Override
    public UnaryCallable<ListModelEvaluationSlicesRequest, ModelServiceClient.ListModelEvaluationSlicesPagedResponse> listModelEvaluationSlicesPagedCallable() {
        return this.listModelEvaluationSlicesPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

