/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.AnnotationSpec;
import com.google.cloud.aiplatform.v1beta1.CreateDatasetOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateDatasetRequest;
import com.google.cloud.aiplatform.v1beta1.Dataset;
import com.google.cloud.aiplatform.v1beta1.DatasetServiceClient;
import com.google.cloud.aiplatform.v1beta1.DeleteDatasetRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.ExportDataOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.ExportDataRequest;
import com.google.cloud.aiplatform.v1beta1.ExportDataResponse;
import com.google.cloud.aiplatform.v1beta1.GetAnnotationSpecRequest;
import com.google.cloud.aiplatform.v1beta1.GetDatasetRequest;
import com.google.cloud.aiplatform.v1beta1.ImportDataOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.ImportDataRequest;
import com.google.cloud.aiplatform.v1beta1.ImportDataResponse;
import com.google.cloud.aiplatform.v1beta1.ListAnnotationsRequest;
import com.google.cloud.aiplatform.v1beta1.ListAnnotationsResponse;
import com.google.cloud.aiplatform.v1beta1.ListDataItemsRequest;
import com.google.cloud.aiplatform.v1beta1.ListDataItemsResponse;
import com.google.cloud.aiplatform.v1beta1.ListDatasetsRequest;
import com.google.cloud.aiplatform.v1beta1.ListDatasetsResponse;
import com.google.cloud.aiplatform.v1beta1.UpdateDatasetRequest;
import com.google.cloud.aiplatform.v1beta1.stub.DatasetServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.DatasetServiceStubSettings;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcDatasetServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcDatasetServiceStub
extends DatasetServiceStub {
    private static final MethodDescriptor<CreateDatasetRequest, Operation> createDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.DatasetService/CreateDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetDatasetRequest, Dataset> getDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.DatasetService/GetDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Dataset.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateDatasetRequest, Dataset> updateDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.DatasetService/UpdateDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Dataset.getDefaultInstance())).build();
    private static final MethodDescriptor<ListDatasetsRequest, ListDatasetsResponse> listDatasetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.DatasetService/ListDatasets").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDatasetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDatasetsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteDatasetRequest, Operation> deleteDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.DatasetService/DeleteDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ImportDataRequest, Operation> importDataMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.DatasetService/ImportData").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportDataRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ExportDataRequest, Operation> exportDataMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.DatasetService/ExportData").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportDataRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListDataItemsRequest, ListDataItemsResponse> listDataItemsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.DatasetService/ListDataItems").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDataItemsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDataItemsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.DatasetService/GetAnnotationSpec").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAnnotationSpecRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AnnotationSpec.getDefaultInstance())).build();
    private static final MethodDescriptor<ListAnnotationsRequest, ListAnnotationsResponse> listAnnotationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.DatasetService/ListAnnotations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAnnotationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAnnotationsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateDatasetRequest, Operation> createDatasetCallable;
    private final OperationCallable<CreateDatasetRequest, Dataset, CreateDatasetOperationMetadata> createDatasetOperationCallable;
    private final UnaryCallable<GetDatasetRequest, Dataset> getDatasetCallable;
    private final UnaryCallable<UpdateDatasetRequest, Dataset> updateDatasetCallable;
    private final UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> listDatasetsCallable;
    private final UnaryCallable<ListDatasetsRequest, DatasetServiceClient.ListDatasetsPagedResponse> listDatasetsPagedCallable;
    private final UnaryCallable<DeleteDatasetRequest, Operation> deleteDatasetCallable;
    private final OperationCallable<DeleteDatasetRequest, Empty, DeleteOperationMetadata> deleteDatasetOperationCallable;
    private final UnaryCallable<ImportDataRequest, Operation> importDataCallable;
    private final OperationCallable<ImportDataRequest, ImportDataResponse, ImportDataOperationMetadata> importDataOperationCallable;
    private final UnaryCallable<ExportDataRequest, Operation> exportDataCallable;
    private final OperationCallable<ExportDataRequest, ExportDataResponse, ExportDataOperationMetadata> exportDataOperationCallable;
    private final UnaryCallable<ListDataItemsRequest, ListDataItemsResponse> listDataItemsCallable;
    private final UnaryCallable<ListDataItemsRequest, DatasetServiceClient.ListDataItemsPagedResponse> listDataItemsPagedCallable;
    private final UnaryCallable<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecCallable;
    private final UnaryCallable<ListAnnotationsRequest, ListAnnotationsResponse> listAnnotationsCallable;
    private final UnaryCallable<ListAnnotationsRequest, DatasetServiceClient.ListAnnotationsPagedResponse> listAnnotationsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDatasetServiceStub create(DatasetServiceStubSettings settings) throws IOException {
        return new GrpcDatasetServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDatasetServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcDatasetServiceStub(DatasetServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDatasetServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDatasetServiceStub(DatasetServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDatasetServiceStub(DatasetServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDatasetServiceCallableFactory());
    }

    protected GrpcDatasetServiceStub(DatasetServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createDatasetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateDatasetRequest>(){

            public Map<String, String> extract(CreateDatasetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDatasetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetDatasetRequest>(){

            public Map<String, String> extract(GetDatasetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDatasetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateDatasetRequest>(){

            public Map<String, String> extract(UpdateDatasetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"dataset.name", (Object)String.valueOf(request.getDataset().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listDatasetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDatasetsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListDatasetsRequest>(){

            public Map<String, String> extract(ListDatasetsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteDatasetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteDatasetRequest>(){

            public Map<String, String> extract(DeleteDatasetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings importDataTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importDataMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ImportDataRequest>(){

            public Map<String, String> extract(ImportDataRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings exportDataTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportDataMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ExportDataRequest>(){

            public Map<String, String> extract(ExportDataRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listDataItemsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDataItemsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListDataItemsRequest>(){

            public Map<String, String> extract(ListDataItemsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getAnnotationSpecTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAnnotationSpecMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetAnnotationSpecRequest>(){

            public Map<String, String> extract(GetAnnotationSpecRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listAnnotationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAnnotationsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListAnnotationsRequest>(){

            public Map<String, String> extract(ListAnnotationsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        this.createDatasetCallable = callableFactory.createUnaryCallable(createDatasetTransportSettings, settings.createDatasetSettings(), clientContext);
        this.createDatasetOperationCallable = callableFactory.createOperationCallable(createDatasetTransportSettings, settings.createDatasetOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getDatasetCallable = callableFactory.createUnaryCallable(getDatasetTransportSettings, settings.getDatasetSettings(), clientContext);
        this.updateDatasetCallable = callableFactory.createUnaryCallable(updateDatasetTransportSettings, settings.updateDatasetSettings(), clientContext);
        this.listDatasetsCallable = callableFactory.createUnaryCallable(listDatasetsTransportSettings, settings.listDatasetsSettings(), clientContext);
        this.listDatasetsPagedCallable = callableFactory.createPagedCallable(listDatasetsTransportSettings, settings.listDatasetsSettings(), clientContext);
        this.deleteDatasetCallable = callableFactory.createUnaryCallable(deleteDatasetTransportSettings, settings.deleteDatasetSettings(), clientContext);
        this.deleteDatasetOperationCallable = callableFactory.createOperationCallable(deleteDatasetTransportSettings, settings.deleteDatasetOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.importDataCallable = callableFactory.createUnaryCallable(importDataTransportSettings, settings.importDataSettings(), clientContext);
        this.importDataOperationCallable = callableFactory.createOperationCallable(importDataTransportSettings, settings.importDataOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.exportDataCallable = callableFactory.createUnaryCallable(exportDataTransportSettings, settings.exportDataSettings(), clientContext);
        this.exportDataOperationCallable = callableFactory.createOperationCallable(exportDataTransportSettings, settings.exportDataOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listDataItemsCallable = callableFactory.createUnaryCallable(listDataItemsTransportSettings, settings.listDataItemsSettings(), clientContext);
        this.listDataItemsPagedCallable = callableFactory.createPagedCallable(listDataItemsTransportSettings, settings.listDataItemsSettings(), clientContext);
        this.getAnnotationSpecCallable = callableFactory.createUnaryCallable(getAnnotationSpecTransportSettings, settings.getAnnotationSpecSettings(), clientContext);
        this.listAnnotationsCallable = callableFactory.createUnaryCallable(listAnnotationsTransportSettings, settings.listAnnotationsSettings(), clientContext);
        this.listAnnotationsPagedCallable = callableFactory.createPagedCallable(listAnnotationsTransportSettings, settings.listAnnotationsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateDatasetRequest, Operation> createDatasetCallable() {
        return this.createDatasetCallable;
    }

    @Override
    public OperationCallable<CreateDatasetRequest, Dataset, CreateDatasetOperationMetadata> createDatasetOperationCallable() {
        return this.createDatasetOperationCallable;
    }

    @Override
    public UnaryCallable<GetDatasetRequest, Dataset> getDatasetCallable() {
        return this.getDatasetCallable;
    }

    @Override
    public UnaryCallable<UpdateDatasetRequest, Dataset> updateDatasetCallable() {
        return this.updateDatasetCallable;
    }

    @Override
    public UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> listDatasetsCallable() {
        return this.listDatasetsCallable;
    }

    @Override
    public UnaryCallable<ListDatasetsRequest, DatasetServiceClient.ListDatasetsPagedResponse> listDatasetsPagedCallable() {
        return this.listDatasetsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteDatasetRequest, Operation> deleteDatasetCallable() {
        return this.deleteDatasetCallable;
    }

    @Override
    public OperationCallable<DeleteDatasetRequest, Empty, DeleteOperationMetadata> deleteDatasetOperationCallable() {
        return this.deleteDatasetOperationCallable;
    }

    @Override
    public UnaryCallable<ImportDataRequest, Operation> importDataCallable() {
        return this.importDataCallable;
    }

    @Override
    public OperationCallable<ImportDataRequest, ImportDataResponse, ImportDataOperationMetadata> importDataOperationCallable() {
        return this.importDataOperationCallable;
    }

    @Override
    public UnaryCallable<ExportDataRequest, Operation> exportDataCallable() {
        return this.exportDataCallable;
    }

    @Override
    public OperationCallable<ExportDataRequest, ExportDataResponse, ExportDataOperationMetadata> exportDataOperationCallable() {
        return this.exportDataOperationCallable;
    }

    @Override
    public UnaryCallable<ListDataItemsRequest, ListDataItemsResponse> listDataItemsCallable() {
        return this.listDataItemsCallable;
    }

    @Override
    public UnaryCallable<ListDataItemsRequest, DatasetServiceClient.ListDataItemsPagedResponse> listDataItemsPagedCallable() {
        return this.listDataItemsPagedCallable;
    }

    @Override
    public UnaryCallable<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecCallable() {
        return this.getAnnotationSpecCallable;
    }

    @Override
    public UnaryCallable<ListAnnotationsRequest, ListAnnotationsResponse> listAnnotationsCallable() {
        return this.listAnnotationsCallable;
    }

    @Override
    public UnaryCallable<ListAnnotationsRequest, DatasetServiceClient.ListAnnotationsPagedResponse> listAnnotationsPagedCallable() {
        return this.listAnnotationsPagedCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

