/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CancelTrainingPipelineRequest;
import com.google.cloud.aiplatform.v1beta1.CreateTrainingPipelineRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeleteTrainingPipelineRequest;
import com.google.cloud.aiplatform.v1beta1.GetTrainingPipelineRequest;
import com.google.cloud.aiplatform.v1beta1.ListTrainingPipelinesRequest;
import com.google.cloud.aiplatform.v1beta1.ListTrainingPipelinesResponse;
import com.google.cloud.aiplatform.v1beta1.LocationName;
import com.google.cloud.aiplatform.v1beta1.PipelineServiceSettings;
import com.google.cloud.aiplatform.v1beta1.TrainingPipeline;
import com.google.cloud.aiplatform.v1beta1.TrainingPipelineName;
import com.google.cloud.aiplatform.v1beta1.stub.PipelineServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.PipelineServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PipelineServiceClient
implements BackgroundResource {
    private final PipelineServiceSettings settings;
    private final PipelineServiceStub stub;
    private final OperationsClient operationsClient;

    public static final PipelineServiceClient create() throws IOException {
        return PipelineServiceClient.create(PipelineServiceSettings.newBuilder().build());
    }

    public static final PipelineServiceClient create(PipelineServiceSettings settings) throws IOException {
        return new PipelineServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final PipelineServiceClient create(PipelineServiceStub stub) {
        return new PipelineServiceClient(stub);
    }

    protected PipelineServiceClient(PipelineServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PipelineServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected PipelineServiceClient(PipelineServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final PipelineServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public PipelineServiceStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final TrainingPipeline createTrainingPipeline(LocationName parent, TrainingPipeline trainingPipeline) {
        CreateTrainingPipelineRequest request = CreateTrainingPipelineRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTrainingPipeline(trainingPipeline).build();
        return this.createTrainingPipeline(request);
    }

    public final TrainingPipeline createTrainingPipeline(String parent, TrainingPipeline trainingPipeline) {
        CreateTrainingPipelineRequest request = CreateTrainingPipelineRequest.newBuilder().setParent(parent).setTrainingPipeline(trainingPipeline).build();
        return this.createTrainingPipeline(request);
    }

    public final TrainingPipeline createTrainingPipeline(CreateTrainingPipelineRequest request) {
        return (TrainingPipeline)this.createTrainingPipelineCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTrainingPipelineRequest, TrainingPipeline> createTrainingPipelineCallable() {
        return this.stub.createTrainingPipelineCallable();
    }

    public final TrainingPipeline getTrainingPipeline(TrainingPipelineName name) {
        GetTrainingPipelineRequest request = GetTrainingPipelineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTrainingPipeline(request);
    }

    public final TrainingPipeline getTrainingPipeline(String name) {
        GetTrainingPipelineRequest request = GetTrainingPipelineRequest.newBuilder().setName(name).build();
        return this.getTrainingPipeline(request);
    }

    public final TrainingPipeline getTrainingPipeline(GetTrainingPipelineRequest request) {
        return (TrainingPipeline)this.getTrainingPipelineCallable().call((Object)request);
    }

    public final UnaryCallable<GetTrainingPipelineRequest, TrainingPipeline> getTrainingPipelineCallable() {
        return this.stub.getTrainingPipelineCallable();
    }

    public final ListTrainingPipelinesPagedResponse listTrainingPipelines(LocationName parent) {
        ListTrainingPipelinesRequest request = ListTrainingPipelinesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTrainingPipelines(request);
    }

    public final ListTrainingPipelinesPagedResponse listTrainingPipelines(String parent) {
        ListTrainingPipelinesRequest request = ListTrainingPipelinesRequest.newBuilder().setParent(parent).build();
        return this.listTrainingPipelines(request);
    }

    public final ListTrainingPipelinesPagedResponse listTrainingPipelines(ListTrainingPipelinesRequest request) {
        return (ListTrainingPipelinesPagedResponse)((Object)this.listTrainingPipelinesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTrainingPipelinesRequest, ListTrainingPipelinesPagedResponse> listTrainingPipelinesPagedCallable() {
        return this.stub.listTrainingPipelinesPagedCallable();
    }

    public final UnaryCallable<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse> listTrainingPipelinesCallable() {
        return this.stub.listTrainingPipelinesCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, DeleteOperationMetadata> deleteTrainingPipelineAsync(TrainingPipelineName name) {
        DeleteTrainingPipelineRequest request = DeleteTrainingPipelineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteTrainingPipelineAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, DeleteOperationMetadata> deleteTrainingPipelineAsync(String name) {
        DeleteTrainingPipelineRequest request = DeleteTrainingPipelineRequest.newBuilder().setName(name).build();
        return this.deleteTrainingPipelineAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, DeleteOperationMetadata> deleteTrainingPipelineAsync(DeleteTrainingPipelineRequest request) {
        return this.deleteTrainingPipelineOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<DeleteTrainingPipelineRequest, Empty, DeleteOperationMetadata> deleteTrainingPipelineOperationCallable() {
        return this.stub.deleteTrainingPipelineOperationCallable();
    }

    public final UnaryCallable<DeleteTrainingPipelineRequest, Operation> deleteTrainingPipelineCallable() {
        return this.stub.deleteTrainingPipelineCallable();
    }

    public final void cancelTrainingPipeline(TrainingPipelineName name) {
        CancelTrainingPipelineRequest request = CancelTrainingPipelineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.cancelTrainingPipeline(request);
    }

    public final void cancelTrainingPipeline(String name) {
        CancelTrainingPipelineRequest request = CancelTrainingPipelineRequest.newBuilder().setName(name).build();
        this.cancelTrainingPipeline(request);
    }

    public final void cancelTrainingPipeline(CancelTrainingPipelineRequest request) {
        this.cancelTrainingPipelineCallable().call((Object)request);
    }

    public final UnaryCallable<CancelTrainingPipelineRequest, Empty> cancelTrainingPipelineCallable() {
        return this.stub.cancelTrainingPipelineCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTrainingPipelinesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, TrainingPipeline, ListTrainingPipelinesPage, ListTrainingPipelinesFixedSizeCollection> {
        private ListTrainingPipelinesFixedSizeCollection(List<ListTrainingPipelinesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTrainingPipelinesFixedSizeCollection createEmptyCollection() {
            return new ListTrainingPipelinesFixedSizeCollection(null, 0);
        }

        protected ListTrainingPipelinesFixedSizeCollection createCollection(List<ListTrainingPipelinesPage> pages, int collectionSize) {
            return new ListTrainingPipelinesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTrainingPipelinesPage
    extends AbstractPage<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, TrainingPipeline, ListTrainingPipelinesPage> {
        private ListTrainingPipelinesPage(PageContext<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, TrainingPipeline> context, ListTrainingPipelinesResponse response) {
            super(context, (Object)response);
        }

        private static ListTrainingPipelinesPage createEmptyPage() {
            return new ListTrainingPipelinesPage(null, null);
        }

        protected ListTrainingPipelinesPage createPage(PageContext<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, TrainingPipeline> context, ListTrainingPipelinesResponse response) {
            return new ListTrainingPipelinesPage(context, response);
        }

        public ApiFuture<ListTrainingPipelinesPage> createPageAsync(PageContext<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, TrainingPipeline> context, ApiFuture<ListTrainingPipelinesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTrainingPipelinesPagedResponse
    extends AbstractPagedListResponse<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, TrainingPipeline, ListTrainingPipelinesPage, ListTrainingPipelinesFixedSizeCollection> {
        public static ApiFuture<ListTrainingPipelinesPagedResponse> createAsync(PageContext<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse, TrainingPipeline> context, ApiFuture<ListTrainingPipelinesResponse> futureResponse) {
            ApiFuture<ListTrainingPipelinesPage> futurePage = ListTrainingPipelinesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTrainingPipelinesPage, ListTrainingPipelinesPagedResponse>(){

                public ListTrainingPipelinesPagedResponse apply(ListTrainingPipelinesPage input) {
                    return new ListTrainingPipelinesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTrainingPipelinesPagedResponse(ListTrainingPipelinesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTrainingPipelinesFixedSizeCollection.createEmptyCollection());
        }
    }
}

