/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.advisorynotifications.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.advisorynotifications.v1.AdvisoryNotificationsServiceSettings;
import com.google.cloud.advisorynotifications.v1.GetNotificationRequest;
import com.google.cloud.advisorynotifications.v1.GetSettingsRequest;
import com.google.cloud.advisorynotifications.v1.ListNotificationsRequest;
import com.google.cloud.advisorynotifications.v1.ListNotificationsResponse;
import com.google.cloud.advisorynotifications.v1.LocationName;
import com.google.cloud.advisorynotifications.v1.Notification;
import com.google.cloud.advisorynotifications.v1.NotificationName;
import com.google.cloud.advisorynotifications.v1.Settings;
import com.google.cloud.advisorynotifications.v1.SettingsName;
import com.google.cloud.advisorynotifications.v1.UpdateSettingsRequest;
import com.google.cloud.advisorynotifications.v1.stub.AdvisoryNotificationsServiceStub;
import com.google.cloud.advisorynotifications.v1.stub.AdvisoryNotificationsServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AdvisoryNotificationsServiceClient
implements BackgroundResource {
    private final AdvisoryNotificationsServiceSettings settings;
    private final AdvisoryNotificationsServiceStub stub;

    public static final AdvisoryNotificationsServiceClient create() throws IOException {
        return AdvisoryNotificationsServiceClient.create(AdvisoryNotificationsServiceSettings.newBuilder().build());
    }

    public static final AdvisoryNotificationsServiceClient create(AdvisoryNotificationsServiceSettings settings) throws IOException {
        return new AdvisoryNotificationsServiceClient(settings);
    }

    public static final AdvisoryNotificationsServiceClient create(AdvisoryNotificationsServiceStub stub) {
        return new AdvisoryNotificationsServiceClient(stub);
    }

    protected AdvisoryNotificationsServiceClient(AdvisoryNotificationsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdvisoryNotificationsServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AdvisoryNotificationsServiceClient(AdvisoryNotificationsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdvisoryNotificationsServiceSettings getSettings() {
        return this.settings;
    }

    public AdvisoryNotificationsServiceStub getStub() {
        return this.stub;
    }

    public final ListNotificationsPagedResponse listNotifications(LocationName parent) {
        ListNotificationsRequest request = ListNotificationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNotifications(request);
    }

    public final ListNotificationsPagedResponse listNotifications(String parent) {
        ListNotificationsRequest request = ListNotificationsRequest.newBuilder().setParent(parent).build();
        return this.listNotifications(request);
    }

    public final ListNotificationsPagedResponse listNotifications(ListNotificationsRequest request) {
        return (ListNotificationsPagedResponse)((Object)this.listNotificationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNotificationsRequest, ListNotificationsPagedResponse> listNotificationsPagedCallable() {
        return this.stub.listNotificationsPagedCallable();
    }

    public final UnaryCallable<ListNotificationsRequest, ListNotificationsResponse> listNotificationsCallable() {
        return this.stub.listNotificationsCallable();
    }

    public final Notification getNotification(NotificationName name) {
        GetNotificationRequest request = GetNotificationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNotification(request);
    }

    public final Notification getNotification(String name) {
        GetNotificationRequest request = GetNotificationRequest.newBuilder().setName(name).build();
        return this.getNotification(request);
    }

    public final Notification getNotification(GetNotificationRequest request) {
        return (Notification)this.getNotificationCallable().call((Object)request);
    }

    public final UnaryCallable<GetNotificationRequest, Notification> getNotificationCallable() {
        return this.stub.getNotificationCallable();
    }

    public final Settings getSettings(SettingsName name) {
        GetSettingsRequest request = GetSettingsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSettings(request);
    }

    public final Settings getSettings(String name) {
        GetSettingsRequest request = GetSettingsRequest.newBuilder().setName(name).build();
        return this.getSettings(request);
    }

    public final Settings getSettings(GetSettingsRequest request) {
        return (Settings)this.getSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<GetSettingsRequest, Settings> getSettingsCallable() {
        return this.stub.getSettingsCallable();
    }

    public final Settings updateSettings(Settings settings) {
        UpdateSettingsRequest request = UpdateSettingsRequest.newBuilder().setSettings(settings).build();
        return this.updateSettings(request);
    }

    public final Settings updateSettings(UpdateSettingsRequest request) {
        return (Settings)this.updateSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSettingsRequest, Settings> updateSettingsCallable() {
        return this.stub.updateSettingsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListNotificationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNotificationsRequest, ListNotificationsResponse, Notification, ListNotificationsPage, ListNotificationsFixedSizeCollection> {
        private ListNotificationsFixedSizeCollection(List<ListNotificationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNotificationsFixedSizeCollection createEmptyCollection() {
            return new ListNotificationsFixedSizeCollection(null, 0);
        }

        protected ListNotificationsFixedSizeCollection createCollection(List<ListNotificationsPage> pages, int collectionSize) {
            return new ListNotificationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNotificationsPage
    extends AbstractPage<ListNotificationsRequest, ListNotificationsResponse, Notification, ListNotificationsPage> {
        private ListNotificationsPage(PageContext<ListNotificationsRequest, ListNotificationsResponse, Notification> context, ListNotificationsResponse response) {
            super(context, (Object)response);
        }

        private static ListNotificationsPage createEmptyPage() {
            return new ListNotificationsPage(null, null);
        }

        protected ListNotificationsPage createPage(PageContext<ListNotificationsRequest, ListNotificationsResponse, Notification> context, ListNotificationsResponse response) {
            return new ListNotificationsPage(context, response);
        }

        public ApiFuture<ListNotificationsPage> createPageAsync(PageContext<ListNotificationsRequest, ListNotificationsResponse, Notification> context, ApiFuture<ListNotificationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNotificationsPagedResponse
    extends AbstractPagedListResponse<ListNotificationsRequest, ListNotificationsResponse, Notification, ListNotificationsPage, ListNotificationsFixedSizeCollection> {
        public static ApiFuture<ListNotificationsPagedResponse> createAsync(PageContext<ListNotificationsRequest, ListNotificationsResponse, Notification> context, ApiFuture<ListNotificationsResponse> futureResponse) {
            ApiFuture<ListNotificationsPage> futurePage = ListNotificationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNotificationsPagedResponse((ListNotificationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNotificationsPagedResponse(ListNotificationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNotificationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

