/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.accessapproval.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.accessapproval.v1.AccessApprovalAdminSettings;
import com.google.cloud.accessapproval.v1.AccessApprovalServiceAccount;
import com.google.cloud.accessapproval.v1.AccessApprovalSettings;
import com.google.cloud.accessapproval.v1.AccessApprovalSettingsName;
import com.google.cloud.accessapproval.v1.ApprovalRequest;
import com.google.cloud.accessapproval.v1.ApprovalRequestName;
import com.google.cloud.accessapproval.v1.ApproveApprovalRequestMessage;
import com.google.cloud.accessapproval.v1.DeleteAccessApprovalSettingsMessage;
import com.google.cloud.accessapproval.v1.DismissApprovalRequestMessage;
import com.google.cloud.accessapproval.v1.FolderName;
import com.google.cloud.accessapproval.v1.GetAccessApprovalServiceAccountMessage;
import com.google.cloud.accessapproval.v1.GetAccessApprovalSettingsMessage;
import com.google.cloud.accessapproval.v1.GetApprovalRequestMessage;
import com.google.cloud.accessapproval.v1.InvalidateApprovalRequestMessage;
import com.google.cloud.accessapproval.v1.ListApprovalRequestsMessage;
import com.google.cloud.accessapproval.v1.ListApprovalRequestsResponse;
import com.google.cloud.accessapproval.v1.OrganizationName;
import com.google.cloud.accessapproval.v1.ProjectName;
import com.google.cloud.accessapproval.v1.UpdateAccessApprovalSettingsMessage;
import com.google.cloud.accessapproval.v1.stub.AccessApprovalStub;
import com.google.cloud.accessapproval.v1.stub.AccessApprovalStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AccessApprovalAdminClient
implements BackgroundResource {
    private final AccessApprovalAdminSettings settings;
    private final AccessApprovalStub stub;

    public static final AccessApprovalAdminClient create() throws IOException {
        return AccessApprovalAdminClient.create(AccessApprovalAdminSettings.newBuilder().build());
    }

    public static final AccessApprovalAdminClient create(AccessApprovalAdminSettings settings) throws IOException {
        return new AccessApprovalAdminClient(settings);
    }

    public static final AccessApprovalAdminClient create(AccessApprovalStub stub) {
        return new AccessApprovalAdminClient(stub);
    }

    protected AccessApprovalAdminClient(AccessApprovalAdminSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AccessApprovalStubSettings)settings.getStubSettings()).createStub();
    }

    protected AccessApprovalAdminClient(AccessApprovalStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AccessApprovalAdminSettings getSettings() {
        return this.settings;
    }

    public AccessApprovalStub getStub() {
        return this.stub;
    }

    public final ListApprovalRequestsPagedResponse listApprovalRequests(FolderName parent) {
        ListApprovalRequestsMessage request = ListApprovalRequestsMessage.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listApprovalRequests(request);
    }

    public final ListApprovalRequestsPagedResponse listApprovalRequests(OrganizationName parent) {
        ListApprovalRequestsMessage request = ListApprovalRequestsMessage.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listApprovalRequests(request);
    }

    public final ListApprovalRequestsPagedResponse listApprovalRequests(ProjectName parent) {
        ListApprovalRequestsMessage request = ListApprovalRequestsMessage.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listApprovalRequests(request);
    }

    public final ListApprovalRequestsPagedResponse listApprovalRequests(String parent) {
        ListApprovalRequestsMessage request = ListApprovalRequestsMessage.newBuilder().setParent(parent).build();
        return this.listApprovalRequests(request);
    }

    public final ListApprovalRequestsPagedResponse listApprovalRequests(ListApprovalRequestsMessage request) {
        return (ListApprovalRequestsPagedResponse)((Object)this.listApprovalRequestsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListApprovalRequestsMessage, ListApprovalRequestsPagedResponse> listApprovalRequestsPagedCallable() {
        return this.stub.listApprovalRequestsPagedCallable();
    }

    public final UnaryCallable<ListApprovalRequestsMessage, ListApprovalRequestsResponse> listApprovalRequestsCallable() {
        return this.stub.listApprovalRequestsCallable();
    }

    public final ApprovalRequest getApprovalRequest(ApprovalRequestName name) {
        GetApprovalRequestMessage request = GetApprovalRequestMessage.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getApprovalRequest(request);
    }

    public final ApprovalRequest getApprovalRequest(String name) {
        GetApprovalRequestMessage request = GetApprovalRequestMessage.newBuilder().setName(name).build();
        return this.getApprovalRequest(request);
    }

    public final ApprovalRequest getApprovalRequest(GetApprovalRequestMessage request) {
        return (ApprovalRequest)this.getApprovalRequestCallable().call((Object)request);
    }

    public final UnaryCallable<GetApprovalRequestMessage, ApprovalRequest> getApprovalRequestCallable() {
        return this.stub.getApprovalRequestCallable();
    }

    public final ApprovalRequest approveApprovalRequest(ApproveApprovalRequestMessage request) {
        return (ApprovalRequest)this.approveApprovalRequestCallable().call((Object)request);
    }

    public final UnaryCallable<ApproveApprovalRequestMessage, ApprovalRequest> approveApprovalRequestCallable() {
        return this.stub.approveApprovalRequestCallable();
    }

    public final ApprovalRequest dismissApprovalRequest(DismissApprovalRequestMessage request) {
        return (ApprovalRequest)this.dismissApprovalRequestCallable().call((Object)request);
    }

    public final UnaryCallable<DismissApprovalRequestMessage, ApprovalRequest> dismissApprovalRequestCallable() {
        return this.stub.dismissApprovalRequestCallable();
    }

    public final ApprovalRequest invalidateApprovalRequest(InvalidateApprovalRequestMessage request) {
        return (ApprovalRequest)this.invalidateApprovalRequestCallable().call((Object)request);
    }

    public final UnaryCallable<InvalidateApprovalRequestMessage, ApprovalRequest> invalidateApprovalRequestCallable() {
        return this.stub.invalidateApprovalRequestCallable();
    }

    public final AccessApprovalSettings getAccessApprovalSettings(AccessApprovalSettingsName name) {
        GetAccessApprovalSettingsMessage request = GetAccessApprovalSettingsMessage.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAccessApprovalSettings(request);
    }

    public final AccessApprovalSettings getAccessApprovalSettings(String name) {
        GetAccessApprovalSettingsMessage request = GetAccessApprovalSettingsMessage.newBuilder().setName(name).build();
        return this.getAccessApprovalSettings(request);
    }

    public final AccessApprovalSettings getAccessApprovalSettings(GetAccessApprovalSettingsMessage request) {
        return (AccessApprovalSettings)this.getAccessApprovalSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<GetAccessApprovalSettingsMessage, AccessApprovalSettings> getAccessApprovalSettingsCallable() {
        return this.stub.getAccessApprovalSettingsCallable();
    }

    public final AccessApprovalSettings updateAccessApprovalSettings(AccessApprovalSettings settings, FieldMask updateMask) {
        UpdateAccessApprovalSettingsMessage request = UpdateAccessApprovalSettingsMessage.newBuilder().setSettings(settings).setUpdateMask(updateMask).build();
        return this.updateAccessApprovalSettings(request);
    }

    public final AccessApprovalSettings updateAccessApprovalSettings(UpdateAccessApprovalSettingsMessage request) {
        return (AccessApprovalSettings)this.updateAccessApprovalSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAccessApprovalSettingsMessage, AccessApprovalSettings> updateAccessApprovalSettingsCallable() {
        return this.stub.updateAccessApprovalSettingsCallable();
    }

    public final void deleteAccessApprovalSettings(AccessApprovalSettingsName name) {
        DeleteAccessApprovalSettingsMessage request = DeleteAccessApprovalSettingsMessage.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAccessApprovalSettings(request);
    }

    public final void deleteAccessApprovalSettings(String name) {
        DeleteAccessApprovalSettingsMessage request = DeleteAccessApprovalSettingsMessage.newBuilder().setName(name).build();
        this.deleteAccessApprovalSettings(request);
    }

    public final void deleteAccessApprovalSettings(DeleteAccessApprovalSettingsMessage request) {
        this.deleteAccessApprovalSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAccessApprovalSettingsMessage, Empty> deleteAccessApprovalSettingsCallable() {
        return this.stub.deleteAccessApprovalSettingsCallable();
    }

    public final AccessApprovalServiceAccount getAccessApprovalServiceAccount(String name) {
        GetAccessApprovalServiceAccountMessage request = GetAccessApprovalServiceAccountMessage.newBuilder().setName(name).build();
        return this.getAccessApprovalServiceAccount(request);
    }

    public final AccessApprovalServiceAccount getAccessApprovalServiceAccount(GetAccessApprovalServiceAccountMessage request) {
        return (AccessApprovalServiceAccount)this.getAccessApprovalServiceAccountCallable().call((Object)request);
    }

    public final UnaryCallable<GetAccessApprovalServiceAccountMessage, AccessApprovalServiceAccount> getAccessApprovalServiceAccountCallable() {
        return this.stub.getAccessApprovalServiceAccountCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListApprovalRequestsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListApprovalRequestsMessage, ListApprovalRequestsResponse, ApprovalRequest, ListApprovalRequestsPage, ListApprovalRequestsFixedSizeCollection> {
        private ListApprovalRequestsFixedSizeCollection(List<ListApprovalRequestsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListApprovalRequestsFixedSizeCollection createEmptyCollection() {
            return new ListApprovalRequestsFixedSizeCollection(null, 0);
        }

        protected ListApprovalRequestsFixedSizeCollection createCollection(List<ListApprovalRequestsPage> pages, int collectionSize) {
            return new ListApprovalRequestsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListApprovalRequestsPage
    extends AbstractPage<ListApprovalRequestsMessage, ListApprovalRequestsResponse, ApprovalRequest, ListApprovalRequestsPage> {
        private ListApprovalRequestsPage(PageContext<ListApprovalRequestsMessage, ListApprovalRequestsResponse, ApprovalRequest> context, ListApprovalRequestsResponse response) {
            super(context, (Object)response);
        }

        private static ListApprovalRequestsPage createEmptyPage() {
            return new ListApprovalRequestsPage(null, null);
        }

        protected ListApprovalRequestsPage createPage(PageContext<ListApprovalRequestsMessage, ListApprovalRequestsResponse, ApprovalRequest> context, ListApprovalRequestsResponse response) {
            return new ListApprovalRequestsPage(context, response);
        }

        public ApiFuture<ListApprovalRequestsPage> createPageAsync(PageContext<ListApprovalRequestsMessage, ListApprovalRequestsResponse, ApprovalRequest> context, ApiFuture<ListApprovalRequestsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListApprovalRequestsPagedResponse
    extends AbstractPagedListResponse<ListApprovalRequestsMessage, ListApprovalRequestsResponse, ApprovalRequest, ListApprovalRequestsPage, ListApprovalRequestsFixedSizeCollection> {
        public static ApiFuture<ListApprovalRequestsPagedResponse> createAsync(PageContext<ListApprovalRequestsMessage, ListApprovalRequestsResponse, ApprovalRequest> context, ApiFuture<ListApprovalRequestsResponse> futureResponse) {
            ApiFuture<ListApprovalRequestsPage> futurePage = ListApprovalRequestsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListApprovalRequestsPagedResponse((ListApprovalRequestsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListApprovalRequestsPagedResponse(ListApprovalRequestsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListApprovalRequestsFixedSizeCollection.createEmptyCollection());
        }
    }
}

