/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gcs.analyticscore.client;

import com.google.cloud.gcs.analyticscore.client.GcsObjectCombinedRange;
import com.google.cloud.gcs.analyticscore.client.GcsObjectRange;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Comparator;

class VectoredIoUtil {
    VectoredIoUtil() {
    }

    public static ImmutableList<GcsObjectRange> sortGcsObjectRanges(ImmutableList<GcsObjectRange> ranges) {
        return (ImmutableList)ranges.stream().sorted(Comparator.comparingLong(GcsObjectRange::getOffset)).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<GcsObjectCombinedRange> mergeGcsObjectRanges(ImmutableList<GcsObjectRange> ranges, int maxMergeGap, int maxMergeSize) {
        if (ranges == null || ranges.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList<GcsObjectRange> sortedRanges = VectoredIoUtil.sortGcsObjectRanges(ranges);
        ImmutableList.Builder combinedRanges = ImmutableList.builder();
        GcsObjectCombinedRange currentCombinedRange = null;
        for (GcsObjectRange nextRange : sortedRanges) {
            long potentialMergedSize;
            if (currentCombinedRange == null) {
                currentCombinedRange = VectoredIoUtil.createCombinedRangeFromSingleRange(nextRange);
                continue;
            }
            long currentEnd = currentCombinedRange.getOffset() + (long)currentCombinedRange.getLength();
            long nextEnd = nextRange.getOffset() + (long)nextRange.getLength();
            long gap = nextRange.getOffset() - currentEnd;
            if (VectoredIoUtil.canMerge(gap, potentialMergedSize = Math.max(currentEnd, nextEnd) - currentCombinedRange.getOffset(), maxMergeGap, maxMergeSize)) {
                currentCombinedRange = currentCombinedRange.union(nextRange);
                continue;
            }
            combinedRanges.add((Object)currentCombinedRange);
            currentCombinedRange = VectoredIoUtil.createCombinedRangeFromSingleRange(nextRange);
        }
        if (currentCombinedRange != null) {
            combinedRanges.add(currentCombinedRange);
        }
        return combinedRanges.build();
    }

    public static ByteBuffer fetchUnderlyingRangeData(ByteBuffer dataBuffer, GcsObjectCombinedRange combinedRange, GcsObjectRange underlyingRange) {
        int requestOffset = (int)(underlyingRange.getOffset() - combinedRange.getOffset());
        int requestLength = underlyingRange.getLength();
        ByteBuffer result = dataBuffer.slice();
        result.position(requestOffset);
        result.limit(requestOffset + requestLength);
        return result;
    }

    private static GcsObjectCombinedRange createCombinedRangeFromSingleRange(GcsObjectRange range) {
        return GcsObjectCombinedRange.builder().setOffset(range.getOffset()).setLength(range.getLength()).setUnderlyingRanges((ImmutableList<GcsObjectRange>)ImmutableList.of((Object)range)).build();
    }

    private static boolean canMerge(long gap, long potentialMergedSize, long maxMergeGap, long maxMergeSize) {
        return gap < maxMergeGap && potentialMergedSize <= maxMergeSize;
    }
}

