/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gcs.analyticscore.client;

import com.google.cloud.gcs.analyticscore.client.GcsItemId;
import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class UriUtil {
    private static final Pattern GCS_PATH_PATTERN = Pattern.compile("gs://(([^/]+)(/(.+)?)?)?");

    private UriUtil() {
    }

    static GcsItemId getItemIdFromString(String path) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path should not be null");
        Matcher matcher = GCS_PATH_PATTERN.matcher(path);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Invalid GCS path: %s", (Object)path);
        String bucketName = matcher.group(2);
        String relativePath = matcher.group(4);
        Preconditions.checkArgument((bucketName != null ? 1 : 0) != 0, (String)"GCS path must include a bucket name: %s", (Object)path);
        if (relativePath == null) {
            return GcsItemId.builder().setBucketName(bucketName).build();
        }
        return GcsItemId.builder().setBucketName(bucketName).setObjectName(relativePath).build();
    }
}

