/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gcs.analyticscore.client;

import com.google.auto.value.AutoValue;
import com.google.cloud.gcs.analyticscore.client.AutoValue_GcsFileSystemOptions;
import com.google.cloud.gcs.analyticscore.client.GcsClientOptions;
import java.util.Map;

@AutoValue
public abstract class GcsFileSystemOptions {
    private static final String READ_THREAD_COUNT_KEY = "analytics-core.read.thread.count";
    private static final String CLIENT_TYPE_KEY = "client.type";

    public abstract int getReadThreadCount();

    public abstract ClientType getClientType();

    public abstract GcsClientOptions getGcsClientOptions();

    public static Builder builder() {
        return new AutoValue_GcsFileSystemOptions.Builder().setReadThreadCount(16).setClientType(ClientType.HTTP_CLIENT).setGcsClientOptions(GcsClientOptions.builder().build());
    }

    public static GcsFileSystemOptions createFromOptions(Map<String, String> analyticsCoreOptions, String prefix) {
        Builder optionsBuilder = GcsFileSystemOptions.builder();
        if (analyticsCoreOptions.containsKey(prefix + READ_THREAD_COUNT_KEY)) {
            optionsBuilder.setReadThreadCount(Integer.parseInt(analyticsCoreOptions.get(prefix + READ_THREAD_COUNT_KEY)));
        }
        if (analyticsCoreOptions.containsKey(prefix + CLIENT_TYPE_KEY)) {
            optionsBuilder.setClientType(ClientType.valueOf(analyticsCoreOptions.get(prefix + CLIENT_TYPE_KEY)));
        }
        optionsBuilder.setGcsClientOptions(GcsClientOptions.createFromOptions(analyticsCoreOptions, prefix));
        return optionsBuilder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setClientType(ClientType var1);

        public abstract Builder setReadThreadCount(int var1);

        public abstract Builder setGcsClientOptions(GcsClientOptions var1);

        public abstract GcsFileSystemOptions build();
    }

    public static enum ClientType {
        HTTP_CLIENT,
        GRPC_CLIENT;

    }
}

