/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gcs.analyticscore.client;

import com.google.cloud.gcs.analyticscore.client.GcsReadOptions;
import com.google.cloud.gcs.analyticscore.client.GcsVectoredReadOptions;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

final class AutoValue_GcsReadOptions
extends GcsReadOptions {
    private final Optional<Integer> chunkSize;
    private final Optional<String> decryptionKey;
    private final Optional<String> userProjectId;
    private final int footerPrefetchSizeSmallFile;
    private final int footerPrefetchSizeLargeFile;
    private final boolean footerPrefetchEnabled;
    private final int smallObjectCacheSize;
    private final GcsVectoredReadOptions gcsVectoredReadOptions;

    private AutoValue_GcsReadOptions(Optional<Integer> chunkSize, Optional<String> decryptionKey, Optional<String> userProjectId, int footerPrefetchSizeSmallFile, int footerPrefetchSizeLargeFile, boolean footerPrefetchEnabled, int smallObjectCacheSize, GcsVectoredReadOptions gcsVectoredReadOptions) {
        this.chunkSize = chunkSize;
        this.decryptionKey = decryptionKey;
        this.userProjectId = userProjectId;
        this.footerPrefetchSizeSmallFile = footerPrefetchSizeSmallFile;
        this.footerPrefetchSizeLargeFile = footerPrefetchSizeLargeFile;
        this.footerPrefetchEnabled = footerPrefetchEnabled;
        this.smallObjectCacheSize = smallObjectCacheSize;
        this.gcsVectoredReadOptions = gcsVectoredReadOptions;
    }

    @Override
    public Optional<Integer> getChunkSize() {
        return this.chunkSize;
    }

    @Override
    public Optional<String> getDecryptionKey() {
        return this.decryptionKey;
    }

    @Override
    public Optional<String> getUserProjectId() {
        return this.userProjectId;
    }

    @Override
    public int getFooterPrefetchSizeSmallFile() {
        return this.footerPrefetchSizeSmallFile;
    }

    @Override
    public int getFooterPrefetchSizeLargeFile() {
        return this.footerPrefetchSizeLargeFile;
    }

    @Override
    public boolean isFooterPrefetchEnabled() {
        return this.footerPrefetchEnabled;
    }

    @Override
    public int getSmallObjectCacheSize() {
        return this.smallObjectCacheSize;
    }

    @Override
    public GcsVectoredReadOptions getGcsVectoredReadOptions() {
        return this.gcsVectoredReadOptions;
    }

    public String toString() {
        return "GcsReadOptions{chunkSize=" + String.valueOf(this.chunkSize) + ", decryptionKey=" + String.valueOf(this.decryptionKey) + ", userProjectId=" + String.valueOf(this.userProjectId) + ", footerPrefetchSizeSmallFile=" + this.footerPrefetchSizeSmallFile + ", footerPrefetchSizeLargeFile=" + this.footerPrefetchSizeLargeFile + ", footerPrefetchEnabled=" + this.footerPrefetchEnabled + ", smallObjectCacheSize=" + this.smallObjectCacheSize + ", gcsVectoredReadOptions=" + String.valueOf(this.gcsVectoredReadOptions) + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GcsReadOptions) {
            GcsReadOptions that = (GcsReadOptions)o;
            return this.chunkSize.equals(that.getChunkSize()) && this.decryptionKey.equals(that.getDecryptionKey()) && this.userProjectId.equals(that.getUserProjectId()) && this.footerPrefetchSizeSmallFile == that.getFooterPrefetchSizeSmallFile() && this.footerPrefetchSizeLargeFile == that.getFooterPrefetchSizeLargeFile() && this.footerPrefetchEnabled == that.isFooterPrefetchEnabled() && this.smallObjectCacheSize == that.getSmallObjectCacheSize() && this.gcsVectoredReadOptions.equals(that.getGcsVectoredReadOptions());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.chunkSize.hashCode();
        h$ *= 1000003;
        h$ ^= this.decryptionKey.hashCode();
        h$ *= 1000003;
        h$ ^= this.userProjectId.hashCode();
        h$ *= 1000003;
        h$ ^= this.footerPrefetchSizeSmallFile;
        h$ *= 1000003;
        h$ ^= this.footerPrefetchSizeLargeFile;
        h$ *= 1000003;
        h$ ^= this.footerPrefetchEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.smallObjectCacheSize;
        h$ *= 1000003;
        return h$ ^= this.gcsVectoredReadOptions.hashCode();
    }

    static final class Builder
    extends GcsReadOptions.Builder {
        private Optional<Integer> chunkSize = Optional.empty();
        private Optional<String> decryptionKey = Optional.empty();
        private Optional<String> userProjectId = Optional.empty();
        private int footerPrefetchSizeSmallFile;
        private int footerPrefetchSizeLargeFile;
        private boolean footerPrefetchEnabled;
        private int smallObjectCacheSize;
        private @Nullable GcsVectoredReadOptions gcsVectoredReadOptions;
        private byte set$0;

        Builder() {
        }

        @Override
        public GcsReadOptions.Builder setChunkSize(Integer chunkSize) {
            this.chunkSize = Optional.of(chunkSize);
            return this;
        }

        @Override
        public GcsReadOptions.Builder setDecryptionKey(String decryptionKey) {
            this.decryptionKey = Optional.of(decryptionKey);
            return this;
        }

        @Override
        public GcsReadOptions.Builder setUserProjectId(String userProjectId) {
            this.userProjectId = Optional.of(userProjectId);
            return this;
        }

        @Override
        public GcsReadOptions.Builder setFooterPrefetchSizeSmallFile(int footerPrefetchSizeSmallFile) {
            this.footerPrefetchSizeSmallFile = footerPrefetchSizeSmallFile;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public GcsReadOptions.Builder setFooterPrefetchSizeLargeFile(int footerPrefetchSizeLargeFile) {
            this.footerPrefetchSizeLargeFile = footerPrefetchSizeLargeFile;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public GcsReadOptions.Builder setFooterPrefetchEnabled(boolean footerPrefetchEnabled) {
            this.footerPrefetchEnabled = footerPrefetchEnabled;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        public GcsReadOptions.Builder setSmallObjectCacheSize(int smallObjectCacheSize) {
            this.smallObjectCacheSize = smallObjectCacheSize;
            this.set$0 = (byte)(this.set$0 | 8);
            return this;
        }

        @Override
        public GcsReadOptions.Builder setGcsVectoredReadOptions(GcsVectoredReadOptions gcsVectoredReadOptions) {
            if (gcsVectoredReadOptions == null) {
                throw new NullPointerException("Null gcsVectoredReadOptions");
            }
            this.gcsVectoredReadOptions = gcsVectoredReadOptions;
            return this;
        }

        @Override
        public GcsReadOptions build() {
            if (this.set$0 != 15 || this.gcsVectoredReadOptions == null) {
                StringBuilder missing = new StringBuilder();
                if ((this.set$0 & 1) == 0) {
                    missing.append(" footerPrefetchSizeSmallFile");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" footerPrefetchSizeLargeFile");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" footerPrefetchEnabled");
                }
                if ((this.set$0 & 8) == 0) {
                    missing.append(" smallObjectCacheSize");
                }
                if (this.gcsVectoredReadOptions == null) {
                    missing.append(" gcsVectoredReadOptions");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_GcsReadOptions(this.chunkSize, this.decryptionKey, this.userProjectId, this.footerPrefetchSizeSmallFile, this.footerPrefetchSizeLargeFile, this.footerPrefetchEnabled, this.smallObjectCacheSize, this.gcsVectoredReadOptions);
        }
    }
}

