/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker.gcf;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class JsonLogHandler
extends Handler {
    private static final String SOURCE_LOCATION_KEY = "\"logging.googleapis.com/sourceLocation\": ";
    private static final String LOG_EXECUTION_ID_ENV_NAME = "LOG_EXECUTION_ID";
    private static final String DEBUG = "DEBUG";
    private static final String INFO = "INFO";
    private static final String WARNING = "WARNING";
    private static final String ERROR = "ERROR";
    private static final String DEFAULT = "DEFAULT";
    private final PrintStream out;
    private final boolean closePrintStreamOnClose;
    private static final ConcurrentMap<String, String> executionIdByThreadMap = new ConcurrentHashMap<String, String>();

    public JsonLogHandler(PrintStream out, boolean closePrintStreamOnClose) {
        this.out = out;
        this.closePrintStreamOnClose = closePrintStreamOnClose;
    }

    @Override
    public void publish(LogRecord record) {
        StringBuilder json = new StringBuilder("{");
        JsonLogHandler.appendSeverity(json, record);
        JsonLogHandler.appendSourceLocation(json, record);
        this.appendExecutionId(json, record);
        JsonLogHandler.appendMessage(json, record);
        json.append("}");
        this.out.println(json);
    }

    private static void appendMessage(StringBuilder json, LogRecord record) {
        json.append("\"message\": \"").append(JsonLogHandler.escapeString(record.getMessage()));
        if (record.getThrown() != null) {
            json.append("\\n").append(JsonLogHandler.escapeString(JsonLogHandler.getStackTraceAsString(record.getThrown())));
        }
        json.append("\"");
    }

    private static void appendSeverity(StringBuilder json, LogRecord record) {
        json.append("\"severity\": \"").append(JsonLogHandler.levelToSeverity(record.getLevel())).append("\", ");
    }

    private static String levelToSeverity(Level level) {
        int intLevel = level == null ? 0 : level.intValue();
        switch (intLevel) {
            case 300: 
            case 400: 
            case 500: {
                return DEBUG;
            }
            case 700: 
            case 800: {
                return INFO;
            }
            case 900: {
                return WARNING;
            }
            case 1000: {
                return ERROR;
            }
        }
        return DEFAULT;
    }

    private static void appendSourceLocation(StringBuilder json, LogRecord record) {
        if (record.getSourceClassName() == null && record.getSourceMethodName() == null) {
            return;
        }
        ArrayList<CallSite> entries = new ArrayList<CallSite>();
        if (record.getSourceClassName() != null) {
            String fileName = record.getSourceClassName().replace('.', '/') + ".java";
            entries.add((CallSite)((Object)("\"file\": \"" + JsonLogHandler.escapeString(fileName) + "\"")));
        }
        if (record.getSourceMethodName() != null) {
            entries.add((CallSite)((Object)("\"method\": \"" + JsonLogHandler.escapeString(record.getSourceMethodName()) + "\"")));
        }
        json.append(SOURCE_LOCATION_KEY).append("{").append(String.join((CharSequence)", ", entries)).append("}, ");
    }

    private void appendExecutionId(StringBuilder json, LogRecord record) {
        if (this.executionIdLoggingEnabled()) {
            json.append("\"execution_id\": \"").append((String)executionIdByThreadMap.get(Integer.toString(record.getThreadID()))).append("\", ");
        }
    }

    private static String escapeString(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r");
    }

    private static String getStackTraceAsString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        t.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() throws SecurityException {
        if (this.closePrintStreamOnClose) {
            this.out.close();
        }
    }

    public void addExecutionId(long threadId, String executionId) {
        executionIdByThreadMap.put(Long.toString(threadId), executionId);
    }

    public void removeExecutionId(long threadId) {
        executionIdByThreadMap.remove(Long.toString(threadId));
    }

    private boolean executionIdLoggingEnabled() {
        return Boolean.parseBoolean(System.getenv().getOrDefault(LOG_EXECUTION_ID_ENV_NAME, "false"));
    }
}

