/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker.gcf;

import com.google.cloud.functions.invoker.gcf.JsonLogHandler;
import java.util.Base64;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public final class ExecutionIdUtil {
    private static final Logger rootLogger = Logger.getLogger("");
    private static final int EXECUTION_ID_LENGTH = 12;
    private static final String EXECUTION_ID_HTTP_HEADER = "HTTP_FUNCTION_EXECUTION_ID";
    private static final String LOG_EXECUTION_ID_ENV_NAME = "LOG_EXECUTION_ID";
    private final Random random = ThreadLocalRandom.current();

    public void storeExecutionId(HttpServletRequest request) {
        if (!this.executionIdLoggingEnabled()) {
            return;
        }
        for (Handler handler : rootLogger.getHandlers()) {
            if (!(handler instanceof JsonLogHandler)) continue;
            String id = this.getOrGenerateExecutionId(request);
            ((JsonLogHandler)handler).addExecutionId(Thread.currentThread().getId(), id);
        }
    }

    public void removeExecutionId() {
        if (!this.executionIdLoggingEnabled()) {
            return;
        }
        for (Handler handler : rootLogger.getHandlers()) {
            if (!(handler instanceof JsonLogHandler)) continue;
            ((JsonLogHandler)handler).removeExecutionId(Thread.currentThread().getId());
        }
    }

    private String getOrGenerateExecutionId(HttpServletRequest request) {
        String executionId = request.getHeader(EXECUTION_ID_HTTP_HEADER);
        if (executionId == null) {
            byte[] array = new byte[12];
            this.random.nextBytes(array);
            executionId = Base64.getEncoder().encodeToString(array);
        }
        return executionId;
    }

    private boolean executionIdLoggingEnabled() {
        return Boolean.parseBoolean(System.getenv().getOrDefault(LOG_EXECUTION_ID_ENV_NAME, "false"));
    }
}

