/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker;

import com.google.cloud.functions.HttpFunction;
import com.google.cloud.functions.invoker.http.HttpRequestImpl;
import com.google.cloud.functions.invoker.http.HttpResponseImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpFunctionExecutor
extends HttpServlet {
    private static final Logger logger = Logger.getLogger("com.google.cloud.functions.invoker");
    private final HttpFunction function;

    private HttpFunctionExecutor(HttpFunction function) {
        this.function = function;
    }

    public static HttpFunctionExecutor forClass(Class<?> functionClass) {
        if (!HttpFunction.class.isAssignableFrom(functionClass)) {
            throw new RuntimeException("Class " + functionClass.getName() + " does not implement " + HttpFunction.class.getName());
        }
        Class<HttpFunction> httpFunctionClass = functionClass.asSubclass(HttpFunction.class);
        try {
            HttpFunction httpFunction = httpFunctionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return new HttpFunctionExecutor(httpFunction);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not construct an instance of " + functionClass.getName() + ": " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(HttpServletRequest req, HttpServletResponse res) {
        HttpRequestImpl reqImpl = new HttpRequestImpl(req);
        HttpResponseImpl respImpl = new HttpResponseImpl(res);
        ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.function.getClass().getClassLoader());
            this.function.service(reqImpl, respImpl);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Failed to execute " + this.function.getClass().getName(), t);
            res.setStatus(500);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextLoader);
            respImpl.flush();
        }
    }
}

