/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker;

import com.google.cloud.functions.invoker.CloudFunctionsContext;
import com.google.cloud.functions.invoker.Event;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import io.cloudevents.CloudEvent;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;

class CloudEvents {
    private static final String PUB_SUB_MESSAGE_TYPE = "type.googleapis.com/google.pubsub.v1.PubsubMessage";
    private static final Map<String, EventAdapter> EVENT_TYPE_MAPPING = Map.ofEntries(Map.entry("google.cloud.pubsub.topic.v1.messagePublished", new PubSubEventAdapter("google.pubsub.topic.publish")), Map.entry("google.cloud.storage.object.v1.finalized", new StorageEventAdapter("google.storage.object.finalize")), Map.entry("google.cloud.storage.object.v1.deleted", new StorageEventAdapter("google.storage.object.delete")), Map.entry("google.cloud.storage.object.v1.archived", new StorageEventAdapter("google.storage.object.archive")), Map.entry("google.cloud.storage.object.v1.metadataUpdated", new StorageEventAdapter("google.storage.object.metadataUpdate")), Map.entry("google.cloud.firestore.document.v1.written", new EventAdapter("providers/cloud.firestore/eventTypes/document.write")), Map.entry("google.cloud.firestore.document.v1.created", new EventAdapter("providers/cloud.firestore/eventTypes/document.create")), Map.entry("google.cloud.firestore.document.v1.updated", new EventAdapter("providers/cloud.firestore/eventTypes/document.update")), Map.entry("google.cloud.firestore.document.v1.deleted", new EventAdapter("providers/cloud.firestore/eventTypes/document.delete")), Map.entry("google.firebase.analytics.log.v1.written", new EventAdapter("providers/google.firebase.analytics/eventTypes/event.log")), Map.entry("google.firebase.auth.user.v1.created", new FirebaseAuthEventAdapter("providers/firebase.auth/eventTypes/user.create")), Map.entry("google.firebase.auth.user.v1.deleted", new FirebaseAuthEventAdapter("providers/firebase.auth/eventTypes/user.delete")), Map.entry("google.firebase.database.ref.v1.created", new FirebaseDatabaseEventAdapter("providers/google.firebase.database/eventTypes/ref.create")), Map.entry("google.firebase.database.ref.v1.written", new FirebaseDatabaseEventAdapter("providers/google.firebase.database/eventTypes/ref.write")), Map.entry("google.firebase.database.ref.v1.updated", new FirebaseDatabaseEventAdapter("providers/google.firebase.database/eventTypes/ref.update")), Map.entry("google.firebase.database.ref.v1.deleted", new FirebaseDatabaseEventAdapter("providers/google.firebase.database/eventTypes/ref.delete")), Map.entry("google.cloud.storage.object.v1.changed", new StorageEventAdapter("providers/cloud.storage/eventTypes/object.change")));
    private static final Gson GSON = new GsonBuilder().serializeNulls().create();

    CloudEvents() {
    }

    static Event convertToLegacyEvent(CloudEvent cloudEvent) {
        String eventType = cloudEvent.getType();
        EventAdapter eventAdapter = EVENT_TYPE_MAPPING.get(eventType);
        if (eventAdapter == null) {
            throw new IllegalArgumentException("Unrecognized CloudEvent type \"" + eventType + "\"");
        }
        return eventAdapter.convertToLegacyEvent(cloudEvent);
    }

    private static class StorageEventAdapter
    extends EventAdapter {
        StorageEventAdapter(String legacyEventType) {
            super(legacyEventType);
        }

        @Override
        Event createLegacyEvent(EventAdapter.ParsedCloudEvent event, CloudFunctionsContext.Builder builder, JsonObject data) {
            JsonObject resource = new JsonObject();
            resource.addProperty("service", event.Service);
            resource.addProperty("name", event.Resource);
            if (data.has("kind")) {
                resource.addProperty("type", data.get("kind").getAsString());
            }
            builder.setResource(GSON.toJson(resource));
            return Event.of(data, builder.build());
        }
    }

    private static class FirebaseDatabaseEventAdapter
    extends EventAdapter {
        private static Pattern resourcePattern = Pattern.compile("/locations/[^/]+");

        FirebaseDatabaseEventAdapter(String legacyEventType) {
            super(legacyEventType);
        }

        @Override
        Event createLegacyEvent(EventAdapter.ParsedCloudEvent event, CloudFunctionsContext.Builder builder, JsonObject data) {
            builder.setResource(resourcePattern.matcher(event.Resource).replaceAll(""));
            return Event.of(data, builder.build());
        }
    }

    private static class FirebaseAuthEventAdapter
    extends EventAdapter {
        FirebaseAuthEventAdapter(String legacyEventType) {
            super(legacyEventType);
        }

        @Override
        Event createLegacyEvent(EventAdapter.ParsedCloudEvent event, CloudFunctionsContext.Builder builder, JsonObject data) {
            JsonElement meta;
            builder.setResource(event.Name);
            if (data.has("metadata") && (meta = data.get("metadata")).isJsonObject()) {
                JsonElement lastSignInTime;
                JsonObject metaObj = meta.getAsJsonObject();
                JsonElement createTime = metaObj.get("createTime");
                if (createTime != null) {
                    metaObj.add("createdAt", createTime);
                    metaObj.remove("createTime");
                }
                if ((lastSignInTime = metaObj.get("lastSignInTime")) != null) {
                    metaObj.add("lastSignedInAt", lastSignInTime);
                    metaObj.remove("lastSignInTime");
                }
            }
            return Event.of(data, builder.build());
        }
    }

    private static class PubSubEventAdapter
    extends EventAdapter {
        PubSubEventAdapter(String legacyEventType) {
            super(legacyEventType);
        }

        @Override
        Event createLegacyEvent(EventAdapter.ParsedCloudEvent event, CloudFunctionsContext.Builder builder, JsonObject data) {
            JsonElement message;
            JsonObject resource = new JsonObject();
            resource.addProperty("service", event.Service);
            resource.addProperty("name", event.Name);
            resource.addProperty("type", CloudEvents.PUB_SUB_MESSAGE_TYPE);
            builder.setResource(GSON.toJson(resource));
            if (data.has("message") && (message = data.get("message")).isJsonObject()) {
                data = message.getAsJsonObject();
            }
            data.remove("messageId");
            data.remove("publishTime");
            return Event.of(data, builder.build());
        }
    }

    private static class EventAdapter {
        private final String legacyEventType;
        private static Pattern sourcePattern = Pattern.compile("//([^/]+)/(.+)");

        EventAdapter(String legacyEventType) {
            this.legacyEventType = legacyEventType;
        }

        final Event convertToLegacyEvent(CloudEvent cloudEvent) {
            Matcher m = sourcePattern.matcher(cloudEvent.getSource().toString());
            if (!m.find() || m.groupCount() != 2) {
                throw new IllegalArgumentException(String.format("Invalid CloudEvent source '%s', unable to parse into resource service and name", cloudEvent.getSource().toString()));
            }
            String service = m.group(1);
            String name = m.group(2);
            String resource = String.format("%s/%s", name, cloudEvent.getSubject());
            ParsedCloudEvent parsed = new ParsedCloudEvent(resource, service, name);
            OffsetDateTime timestamp = Optional.ofNullable(cloudEvent.getTime()).orElse(OffsetDateTime.now());
            CloudFunctionsContext.Builder ctxBuilder = CloudFunctionsContext.builder().setEventId(cloudEvent.getId()).setEventType(this.legacyEventType).setResource(resource).setTimestamp(DateTimeFormatter.ISO_INSTANT.format(timestamp));
            JsonObject data = GSON.fromJson(new String(cloudEvent.getData().toBytes(), StandardCharsets.UTF_8), JsonObject.class);
            return this.createLegacyEvent(parsed, ctxBuilder, data);
        }

        Event createLegacyEvent(ParsedCloudEvent event, CloudFunctionsContext.Builder builder, JsonObject data) {
            return Event.of(data, builder.build());
        }

        protected class ParsedCloudEvent {
            public final String Resource;
            public final String Service;
            public final String Name;

            public ParsedCloudEvent(String resource, String service, String name) {
                this.Resource = resource;
                this.Service = service;
                this.Name = name;
            }
        }
    }
}

