/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.impl;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.rw.CloudEventContextReader;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventDataMapper;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventReader;
import io.cloudevents.rw.CloudEventWriter;
import io.cloudevents.rw.CloudEventWriterFactory;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class BaseCloudEvent
implements CloudEvent,
CloudEventReader,
CloudEventContextReader {
    private final CloudEventData data;
    protected final Map<String, Object> extensions;

    protected BaseCloudEvent(CloudEventData data, Map<String, Object> extensions) {
        this.data = data;
        this.extensions = extensions != null ? extensions : new HashMap();
    }

    @Override
    public CloudEventData getData() {
        return this.data;
    }

    @Override
    public Object getExtension(String extensionName) {
        return this.extensions.get(extensionName);
    }

    @Override
    public Set<String> getExtensionNames() {
        return this.extensions.keySet();
    }

    public <T extends CloudEventWriter<V>, V> V read(CloudEventWriterFactory<T, V> writerFactory, CloudEventDataMapper<? extends CloudEventData> mapper) throws CloudEventRWException, IllegalStateException {
        T writer = writerFactory.create(this.getSpecVersion());
        this.readContext((CloudEventContextWriter)writer);
        if (this.data != null) {
            return writer.end(mapper.map(this.data));
        }
        return writer.end();
    }

    protected void readExtensions(CloudEventContextWriter writer) throws CloudEventRWException {
        for (Map.Entry<String, Object> entry : this.extensions.entrySet()) {
            if (entry.getValue() instanceof String) {
                writer.withContextAttribute(entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Number) {
                writer.withContextAttribute(entry.getKey(), (Number)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Boolean) {
                writer.withContextAttribute(entry.getKey(), (Boolean)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof URI) {
                writer.withContextAttribute(entry.getKey(), (URI)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof OffsetDateTime) {
                writer.withContextAttribute(entry.getKey(), (OffsetDateTime)entry.getValue());
                continue;
            }
            throw new IllegalStateException("Illegal value inside extensions map: " + entry);
        }
    }
}

