/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker;

import com.google.auto.value.AutoValue;
import com.google.cloud.functions.invoker.AutoValue_Event;
import com.google.cloud.functions.invoker.CloudFunctionsContext;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

@AutoValue
abstract class Event {
    Event() {
    }

    static Event of(JsonElement data, CloudFunctionsContext context) {
        return new AutoValue_Event(data, context);
    }

    abstract JsonElement getData();

    abstract CloudFunctionsContext getContext();

    static class EventDeserializer
    implements JsonDeserializer<Event> {
        EventDeserializer() {
        }

        @Override
        public Event deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            CloudFunctionsContext context;
            JsonObject root = jsonElement.getAsJsonObject();
            JsonElement data = root.get("data");
            if (root.has("context")) {
                JsonObject contextCopy = root.getAsJsonObject("context").deepCopy();
                context = (CloudFunctionsContext)jsonDeserializationContext.deserialize(this.adjustContextResource(contextCopy), (Type)((Object)CloudFunctionsContext.class));
            } else if (this.isPubSubEmulatorPayload(root)) {
                JsonObject message = root.getAsJsonObject("message");
                String timestampString = message.has("publishTime") ? message.get("publishTime").getAsString() : DateTimeFormatter.ISO_INSTANT.format(OffsetDateTime.now());
                context = CloudFunctionsContext.builder().setEventType("google.pubsub.topic.publish").setTimestamp(timestampString).setEventId(message.get("messageId").getAsString()).setResource("{\"name\":null,\"service\":\"pubsub.googleapis.com\",\"type\":\"type.googleapis.com/google.pubsub.v1.PubsubMessage\"}").build();
                JsonObject marshalledData = new JsonObject();
                marshalledData.addProperty("@type", "type.googleapis.com/google.pubsub.v1.PubsubMessage");
                marshalledData.add("data", message.get("data"));
                if (message.has("attributes")) {
                    marshalledData.add("attributes", message.get("attributes"));
                }
                data = marshalledData;
            } else {
                JsonObject rootCopy = root.deepCopy();
                rootCopy.remove("data");
                context = (CloudFunctionsContext)jsonDeserializationContext.deserialize(this.adjustContextResource(rootCopy), (Type)((Object)CloudFunctionsContext.class));
            }
            return Event.of(data, context);
        }

        private boolean isPubSubEmulatorPayload(JsonObject root) {
            if (root.has("subscription") && root.has("message") && root.get("message").isJsonObject()) {
                JsonObject message = root.getAsJsonObject("message");
                return message.has("data") && message.has("messageId");
            }
            return false;
        }

        private JsonObject adjustContextResource(JsonObject contextObject) {
            String resourceValue = contextObject.has("resource") ? contextObject.get("resource").toString() : "";
            contextObject.remove("resource");
            contextObject.addProperty("resource", resourceValue);
            return contextObject;
        }
    }
}

