/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.v2;

import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.r2dbc.api.SpannerConnection;
import com.google.cloud.spanner.r2dbc.statement.StatementParser;
import com.google.cloud.spanner.r2dbc.statement.StatementType;
import com.google.cloud.spanner.r2dbc.v2.DatabaseClientReactiveAdapter;
import com.google.cloud.spanner.r2dbc.v2.SpannerBatch;
import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibraryDdlStatement;
import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibraryDmlStatement;
import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibraryStatement;
import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionMetadata;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Statement;
import io.r2dbc.spi.ValidationDepth;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class SpannerClientLibraryConnection
implements Connection,
SpannerConnection {
    private final DatabaseClientReactiveAdapter clientLibraryAdapter;

    public SpannerClientLibraryConnection(DatabaseClientReactiveAdapter clientLibraryAdapter) {
        this.clientLibraryAdapter = clientLibraryAdapter;
    }

    public Publisher<Void> beginTransaction() {
        return this.clientLibraryAdapter.beginTransaction();
    }

    @Override
    public Mono<Void> beginReadonlyTransaction(TimestampBound timestampBound) {
        return this.clientLibraryAdapter.beginReadonlyTransaction(timestampBound);
    }

    @Override
    public Mono<Void> beginReadonlyTransaction() {
        return this.clientLibraryAdapter.beginReadonlyTransaction(TimestampBound.strong());
    }

    public Publisher<Void> commitTransaction() {
        return this.clientLibraryAdapter.commitTransaction();
    }

    public Batch createBatch() {
        return new SpannerBatch(this.clientLibraryAdapter);
    }

    public Publisher<Void> createSavepoint(String name) {
        throw new UnsupportedOperationException();
    }

    public Statement createStatement(String query) {
        if (query == null) {
            throw new IllegalArgumentException("Invalid null query.");
        }
        StatementType type = StatementParser.getStatementType(query);
        if (type == StatementType.DDL) {
            return new SpannerClientLibraryDdlStatement(query, this.clientLibraryAdapter);
        }
        if (type == StatementType.DML) {
            return new SpannerClientLibraryDmlStatement(this.clientLibraryAdapter, query);
        }
        return new SpannerClientLibraryStatement(this.clientLibraryAdapter, query);
    }

    public boolean isAutoCommit() {
        return this.clientLibraryAdapter.isAutoCommit();
    }

    public ConnectionMetadata getMetadata() {
        throw new UnsupportedOperationException();
    }

    public IsolationLevel getTransactionIsolationLevel() {
        throw new UnsupportedOperationException();
    }

    public Publisher<Void> releaseSavepoint(String name) {
        throw new UnsupportedOperationException();
    }

    public Publisher<Void> rollbackTransaction() {
        return this.clientLibraryAdapter.rollback();
    }

    public Publisher<Void> rollbackTransactionToSavepoint(String name) {
        throw new UnsupportedOperationException();
    }

    public Publisher<Void> setAutoCommit(boolean autoCommit) {
        return this.clientLibraryAdapter.setAutoCommit(autoCommit);
    }

    public Publisher<Void> setTransactionIsolationLevel(IsolationLevel isolationLevel) {
        throw new UnsupportedOperationException();
    }

    public Publisher<Boolean> validate(ValidationDepth depth) {
        if (depth == ValidationDepth.LOCAL) {
            return this.clientLibraryAdapter.localHealthcheck();
        }
        return this.clientLibraryAdapter.healthCheck();
    }

    public Publisher<Void> close() {
        return this.clientLibraryAdapter.close();
    }

    @Override
    public boolean isInReadonlyTransaction() {
        return this.clientLibraryAdapter.isInReadonlyTransaction();
    }
}

