/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.v2;

import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.r2dbc.statement.StatementParser;
import com.google.cloud.spanner.r2dbc.statement.StatementType;
import com.google.cloud.spanner.r2dbc.util.Assert;
import com.google.cloud.spanner.r2dbc.v2.DatabaseClientReactiveAdapter;
import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Result;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class SpannerBatch
implements Batch {
    private DatabaseClientReactiveAdapter clientLibraryAdapter;
    private List<Statement> statements = new ArrayList<Statement>();

    SpannerBatch(DatabaseClientReactiveAdapter clientLibraryAdapter) {
        this.clientLibraryAdapter = clientLibraryAdapter;
    }

    public Batch add(String sql) {
        Assert.requireNonNull(sql, "SQL must not be null.");
        if (StatementParser.getStatementType(sql) != StatementType.DML) {
            throw new IllegalArgumentException("Only DML statements are supported in batches.");
        }
        this.statements.add(Statement.of((String)sql));
        return this;
    }

    public Publisher<? extends Result> execute() {
        if (this.statements.isEmpty()) {
            return Mono.error((Throwable)new IllegalStateException("Batch is empty."));
        }
        return this.clientLibraryAdapter.runBatchDml(this.statements);
    }
}

