/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.v2;

import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.r2dbc.v2.AbstractSpannerClientLibraryStatement;
import com.google.cloud.spanner.r2dbc.v2.DatabaseClientReactiveAdapter;
import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibraryResult;
import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibraryRow;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class SpannerClientLibraryDmlStatement
extends AbstractSpannerClientLibraryStatement {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpannerClientLibraryDmlStatement.class);

    public SpannerClientLibraryDmlStatement(DatabaseClientReactiveAdapter clientLibraryAdapter, String query) {
        super(clientLibraryAdapter, query);
    }

    @Override
    protected Mono<SpannerClientLibraryResult> executeSingle(Statement statement) {
        return this.clientLibraryAdapter.runDmlStatement(statement).map(numRowsUpdated -> new SpannerClientLibraryResult((Flux<SpannerClientLibraryRow>)Flux.empty(), this.longToInt((Long)numRowsUpdated)));
    }

    @Override
    protected Flux<SpannerClientLibraryResult> executeMultiple(List<Statement> statements) {
        return this.clientLibraryAdapter.runBatchDml(statements).flatMapIterable(numRowsArray -> LongStream.of(numRowsArray).boxed().collect(Collectors.toList())).map(numRows -> new SpannerClientLibraryResult((Flux<SpannerClientLibraryRow>)Flux.empty(), this.longToInt((Long)numRows)));
    }

    private int longToInt(Long numRows) {
        if (numRows > Integer.MAX_VALUE) {
            LOGGER.warn("Number of updated rows exceeds maximum integer value; actual rows updated = {}; returning max int value", (Object)numRows);
            return Integer.MAX_VALUE;
        }
        return numRows.intValue();
    }
}

