/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.result;

import com.google.cloud.spanner.r2dbc.SpannerRow;
import com.google.cloud.spanner.r2dbc.SpannerRowMetadata;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.PartialResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class PartialResultRowExtractor
implements Function<PartialResultSet, List<SpannerRow>> {
    private SpannerRowMetadata metadata = null;
    private int rowSize;
    private boolean prevIsChunk;
    private List<Value> currentRow = new ArrayList<Value>();
    private Object incompletePiece;
    private Value.KindCase incompletePieceKind;

    private void appendToRow(Value val, List<SpannerRow> rows) {
        this.currentRow.add(val);
        if (this.currentRow.size() == this.rowSize) {
            rows.add(new SpannerRow(this.currentRow, this.metadata));
            this.currentRow = new ArrayList<Value>();
        }
    }

    public List<SpannerRow> emitRows(PartialResultSet partialResultSet) {
        if (partialResultSet.getValuesList().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SpannerRow> rows = new ArrayList<SpannerRow>();
        this.ensureMetadataAvailable(partialResultSet);
        int availableCount = partialResultSet.getValuesCount();
        if (this.prevIsChunk) {
            this.concatFirstIncompletePiece(partialResultSet);
        }
        if (availableCount > 1 || !partialResultSet.getChunkedValue()) {
            this.emitCompleteFirstValue(partialResultSet, rows);
        }
        this.emitMiddleWholePieces(partialResultSet, rows, availableCount);
        Value lastVal = partialResultSet.getValues(availableCount - 1);
        if (!this.prevIsChunk && partialResultSet.getChunkedValue()) {
            this.initializeIncompletePiece(lastVal);
        } else if (availableCount > 1 && !partialResultSet.getChunkedValue()) {
            this.appendToRow(lastVal, rows);
        }
        this.prevIsChunk = partialResultSet.getChunkedValue();
        return rows;
    }

    private void initializeIncompletePiece(Value lastVal) {
        this.incompletePieceKind = lastVal.getKindCase();
        this.incompletePiece = lastVal.getKindCase() == Value.KindCase.STRING_VALUE ? lastVal.getStringValue() : new ArrayList(lastVal.getListValue().getValuesList());
    }

    private void emitCompleteFirstValue(PartialResultSet partialResultSet, List<SpannerRow> rows) {
        Value val = this.prevIsChunk ? this.processIncompletePiece() : partialResultSet.getValues(0);
        this.appendToRow(val, rows);
        this.prevIsChunk = false;
    }

    private Value processIncompletePiece() {
        return this.incompletePieceKind == Value.KindCase.STRING_VALUE ? Value.newBuilder().setStringValue((String)this.incompletePiece).build() : Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)((List)this.incompletePiece))).build();
    }

    private void emitMiddleWholePieces(PartialResultSet partialResultSet, List<SpannerRow> rows, int availableCount) {
        for (int i = 1; i < availableCount - 1; ++i) {
            this.appendToRow(partialResultSet.getValues(i), rows);
        }
    }

    private void concatFirstIncompletePiece(PartialResultSet partialResultSet) {
        Value firstPiece = partialResultSet.getValues(0);
        if (this.incompletePieceKind == Value.KindCase.STRING_VALUE) {
            this.incompletePiece = this.incompletePiece + firstPiece.getStringValue();
        } else {
            this.concatLists((List)this.incompletePiece, firstPiece.getListValue().getValuesList());
        }
    }

    private void ensureMetadataAvailable(PartialResultSet partialResultSet) {
        if (this.metadata == null) {
            if (!partialResultSet.hasMetadata()) {
                throw new IllegalStateException("The first partial result set for a query must contain the metadata but it was null.");
            }
            this.metadata = new SpannerRowMetadata(partialResultSet.getMetadata());
            this.rowSize = partialResultSet.getMetadata().getRowType().getFieldsCount();
        }
    }

    private boolean isMergeable(Value.KindCase kind) {
        return kind == Value.KindCase.STRING_VALUE || kind == Value.KindCase.LIST_VALUE;
    }

    private void concatLists(List<Value> a, List<Value> b) {
        if (a.size() == 0 || b.size() == 0) {
            a.addAll(b);
        } else {
            Value last = a.get(a.size() - 1);
            Value first = b.get(0);
            Value.KindCase lastKind = last.getKindCase();
            Value.KindCase firstKind = first.getKindCase();
            if (this.isMergeable(lastKind) && lastKind == firstKind) {
                Value merged = null;
                if (lastKind == Value.KindCase.STRING_VALUE) {
                    String lastStr = last.getStringValue();
                    String firstStr = first.getStringValue();
                    merged = Value.newBuilder().setStringValue(lastStr + firstStr).build();
                } else {
                    ArrayList<Value> mergedList = new ArrayList<Value>(last.getListValue().getValuesList());
                    this.concatLists(mergedList, first.getListValue().getValuesList());
                    merged = Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(mergedList)).build();
                }
                a.set(a.size() - 1, merged);
                a.addAll(b.subList(1, b.size()));
            } else {
                a.addAll(b);
            }
        }
    }

    @Override
    public List<SpannerRow> apply(PartialResultSet partialResultSet) {
        return this.emitRows(partialResultSet);
    }
}

