/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.codecs;

import com.google.cloud.spanner.r2dbc.codecs.Codec;
import com.google.cloud.spanner.r2dbc.codecs.DefaultCodecs;
import com.google.cloud.spanner.r2dbc.codecs.ValueUtils;
import com.google.cloud.spanner.r2dbc.util.Assert;
import com.google.protobuf.Value;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.util.annotation.Nullable;

class SpannerCodec<T>
implements Codec<T> {
    private final Class<T> type;
    private TypeCode typeCode;
    private Function<T, Value> doEncode;
    private BiFunction<Value, Type, T> doDecode;

    SpannerCodec(Class<T> type, TypeCode typeCode, Function<T, Value> doEncode) {
        this(type, typeCode, doEncode, (value, spannerType) -> ValueUtils.decodeValue(spannerType, value));
    }

    SpannerCodec(Class<T> type, TypeCode typeCode, Function<T, Value> doEncode, BiFunction<Value, Type, T> doDecode) {
        this.type = Assert.requireNonNull(type, "type must not be null");
        this.typeCode = Assert.requireNonNull(typeCode, "typeCode must not be null");
        this.doEncode = doEncode;
        this.doDecode = doDecode;
    }

    @Override
    public boolean canDecode(Type dataType, Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        return type.isAssignableFrom(this.type) && this.doCanDecode(dataType);
    }

    @Override
    public boolean canEncode(Class type) {
        Assert.requireNonNull(type, "type to encode must not be null");
        return this.type.isAssignableFrom(type);
    }

    @Override
    @Nullable
    public T decode(Value value, Type spannerType) {
        return this.doDecode.apply(value, spannerType);
    }

    @Override
    public Value encode(Object value) {
        return this.doEncode(value);
    }

    @Override
    public Value encodeNull() {
        return this.doEncode(null);
    }

    @Override
    public Class<T> type() {
        return this.type;
    }

    private boolean doCanDecode(Type dataType) {
        return dataType.getCode() == this.typeCode;
    }

    @Override
    public TypeCode getTypeCode() {
        return this.typeCode;
    }

    @Override
    public TypeCode getArrayElementTypeCode() {
        return null;
    }

    Value doEncode(T value) {
        if (value == null) {
            return DefaultCodecs.NULL_VALUE;
        }
        return this.doEncode.apply(value);
    }
}

