/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc;

import com.google.cloud.spanner.r2dbc.SpannerConnectionConfiguration;
import com.google.cloud.spanner.r2dbc.SpannerResult;
import com.google.cloud.spanner.r2dbc.SpannerRow;
import com.google.cloud.spanner.r2dbc.StatementExecutionContext;
import com.google.cloud.spanner.r2dbc.client.Client;
import com.google.cloud.spanner.r2dbc.result.PartialResultRowExtractor;
import com.google.cloud.spanner.r2dbc.statement.StatementBindings;
import com.google.cloud.spanner.r2dbc.statement.StatementParser;
import com.google.cloud.spanner.r2dbc.statement.StatementType;
import com.google.cloud.spanner.r2dbc.statement.TypedNull;
import com.google.cloud.spanner.r2dbc.util.Assert;
import com.google.protobuf.Struct;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.PartialResultSet;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Statement;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SpannerStatement
implements Statement {
    private Client client;
    private StatementType statementType;
    private String sql;
    private SpannerConnectionConfiguration config;
    private StatementBindings statementBindings;
    private StatementExecutionContext ctx;

    public SpannerStatement(Client client, StatementExecutionContext ctx, String sql, SpannerConnectionConfiguration config) {
        this.client = client;
        this.ctx = ctx;
        this.sql = Assert.requireNonNull(sql, "SQL string can not be null");
        this.config = config;
        this.statementBindings = new StatementBindings();
        this.statementType = StatementParser.getStatementType(this.sql);
    }

    public Statement add() {
        this.statementBindings.completeBinding();
        return this;
    }

    public Statement bind(String identifier, Object value) {
        this.statementBindings.createBind(identifier, value);
        return this;
    }

    public Statement bind(int i, Object o) {
        throw new UnsupportedOperationException("Only named parameters are supported");
    }

    public Statement bindNull(String identifier, Class<?> type) {
        return this.bind(identifier, (Object)new TypedNull(type));
    }

    public Statement bindNull(int i, Class<?> type) {
        throw new UnsupportedOperationException("Only named parameters are supported");
    }

    public Publisher<? extends Result> execute() {
        if (this.statementType == StatementType.DDL) {
            return this.client.executeDdl(this.config.getFullyQualifiedDatabaseName(), Collections.singletonList(this.sql), this.config.getDdlOperationTimeout(), this.config.getDdlOperationPollInterval()).map(operation -> new SpannerResult((Flux<SpannerRow>)Flux.empty(), (Mono<Integer>)Mono.just((Object)0)));
        }
        if (this.statementType == StatementType.DML && !this.ctx.isTransactionPartitionedDml()) {
            List<ExecuteBatchDmlRequest.Statement> dmlStatements = this.statementBindings.getBindings().stream().map(struct -> ExecuteBatchDmlRequest.Statement.newBuilder().setSql(this.sql).setParams(struct).putAllParamTypes(this.statementBindings.getTypes()).build()).collect(Collectors.toList());
            return this.client.executeBatchDml(this.ctx, dmlStatements).map(partialResultSet -> Math.toIntExact(partialResultSet.getStats().getRowCountExact())).map(rowCount -> new SpannerResult((Flux<SpannerRow>)Flux.empty(), (Mono<Integer>)Mono.just((Object)rowCount)));
        }
        Flux structFlux = Flux.fromIterable(this.statementBindings.getBindings());
        return structFlux.flatMap(this::runStreamingSql);
    }

    private Mono<SpannerResult> runStreamingSql(Struct params) {
        Flux<PartialResultSet> resultSetFlux = this.client.executeStreamingSql(this.ctx, this.sql, params, this.statementBindings.getTypes());
        if (this.statementType == StatementType.SELECT) {
            PartialResultRowExtractor partialResultRowExtractor = new PartialResultRowExtractor();
            return resultSetFlux.flatMapIterable((Function)partialResultRowExtractor, this.config.getPartialResultSetFetchSize()).transform(result -> Mono.just((Object)new SpannerResult((Flux<SpannerRow>)result, (Mono<Integer>)Mono.just((Object)0)))).next();
        }
        return resultSetFlux.last().map(partialResultSet -> {
            long rowsUpdated = Math.max(partialResultSet.getStats().getRowCountExact(), partialResultSet.getStats().getRowCountLowerBound());
            return Math.toIntExact(rowsUpdated);
        }).map(rowCount -> new SpannerResult((Flux<SpannerRow>)Flux.empty(), (Mono<Integer>)Mono.just((Object)rowCount)));
    }
}

