/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc;

import com.google.cloud.spanner.r2dbc.SpannerConnection;
import com.google.cloud.spanner.r2dbc.SpannerConnectionConfiguration;
import com.google.cloud.spanner.r2dbc.SpannerConnectionFactoryMetadata;
import com.google.cloud.spanner.r2dbc.client.Client;
import com.google.cloud.spanner.r2dbc.util.Assert;
import com.google.spanner.v1.Session;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import reactor.core.publisher.Mono;

public class SpannerConnectionFactory
implements ConnectionFactory {
    private SpannerConnectionConfiguration config;
    private Client client;

    public SpannerConnectionFactory(Client client, SpannerConnectionConfiguration config) {
        this.client = Assert.requireNonNull(client, "Spanner client must not be null");
        this.config = Assert.requireNonNull(config, "Spanner configuration must not be null");
    }

    public Mono<SpannerConnection> create() {
        return this.client.createSession(this.config.getFullyQualifiedDatabaseName()).map(session -> {
            SpannerConnection connection = new SpannerConnection(this.client, (Session)session, this.config);
            return connection;
        });
    }

    public ConnectionFactoryMetadata getMetadata() {
        return SpannerConnectionFactoryMetadata.INSTANCE;
    }
}

