/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc;

import com.google.cloud.spanner.r2dbc.SpannerBatch;
import com.google.cloud.spanner.r2dbc.SpannerConnectionConfiguration;
import com.google.cloud.spanner.r2dbc.SpannerConnectionMetadata;
import com.google.cloud.spanner.r2dbc.SpannerStatement;
import com.google.cloud.spanner.r2dbc.StatementExecutionContext;
import com.google.cloud.spanner.r2dbc.client.Client;
import com.google.protobuf.ByteString;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.ValidationDepth;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class SpannerConnection
implements Connection,
StatementExecutionContext {
    private static final TransactionOptions READ_WRITE_TRANSACTION = TransactionOptions.newBuilder().setReadWrite(TransactionOptions.ReadWrite.getDefaultInstance()).build();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Client client;
    private Session session;
    private Transaction transaction;
    private TransactionOptions transactionOptions;
    private AtomicLong seqNum = new AtomicLong(0L);
    private final SpannerConnectionConfiguration config;
    private boolean autoCommit = true;

    public SpannerConnection(Client client, Session session, SpannerConnectionConfiguration config) {
        this.client = client;
        this.session = session;
        this.config = config;
    }

    public Mono<Void> beginTransaction() {
        return this.beginTransaction(READ_WRITE_TRANSACTION);
    }

    public Mono<Void> beginTransaction(TransactionOptions transactionOptions) {
        return this.client.beginTransaction(this.getSessionName(), transactionOptions).doOnNext(transaction -> {
            this.setTransaction((Transaction)transaction, transactionOptions);
            this.autoCommit = false;
        }).then();
    }

    public Mono<Void> commitTransaction() {
        return this.commitTransaction(true);
    }

    private Mono<Void> commitTransaction(boolean logMessage) {
        return Mono.defer(() -> {
            if (this.getTransactionId() != null && this.isTransactionReadWrite()) {
                return this.client.commitTransaction(this.getSessionName(), this.transaction).doOnNext(response -> this.setTransaction(null, null)).then();
            }
            if (logMessage) {
                if (this.getTransactionId() == null) {
                    this.logger.debug("commitTransaction() is a no-op; called with no transaction active.");
                } else if (!this.isTransactionReadWrite()) {
                    this.logger.debug("commitTransaction() is a no-op; called outside of a read-write transaction.");
                }
            }
            return Mono.empty();
        });
    }

    public Mono<Void> rollbackTransaction() {
        return Mono.defer(() -> {
            if (this.getTransactionId() == null) {
                this.logger.warn("rollbackTransaction() is a no-op; called with no transaction active.");
                return Mono.empty();
            }
            return this.client.rollbackTransaction(this.getSessionName(), this.transaction).doOnSuccess(response -> this.setTransaction(null, null));
        });
    }

    public Mono<Void> close() {
        return this.commitTransaction(false).then(this.client.deleteSession(this.getSessionName()).doOnSuccess(none -> {
            this.session = null;
        }));
    }

    public Batch createBatch() {
        return new SpannerBatch(this.client, this);
    }

    public Publisher<Void> createSavepoint(String s) {
        throw new UnsupportedOperationException("Savepoints are not supported.");
    }

    public SpannerStatement createStatement(String sql) {
        return new SpannerStatement(this.client, this, sql, this.config);
    }

    public Publisher<Void> releaseSavepoint(String s) {
        throw new UnsupportedOperationException("Savepoints are not supported.");
    }

    public Publisher<Void> rollbackTransactionToSavepoint(String s) {
        return null;
    }

    public Publisher<Void> setTransactionIsolationLevel(IsolationLevel isolationLevel) {
        return Mono.error((Throwable)new UnsupportedOperationException("Changing isolation level is not supported."));
    }

    public IsolationLevel getTransactionIsolationLevel() {
        return IsolationLevel.SERIALIZABLE;
    }

    @Override
    public ByteString getTransactionId() {
        return this.transaction == null ? null : this.transaction.getId();
    }

    @Override
    public String getSessionName() {
        return this.session == null ? null : this.session.getName();
    }

    @Override
    public long nextSeqNum() {
        return this.seqNum.getAndIncrement();
    }

    @Override
    public boolean isTransactionReadWrite() {
        return this.transactionOptions == null ? false : this.transactionOptions.hasReadWrite();
    }

    @Override
    public boolean isTransactionPartitionedDml() {
        return this.transactionOptions == null ? false : this.transactionOptions.hasPartitionedDml();
    }

    private void setTransaction(@Nullable Transaction transaction, @Nullable TransactionOptions transactionOptions) {
        this.transaction = transaction;
        this.transactionOptions = transactionOptions;
    }

    public Publisher<Boolean> validate(ValidationDepth validationDepth) {
        if (validationDepth == ValidationDepth.LOCAL) {
            return Mono.fromSupplier(() -> this.getSessionName() != null);
        }
        return this.client.healthcheck(this);
    }

    public Publisher<Void> setAutoCommit(boolean newAutoCommit) {
        return Mono.defer(() -> {
            boolean commitNeeded = newAutoCommit && !this.autoCommit && this.transaction != null;
            return (commitNeeded ? this.commitTransaction(false) : Mono.empty()).doOnSuccess(none -> {
                this.autoCommit = newAutoCommit;
            });
        });
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public SpannerConnectionMetadata getMetadata() {
        return SpannerConnectionMetadata.INSTANCE;
    }
}

