/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc;

import com.google.cloud.spanner.r2dbc.SpannerResult;
import com.google.cloud.spanner.r2dbc.SpannerRow;
import com.google.cloud.spanner.r2dbc.StatementExecutionContext;
import com.google.cloud.spanner.r2dbc.client.Client;
import com.google.cloud.spanner.r2dbc.statement.StatementParser;
import com.google.cloud.spanner.r2dbc.statement.StatementType;
import com.google.cloud.spanner.r2dbc.util.Assert;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Result;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SpannerBatch
implements Batch {
    private final StatementExecutionContext ctx;
    private final Client client;
    private List<ExecuteBatchDmlRequest.Statement> statements = new ArrayList<ExecuteBatchDmlRequest.Statement>();

    SpannerBatch(Client client, StatementExecutionContext ctx) {
        this.client = client;
        this.ctx = ctx;
    }

    public Batch add(String sql) {
        Assert.requireNonNull(sql, "SQL must not be null");
        if (StatementParser.getStatementType(sql) != StatementType.DML) {
            throw new IllegalArgumentException("Only DML statements are supported in batches");
        }
        this.statements.add(ExecuteBatchDmlRequest.Statement.newBuilder().setSql(sql).build());
        return this;
    }

    public Publisher<? extends Result> execute() {
        return this.client.executeBatchDml(this.ctx, this.statements).map(resultSet -> {
            int count = Math.toIntExact(resultSet.getStats().getRowCountExact());
            return new SpannerResult((Flux<SpannerRow>)Flux.empty(), (Mono<Integer>)Mono.just((Object)count));
        });
    }
}

