/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam;

import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.cloud.bigtable.beam.CloudBigtableConfiguration;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;

@InternalExtensionOnly
public class CloudBigtableTableConfiguration
extends CloudBigtableConfiguration {
    private static final long serialVersionUID = 2435897354284600685L;
    protected ValueProvider<String> tableId;

    CloudBigtableTableConfiguration() {
    }

    protected CloudBigtableTableConfiguration(ValueProvider<String> projectId, ValueProvider<String> instanceId, ValueProvider<String> tableId, Map<String, ValueProvider<String>> additionalConfiguration) {
        super(projectId, instanceId, additionalConfiguration);
        this.tableId = tableId;
    }

    public String getTableId() {
        return (String)this.tableId.get();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        this.copyConfig(builder);
        return builder;
    }

    public void copyConfig(Builder builder) {
        super.copyConfig(builder);
        builder.tableId = this.tableId;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.getTableId(), ((CloudBigtableTableConfiguration)obj).getTableId());
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"tableId", (String)CloudBigtableTableConfiguration.getDisplayValue(this.tableId)).withLabel("Table ID"));
    }

    @Override
    public void validate() {
        super.validate();
        if (this.areParametersAccessible()) {
            CloudBigtableTableConfiguration.checkNotNullOrEmpty(this.getTableId(), "tableid");
        }
    }

    public static class Builder
    extends CloudBigtableConfiguration.Builder {
        protected ValueProvider<String> tableId;

        public Builder withTableId(String tableId) {
            return this.withTableId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)tableId));
        }

        public Builder withTableId(ValueProvider<String> tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public Builder withProjectId(String projectId) {
            super.withProjectId(projectId);
            return this;
        }

        @Override
        public Builder withProjectId(ValueProvider<String> projectId) {
            super.withProjectId(projectId);
            return this;
        }

        @Override
        public Builder withInstanceId(String instanceId) {
            super.withInstanceId(instanceId);
            return this;
        }

        @Override
        public Builder withInstanceId(ValueProvider<String> instanceId) {
            super.withInstanceId(instanceId);
            return this;
        }

        @Override
        public Builder withAppProfileId(String appProfileId) {
            super.withAppProfileId(appProfileId);
            return this;
        }

        @Override
        public Builder withAppProfileId(ValueProvider<String> appProfileId) {
            super.withAppProfileId(appProfileId);
            return this;
        }

        @Override
        public Builder withConfiguration(String key, String value) {
            super.withConfiguration(key, value);
            return this;
        }

        @Override
        public Builder withConfiguration(String key, ValueProvider<String> value) {
            super.withConfiguration(key, value);
            return this;
        }

        @Override
        public CloudBigtableTableConfiguration build() {
            return new CloudBigtableTableConfiguration((ValueProvider<String>)this.projectId, (ValueProvider<String>)this.instanceId, this.tableId, this.additionalConfiguration);
        }
    }
}

