/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam;

import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.BigtableVersionInfo;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.bigtable.hbase.BigtableOptionsFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.hadoop.conf.Configuration;

public class CloudBigtableConfiguration
implements Serializable {
    private static final long serialVersionUID = 1655181275627002133L;
    public static final String VALUE_UNAVAILABLE = "Unavailable during pipeline construction";
    private Map<String, ValueProvider<String>> configuration;

    CloudBigtableConfiguration() {
    }

    protected CloudBigtableConfiguration(ValueProvider<String> projectId, ValueProvider<String> instanceId, Map<String, ValueProvider<String>> additionalConfiguration) {
        this.configuration = new HashMap<String, ValueProvider<String>>(additionalConfiguration);
        this.setValue("google.bigtable.project.id", projectId, "Project ID");
        this.setValue("google.bigtable.instance.id", instanceId, "Instance ID");
    }

    private void setValue(String key, ValueProvider<String> value, String type) {
        Preconditions.checkArgument((!this.configuration.containsKey(key) ? 1 : 0) != 0, (String)"%s was set twice", (Object)key);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"%s must be set.", (Object)type);
        this.configuration.put(key, value);
    }

    public String getProjectId() {
        return (String)this.configuration.get("google.bigtable.project.id").get();
    }

    public String getInstanceId() {
        return (String)this.configuration.get("google.bigtable.instance.id").get();
    }

    public String getAppProfileId() {
        return (String)this.configuration.get("google.bigtable.app_profile.id").get();
    }

    public BigtableOptions toBigtableOptions() throws IOException {
        return BigtableOptionsFactory.fromConfiguration((Configuration)this.toHBaseConfig());
    }

    public Configuration toHBaseConfig() {
        Configuration config = new Configuration(false);
        config.set("google.bigtable.use.batch", "true");
        config.set("google.bigtable.buffered.mutator.async.worker.count", "0");
        for (Map.Entry<String, ValueProvider<String>> entry : this.configuration.entrySet()) {
            if (entry.getValue().get() == null) continue;
            config.set(entry.getKey(), (String)entry.getValue().get());
        }
        this.setUserAgent(config);
        return config;
    }

    private void setUserAgent(Configuration config) {
        String beamUserAgent = "HBaseBeam";
        if (this.configuration.containsKey("google.bigtable.custom.user.agent")) {
            beamUserAgent = beamUserAgent + "," + this.configuration.get("google.bigtable.custom.user.agent");
        }
        config.set("google.bigtable.custom.user.agent", beamUserAgent);
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        this.copyConfig(builder);
        return builder;
    }

    protected ImmutableMap<String, ValueProvider<String>> getConfiguration() {
        return ImmutableMap.copyOf(this.configuration);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CloudBigtableConfiguration other = (CloudBigtableConfiguration)obj;
        if (!Objects.equals(this.configuration.keySet(), other.configuration.keySet())) {
            return false;
        }
        for (String key : this.configuration.keySet()) {
            if (Objects.equals(this.configuration.get(key).get(), other.configuration.get(key).get())) continue;
            return false;
        }
        return true;
    }

    public void copyConfig(Builder builder) {
        builder.copyFrom(this.configuration);
    }

    protected boolean areParametersAccessible() {
        return this.configuration.get("google.bigtable.project.id").isAccessible();
    }

    protected static <T> String getDisplayValue(ValueProvider<T> parameter) {
        if (parameter.isAccessible()) {
            return String.valueOf(parameter.get());
        }
        return VALUE_UNAVAILABLE;
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        builder.add(DisplayData.item((String)"projectId", (String)CloudBigtableConfiguration.getDisplayValue(this.configuration.get("google.bigtable.project.id"))).withLabel("Project ID"));
        builder.add(DisplayData.item((String)"instanceId", (String)CloudBigtableConfiguration.getDisplayValue(this.configuration.get("google.bigtable.instance.id"))).withLabel("Instance ID"));
        builder.add(DisplayData.item((String)"bigtableClientVersion", (String)BigtableVersionInfo.CLIENT_VERSION).withLabel("Bigtable Client Version"));
        HashMap<String, ValueProvider<String>> hashMap = new HashMap<String, ValueProvider<String>>(this.configuration);
        hashMap.remove("google.bigtable.project.id");
        hashMap.remove("google.bigtable.instance.id");
        for (Map.Entry<String, ValueProvider<String>> entry : this.configuration.entrySet()) {
            builder.add(DisplayData.item((String)entry.getKey(), (String)CloudBigtableConfiguration.getDisplayValue(entry.getValue())).withLabel(entry.getKey()));
        }
    }

    protected static void checkNotNullOrEmpty(String value, String name) {
        Preconditions.checkArgument((value != null && !value.isEmpty() ? 1 : 0) != 0, (Object)("A " + name + " must be set to configure Bigtable properly."));
    }

    public void validate() {
        if (this.areParametersAccessible()) {
            CloudBigtableConfiguration.checkNotNullOrEmpty(this.getProjectId(), "projectId");
            CloudBigtableConfiguration.checkNotNullOrEmpty(this.getInstanceId(), "instanceId");
        }
    }

    public static class Builder {
        protected ValueProvider<String> projectId;
        protected ValueProvider<String> instanceId;
        protected Map<String, ValueProvider<String>> additionalConfiguration = new HashMap<String, ValueProvider<String>>();

        protected void copyFrom(Map<String, ValueProvider<String>> configuration) {
            this.additionalConfiguration.putAll(configuration);
            this.projectId = this.additionalConfiguration.remove("google.bigtable.project.id");
            this.instanceId = this.additionalConfiguration.remove("google.bigtable.instance.id");
        }

        public Builder withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        Builder withProjectId(ValueProvider<String> projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        Builder withInstanceId(ValueProvider<String> instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder withAppProfileId(String appProfileId) {
            return this.withAppProfileId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)appProfileId));
        }

        Builder withAppProfileId(ValueProvider<String> appProfileId) {
            return this.withConfiguration("google.bigtable.app_profile.id", appProfileId);
        }

        public Builder withConfiguration(String key, String value) {
            return this.withConfiguration(key, (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)value));
        }

        Builder withConfiguration(String key, ValueProvider<String> value) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Value cannot be null");
            this.additionalConfiguration.put(key, value);
            return this;
        }

        public CloudBigtableConfiguration build() {
            return new CloudBigtableConfiguration(this.projectId, this.instanceId, this.additionalConfiguration);
        }
    }
}

