/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.UUID;

public class InvocationIdContext {
    private static final InheritableThreadLocal<String> INVOCATION_ID = new InheritableThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return "";
        }
    };

    public static String getInvocationId() {
        return (String)INVOCATION_ID.get();
    }

    public static void setInvocationId() {
        String uuid = UUID.randomUUID().toString().substring(0, 8);
        INVOCATION_ID.set("gccl-invocation-id/" + uuid);
    }

    @VisibleForTesting
    static void clear() {
        INVOCATION_ID.remove();
    }
}

