/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public abstract class BaseAbstractGoogleAsyncWriteChannel<T>
implements WritableByteChannel {
    protected static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    protected final ExecutorService threadPool;
    protected final AsyncWriteChannelOptions channelOptions;
    protected Future<T> uploadOperation;
    private boolean initialized = false;
    private WritableByteChannel pipeSink;
    private ByteBuffer uploadCache = null;

    public BaseAbstractGoogleAsyncWriteChannel(ExecutorService threadPool, AsyncWriteChannelOptions channelOptions) {
        this.threadPool = threadPool;
        this.channelOptions = channelOptions;
        if (channelOptions.getUploadCacheSize() > 0) {
            this.uploadCache = ByteBuffer.allocate(channelOptions.getUploadCacheSize());
        }
    }

    public void handleResponse(T response) throws IOException {
    }

    public T createResponseFromException(IOException e) {
        return null;
    }

    public boolean isDirectUploadEnabled() {
        return this.channelOptions.isDirectUploadEnabled();
    }

    @Override
    public synchronized int write(ByteBuffer buffer) throws IOException {
        Preconditions.checkState((boolean)this.initialized, (Object)"initialize() must be invoked before use.");
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.uploadOperation.isDone()) {
            this.waitForCompletionAndThrowIfUploadFailed();
        }
        if (this.uploadCache != null && this.uploadCache.remaining() >= buffer.remaining()) {
            int position = buffer.position();
            this.uploadCache.put(buffer);
            buffer.position(position);
        } else {
            this.uploadCache = null;
        }
        try {
            return this.pipeSink.write(buffer);
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to write %d bytes in '%s'", buffer.remaining(), this.getResourceString()), e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.pipeSink != null && this.pipeSink.isOpen();
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkState((boolean)this.initialized, (Object)"initialize() must be invoked before use.");
        if (!this.isOpen()) {
            return;
        }
        try {
            this.pipeSink.close();
            this.handleResponse(this.waitForCompletionAndThrowIfUploadFailed());
        }
        catch (IOException e) {
            if (this.uploadCache == null) {
                throw e;
            }
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)e)).log("Reuploading using cached data");
            this.reuploadFromCache();
        }
        finally {
            this.closeInternal();
        }
    }

    private void reuploadFromCache() throws IOException {
        this.closeInternal();
        this.initialized = false;
        this.initialize();
        ByteBuffer reuploadData = this.uploadCache;
        this.uploadCache = null;
        reuploadData.flip();
        try {
            this.write(reuploadData);
        }
        finally {
            this.close();
        }
    }

    private void closeInternal() {
        this.pipeSink = null;
        if (this.uploadOperation != null && !this.uploadOperation.isDone()) {
            this.uploadOperation.cancel(true);
        }
        this.uploadOperation = null;
    }

    public void initialize() throws IOException {
        InputStream pipeSource = this.initializeUploadPipe();
        this.startUpload(pipeSource);
        this.initialized = true;
    }

    private InputStream initializeUploadPipe() throws IOException {
        switch (this.channelOptions.getPipeType()) {
            case NIO_CHANNEL_PIPE: {
                Pipe pipe = Pipe.open();
                this.pipeSink = pipe.sink();
                InputStream pipeSource = Channels.newInputStream(pipe.source());
                return this.channelOptions.getPipeBufferSize() > 0 ? new BufferedInputStream(pipeSource, this.channelOptions.getPipeBufferSize()) : pipeSource;
            }
            case IO_STREAM_PIPE: {
                PipedInputStream internalPipeSource = new PipedInputStream(this.channelOptions.getPipeBufferSize());
                PipedOutputStream internalPipeSink = new PipedOutputStream(internalPipeSource);
                this.pipeSink = Channels.newChannel(internalPipeSink);
                return internalPipeSource;
            }
        }
        throw new IllegalStateException("Unknown PipeType: " + (Object)((Object)this.channelOptions.getPipeType()));
    }

    public abstract void startUpload(InputStream var1) throws IOException;

    protected abstract String getResourceString();

    private T waitForCompletionAndThrowIfUploadFailed() throws IOException {
        try {
            return this.uploadOperation.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.uploadOperation.cancel(true);
            ClosedByInterruptException exception = new ClosedByInterruptException();
            exception.addSuppressed(e);
            throw exception;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new IOException(String.format("Upload failed for '%s'. details=%s", this.getResourceString(), e.getMessage()), e.getCause());
        }
    }
}

