package com.google.cloud.hadoop.util;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CredentialOptions extends CredentialOptions {

  private final boolean serviceAccountEnabled;

  private final RedactedString serviceAccountPrivateKeyId;

  private final RedactedString serviceAccountPrivateKey;

  private final String serviceAccountEmail;

  private final String serviceAccountKeyFile;

  private final String serviceAccountJsonKeyFile;

  private final boolean nullCredentialEnabled;

  private final HttpTransportFactory.HttpTransportType transportType;

  private final String tokenServerUrl;

  private final String proxyAddress;

  private final RedactedString proxyUsername;

  private final RedactedString proxyPassword;

  private final String authClientId;

  private final RedactedString authClientSecret;

  private final RedactedString authRefreshToken;

  private AutoValue_CredentialOptions(
      boolean serviceAccountEnabled,
      @Nullable RedactedString serviceAccountPrivateKeyId,
      @Nullable RedactedString serviceAccountPrivateKey,
      @Nullable String serviceAccountEmail,
      @Nullable String serviceAccountKeyFile,
      @Nullable String serviceAccountJsonKeyFile,
      boolean nullCredentialEnabled,
      HttpTransportFactory.HttpTransportType transportType,
      String tokenServerUrl,
      @Nullable String proxyAddress,
      @Nullable RedactedString proxyUsername,
      @Nullable RedactedString proxyPassword,
      @Nullable String authClientId,
      @Nullable RedactedString authClientSecret,
      @Nullable RedactedString authRefreshToken) {
    this.serviceAccountEnabled = serviceAccountEnabled;
    this.serviceAccountPrivateKeyId = serviceAccountPrivateKeyId;
    this.serviceAccountPrivateKey = serviceAccountPrivateKey;
    this.serviceAccountEmail = serviceAccountEmail;
    this.serviceAccountKeyFile = serviceAccountKeyFile;
    this.serviceAccountJsonKeyFile = serviceAccountJsonKeyFile;
    this.nullCredentialEnabled = nullCredentialEnabled;
    this.transportType = transportType;
    this.tokenServerUrl = tokenServerUrl;
    this.proxyAddress = proxyAddress;
    this.proxyUsername = proxyUsername;
    this.proxyPassword = proxyPassword;
    this.authClientId = authClientId;
    this.authClientSecret = authClientSecret;
    this.authRefreshToken = authRefreshToken;
  }

  @Override
  public boolean isServiceAccountEnabled() {
    return serviceAccountEnabled;
  }

  @Nullable
  @Override
  public RedactedString getServiceAccountPrivateKeyId() {
    return serviceAccountPrivateKeyId;
  }

  @Nullable
  @Override
  public RedactedString getServiceAccountPrivateKey() {
    return serviceAccountPrivateKey;
  }

  @Nullable
  @Override
  public String getServiceAccountEmail() {
    return serviceAccountEmail;
  }

  @Nullable
  @Override
  public String getServiceAccountKeyFile() {
    return serviceAccountKeyFile;
  }

  @Nullable
  @Override
  public String getServiceAccountJsonKeyFile() {
    return serviceAccountJsonKeyFile;
  }

  @Override
  public boolean isNullCredentialEnabled() {
    return nullCredentialEnabled;
  }

  @Override
  public HttpTransportFactory.HttpTransportType getTransportType() {
    return transportType;
  }

  @Override
  public String getTokenServerUrl() {
    return tokenServerUrl;
  }

  @Nullable
  @Override
  public String getProxyAddress() {
    return proxyAddress;
  }

  @Nullable
  @Override
  public RedactedString getProxyUsername() {
    return proxyUsername;
  }

  @Nullable
  @Override
  public RedactedString getProxyPassword() {
    return proxyPassword;
  }

  @Nullable
  @Override
  public String getAuthClientId() {
    return authClientId;
  }

  @Nullable
  @Override
  public RedactedString getAuthClientSecret() {
    return authClientSecret;
  }

  @Nullable
  @Override
  public RedactedString getAuthRefreshToken() {
    return authRefreshToken;
  }

  @Override
  public String toString() {
    return "CredentialOptions{"
        + "serviceAccountEnabled=" + serviceAccountEnabled + ", "
        + "serviceAccountPrivateKeyId=" + serviceAccountPrivateKeyId + ", "
        + "serviceAccountPrivateKey=" + serviceAccountPrivateKey + ", "
        + "serviceAccountEmail=" + serviceAccountEmail + ", "
        + "serviceAccountKeyFile=" + serviceAccountKeyFile + ", "
        + "serviceAccountJsonKeyFile=" + serviceAccountJsonKeyFile + ", "
        + "nullCredentialEnabled=" + nullCredentialEnabled + ", "
        + "transportType=" + transportType + ", "
        + "tokenServerUrl=" + tokenServerUrl + ", "
        + "proxyAddress=" + proxyAddress + ", "
        + "proxyUsername=" + proxyUsername + ", "
        + "proxyPassword=" + proxyPassword + ", "
        + "authClientId=" + authClientId + ", "
        + "authClientSecret=" + authClientSecret + ", "
        + "authRefreshToken=" + authRefreshToken
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CredentialOptions) {
      CredentialOptions that = (CredentialOptions) o;
      return this.serviceAccountEnabled == that.isServiceAccountEnabled()
          && (this.serviceAccountPrivateKeyId == null ? that.getServiceAccountPrivateKeyId() == null : this.serviceAccountPrivateKeyId.equals(that.getServiceAccountPrivateKeyId()))
          && (this.serviceAccountPrivateKey == null ? that.getServiceAccountPrivateKey() == null : this.serviceAccountPrivateKey.equals(that.getServiceAccountPrivateKey()))
          && (this.serviceAccountEmail == null ? that.getServiceAccountEmail() == null : this.serviceAccountEmail.equals(that.getServiceAccountEmail()))
          && (this.serviceAccountKeyFile == null ? that.getServiceAccountKeyFile() == null : this.serviceAccountKeyFile.equals(that.getServiceAccountKeyFile()))
          && (this.serviceAccountJsonKeyFile == null ? that.getServiceAccountJsonKeyFile() == null : this.serviceAccountJsonKeyFile.equals(that.getServiceAccountJsonKeyFile()))
          && this.nullCredentialEnabled == that.isNullCredentialEnabled()
          && this.transportType.equals(that.getTransportType())
          && this.tokenServerUrl.equals(that.getTokenServerUrl())
          && (this.proxyAddress == null ? that.getProxyAddress() == null : this.proxyAddress.equals(that.getProxyAddress()))
          && (this.proxyUsername == null ? that.getProxyUsername() == null : this.proxyUsername.equals(that.getProxyUsername()))
          && (this.proxyPassword == null ? that.getProxyPassword() == null : this.proxyPassword.equals(that.getProxyPassword()))
          && (this.authClientId == null ? that.getAuthClientId() == null : this.authClientId.equals(that.getAuthClientId()))
          && (this.authClientSecret == null ? that.getAuthClientSecret() == null : this.authClientSecret.equals(that.getAuthClientSecret()))
          && (this.authRefreshToken == null ? that.getAuthRefreshToken() == null : this.authRefreshToken.equals(that.getAuthRefreshToken()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= serviceAccountEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (serviceAccountPrivateKeyId == null) ? 0 : serviceAccountPrivateKeyId.hashCode();
    h$ *= 1000003;
    h$ ^= (serviceAccountPrivateKey == null) ? 0 : serviceAccountPrivateKey.hashCode();
    h$ *= 1000003;
    h$ ^= (serviceAccountEmail == null) ? 0 : serviceAccountEmail.hashCode();
    h$ *= 1000003;
    h$ ^= (serviceAccountKeyFile == null) ? 0 : serviceAccountKeyFile.hashCode();
    h$ *= 1000003;
    h$ ^= (serviceAccountJsonKeyFile == null) ? 0 : serviceAccountJsonKeyFile.hashCode();
    h$ *= 1000003;
    h$ ^= nullCredentialEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= transportType.hashCode();
    h$ *= 1000003;
    h$ ^= tokenServerUrl.hashCode();
    h$ *= 1000003;
    h$ ^= (proxyAddress == null) ? 0 : proxyAddress.hashCode();
    h$ *= 1000003;
    h$ ^= (proxyUsername == null) ? 0 : proxyUsername.hashCode();
    h$ *= 1000003;
    h$ ^= (proxyPassword == null) ? 0 : proxyPassword.hashCode();
    h$ *= 1000003;
    h$ ^= (authClientId == null) ? 0 : authClientId.hashCode();
    h$ *= 1000003;
    h$ ^= (authClientSecret == null) ? 0 : authClientSecret.hashCode();
    h$ *= 1000003;
    h$ ^= (authRefreshToken == null) ? 0 : authRefreshToken.hashCode();
    return h$;
  }

  @Override
  public CredentialOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends CredentialOptions.Builder {
    private boolean serviceAccountEnabled;
    private RedactedString serviceAccountPrivateKeyId;
    private RedactedString serviceAccountPrivateKey;
    private String serviceAccountEmail;
    private String serviceAccountKeyFile;
    private String serviceAccountJsonKeyFile;
    private boolean nullCredentialEnabled;
    private HttpTransportFactory.HttpTransportType transportType;
    private String tokenServerUrl;
    private String proxyAddress;
    private RedactedString proxyUsername;
    private RedactedString proxyPassword;
    private String authClientId;
    private RedactedString authClientSecret;
    private RedactedString authRefreshToken;
    private byte set$0;
    Builder() {
    }
    private Builder(CredentialOptions source) {
      this.serviceAccountEnabled = source.isServiceAccountEnabled();
      this.serviceAccountPrivateKeyId = source.getServiceAccountPrivateKeyId();
      this.serviceAccountPrivateKey = source.getServiceAccountPrivateKey();
      this.serviceAccountEmail = source.getServiceAccountEmail();
      this.serviceAccountKeyFile = source.getServiceAccountKeyFile();
      this.serviceAccountJsonKeyFile = source.getServiceAccountJsonKeyFile();
      this.nullCredentialEnabled = source.isNullCredentialEnabled();
      this.transportType = source.getTransportType();
      this.tokenServerUrl = source.getTokenServerUrl();
      this.proxyAddress = source.getProxyAddress();
      this.proxyUsername = source.getProxyUsername();
      this.proxyPassword = source.getProxyPassword();
      this.authClientId = source.getAuthClientId();
      this.authClientSecret = source.getAuthClientSecret();
      this.authRefreshToken = source.getAuthRefreshToken();
      set$0 = (byte) 3;
    }
    @Override
    public CredentialOptions.Builder setServiceAccountEnabled(boolean serviceAccountEnabled) {
      this.serviceAccountEnabled = serviceAccountEnabled;
      set$0 |= 1;
      return this;
    }
    @Override
    public CredentialOptions.Builder setServiceAccountPrivateKeyId(RedactedString serviceAccountPrivateKeyId) {
      this.serviceAccountPrivateKeyId = serviceAccountPrivateKeyId;
      return this;
    }
    @Override
    public CredentialOptions.Builder setServiceAccountPrivateKey(RedactedString serviceAccountPrivateKey) {
      this.serviceAccountPrivateKey = serviceAccountPrivateKey;
      return this;
    }
    @Override
    public CredentialOptions.Builder setServiceAccountEmail(String serviceAccountEmail) {
      this.serviceAccountEmail = serviceAccountEmail;
      return this;
    }
    @Override
    public CredentialOptions.Builder setServiceAccountKeyFile(String serviceAccountKeyFile) {
      this.serviceAccountKeyFile = serviceAccountKeyFile;
      return this;
    }
    @Override
    public CredentialOptions.Builder setServiceAccountJsonKeyFile(String serviceAccountJsonKeyFile) {
      this.serviceAccountJsonKeyFile = serviceAccountJsonKeyFile;
      return this;
    }
    @Override
    public CredentialOptions.Builder setNullCredentialEnabled(boolean nullCredentialEnabled) {
      this.nullCredentialEnabled = nullCredentialEnabled;
      set$0 |= 2;
      return this;
    }
    @Override
    public CredentialOptions.Builder setTransportType(HttpTransportFactory.HttpTransportType transportType) {
      if (transportType == null) {
        throw new NullPointerException("Null transportType");
      }
      this.transportType = transportType;
      return this;
    }
    @Override
    public CredentialOptions.Builder setTokenServerUrl(String tokenServerUrl) {
      if (tokenServerUrl == null) {
        throw new NullPointerException("Null tokenServerUrl");
      }
      this.tokenServerUrl = tokenServerUrl;
      return this;
    }
    @Override
    public CredentialOptions.Builder setProxyAddress(String proxyAddress) {
      this.proxyAddress = proxyAddress;
      return this;
    }
    @Override
    public CredentialOptions.Builder setProxyUsername(RedactedString proxyUsername) {
      this.proxyUsername = proxyUsername;
      return this;
    }
    @Override
    public CredentialOptions.Builder setProxyPassword(RedactedString proxyPassword) {
      this.proxyPassword = proxyPassword;
      return this;
    }
    @Override
    public CredentialOptions.Builder setAuthClientId(String authClientId) {
      this.authClientId = authClientId;
      return this;
    }
    @Override
    public CredentialOptions.Builder setAuthClientSecret(RedactedString authClientSecret) {
      this.authClientSecret = authClientSecret;
      return this;
    }
    @Override
    public CredentialOptions.Builder setAuthRefreshToken(RedactedString authRefreshToken) {
      this.authRefreshToken = authRefreshToken;
      return this;
    }
    @Override
    CredentialOptions autoBuild() {
      if (set$0 != 3
          || this.transportType == null
          || this.tokenServerUrl == null) {
        StringBuilder missing = new StringBuilder();
        if ((set$0 & 1) == 0) {
          missing.append(" serviceAccountEnabled");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" nullCredentialEnabled");
        }
        if (this.transportType == null) {
          missing.append(" transportType");
        }
        if (this.tokenServerUrl == null) {
          missing.append(" tokenServerUrl");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CredentialOptions(
          this.serviceAccountEnabled,
          this.serviceAccountPrivateKeyId,
          this.serviceAccountPrivateKey,
          this.serviceAccountEmail,
          this.serviceAccountKeyFile,
          this.serviceAccountJsonKeyFile,
          this.nullCredentialEnabled,
          this.transportType,
          this.tokenServerUrl,
          this.proxyAddress,
          this.proxyUsername,
          this.proxyPassword,
          this.authClientId,
          this.authClientSecret,
          this.authRefreshToken);
    }
  }

}
