package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.auth.Credentials;
import com.google.cloud.hadoop.util.AccessBoundary;
import com.google.cloud.storage.Storage;
import com.google.common.collect.ImmutableList;
import io.grpc.ClientInterceptor;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoBuilderProcessor")
class AutoBuilder_GoogleCloudStorageClientImpl_Builder extends GoogleCloudStorageClientImpl.Builder {

  private GoogleCloudStorageOptions options;

  private Storage clientLibraryStorage;

  private Credentials credentials;

  private HttpTransport httpTransport;

  private HttpRequestInitializer httpRequestInitializer;

  private ImmutableList<ClientInterceptor> gRPCInterceptors;

  private Function<List<AccessBoundary>, String> downscopedAccessTokenFn;

  private ExecutorService pCUExecutorService;

  AutoBuilder_GoogleCloudStorageClientImpl_Builder() {
  }

  @Override
  public GoogleCloudStorageClientImpl.Builder setOptions(GoogleCloudStorageOptions options) {
    if (options == null) {
      throw new NullPointerException("Null options");
    }
    this.options = options;
    return this;
  }

  @Override
  public GoogleCloudStorageClientImpl.Builder setClientLibraryStorage(@Nullable Storage clientLibraryStorage) {
    this.clientLibraryStorage = clientLibraryStorage;
    return this;
  }

  @Override
  public GoogleCloudStorageClientImpl.Builder setCredentials(@Nullable Credentials credentials) {
    this.credentials = credentials;
    return this;
  }

  @Override
  public GoogleCloudStorageClientImpl.Builder setHttpTransport(@Nullable HttpTransport httpTransport) {
    this.httpTransport = httpTransport;
    return this;
  }

  @Override
  public GoogleCloudStorageClientImpl.Builder setHttpRequestInitializer(@Nullable HttpRequestInitializer httpRequestInitializer) {
    this.httpRequestInitializer = httpRequestInitializer;
    return this;
  }

  @Override
  public GoogleCloudStorageClientImpl.Builder setGRPCInterceptors(@Nullable ImmutableList<ClientInterceptor> gRPCInterceptors) {
    this.gRPCInterceptors = gRPCInterceptors;
    return this;
  }

  @Override
  public GoogleCloudStorageClientImpl.Builder setDownscopedAccessTokenFn(@Nullable Function<List<AccessBoundary>, String> downscopedAccessTokenFn) {
    this.downscopedAccessTokenFn = downscopedAccessTokenFn;
    return this;
  }

  @Override
  public GoogleCloudStorageClientImpl.Builder setPCUExecutorService(@Nullable ExecutorService pCUExecutorService) {
    this.pCUExecutorService = pCUExecutorService;
    return this;
  }

  @Override
  public GoogleCloudStorageClientImpl build() throws IOException {
    if (this.options == null) {
      String missing = " options";
      throw new IllegalStateException("Missing required properties:" + missing);
    }
    return new GoogleCloudStorageClientImpl(
        this.options,
        this.clientLibraryStorage,
        this.credentials,
        this.httpTransport,
        this.httpRequestInitializer,
        this.gRPCInterceptors,
        this.downscopedAccessTokenFn,
        this.pCUExecutorService);
  }
}
