/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageTracingFields;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.GoogleLogger;
import com.google.gson.Gson;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.storage.v2.ReadObjectResponse;
import com.google.storage.v2.WriteObjectRequest;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.checkerframework.checker.nullness.qual.NonNull;

@VisibleForTesting
public class GoogleCloudStorageClientGrpcTracingInterceptor
implements ClientInterceptor {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String IDEMPOTENCY_TOKEN_HEADER = "x-goog-gcs-idempotency-token";
    private static final String DEFAULT_IDEMPOTENCY_TOKEN_VALUE = "IDEMPOTENCY_TOKEN_NOT_FOUND";
    private static final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss.SSS");
    private static final Metadata.Key<String> idempotencyKey = Metadata.Key.of((String)"x-goog-gcs-idempotency-token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    static @NonNull String fmtProto(@NonNull Object obj) {
        if (obj instanceof WriteObjectRequest) {
            return GoogleCloudStorageClientGrpcTracingInterceptor.fmtProto((WriteObjectRequest)obj);
        }
        if (obj instanceof ReadObjectResponse) {
            return GoogleCloudStorageClientGrpcTracingInterceptor.fmtProto((ReadObjectResponse)obj);
        }
        if (obj instanceof MessageOrBuilder) {
            return GoogleCloudStorageClientGrpcTracingInterceptor.fmtProto((MessageOrBuilder)obj);
        }
        return obj.toString();
    }

    static @NonNull String fmtProto(@NonNull MessageOrBuilder msg) {
        return msg.toString();
    }

    static @NonNull String fmtProto(@NonNull WriteObjectRequest msg) {
        if (msg.hasChecksummedData()) {
            ByteString content = msg.getChecksummedData().getContent();
            WriteObjectRequest.Builder b = msg.toBuilder();
            ByteString snip = GoogleCloudStorageClientGrpcTracingInterceptor.updatedContent(content.size());
            b.getChecksummedDataBuilder().setContent(snip);
            return b.build().toString();
        }
        return msg.toString();
    }

    static @NonNull String fmtProto(@NonNull ReadObjectResponse msg) {
        if (msg.hasChecksummedData()) {
            ByteString content = msg.getChecksummedData().getContent();
            ReadObjectResponse.Builder b = msg.toBuilder();
            ByteString snip = GoogleCloudStorageClientGrpcTracingInterceptor.updatedContent(content.size());
            b.getChecksummedDataBuilder().setContent(snip);
            return b.build().toString();
        }
        return msg.toString();
    }

    static ByteString updatedContent(int contentSize) {
        return ByteString.copyFromUtf8((String)String.format("<size (%d)>", contentSize));
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        String rpcMethodName = method.getBareMethodName();
        final TrackingStreamTracer streamTracer = new TrackingStreamTracer(rpcMethodName);
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void sendMessage(ReqT message) {
                try {
                    streamTracer.traceRequestMessage((MessageLite)message);
                }
                finally {
                    super.sendMessage(message);
                }
            }

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                streamTracer.streamStarted(headers);
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onMessage(RespT message) {
                        try {
                            streamTracer.traceResponseMessage((MessageLite)message);
                        }
                        finally {
                            super.onMessage(message);
                        }
                    }

                    public void onClose(Status status, Metadata trailers) {
                        try {
                            streamTracer.statusOnClose(status);
                        }
                        finally {
                            super.onClose(status, trailers);
                        }
                    }
                }, headers);
            }
        };
    }

    private class TrackingStreamTracer {
        private final Gson gson = new Gson();
        private final String rpcMethod;
        private Metadata headers;
        private long streamStartTimeMs;
        private int requestCounter = 0;
        private int responseCounter = 0;

        TrackingStreamTracer(String rpcMethod) {
            this.rpcMethod = rpcMethod;
        }

        public void traceRequestMessage(MessageLite message) {
            ((GoogleLogger.Api)logger.atInfo()).log("%s", (Object)this.toJson((ImmutableMap<String, Object>)this.getRequestTrackingInfo().put((Object)GoogleCloudStorageTracingFields.REQUEST_MESSAGE_AS_STRING.name, (Object)GoogleCloudStorageClientGrpcTracingInterceptor.fmtProto(message)).build()));
        }

        public void traceResponseMessage(MessageLite message) {
            ((GoogleLogger.Api)logger.atInfo()).log("%s", (Object)this.toJson((ImmutableMap<String, Object>)this.getResponseTrackingInfo().put((Object)GoogleCloudStorageTracingFields.RESPONSE_MESSAGE_AS_STRING.name, (Object)GoogleCloudStorageClientGrpcTracingInterceptor.fmtProto(message)).build()));
        }

        public void statusOnClose(Status status) {
            long streamEndTimeMs = System.currentTimeMillis();
            long duration = streamEndTimeMs - this.streamStartTimeMs;
            ((GoogleLogger.Api)logger.atInfo()).log("%s", (Object)this.toJson((ImmutableMap<String, Object>)this.getCommonTraceFields().put((Object)GoogleCloudStorageTracingFields.STATUS.name, (Object)status.getCode()).put((Object)GoogleCloudStorageTracingFields.STREAM_OPERATION.name, (Object)"onClose").put((Object)GoogleCloudStorageTracingFields.DURATION_MS.name, (Object)duration).build()));
        }

        public void streamStarted(Metadata headers) {
            this.headers = headers;
            this.streamStartTimeMs = System.currentTimeMillis();
        }

        private ImmutableMap.Builder<String, Object> getRequestTrackingInfo() {
            ++this.requestCounter;
            return this.getCommonTraceFields().put((Object)GoogleCloudStorageTracingFields.REQUEST_COUNTER.name, (Object)this.requestCounter).put((Object)GoogleCloudStorageTracingFields.STREAM_OPERATION.name, (Object)"request");
        }

        private ImmutableMap.Builder<String, Object> getResponseTrackingInfo() {
            ++this.responseCounter;
            return this.getCommonTraceFields().put((Object)GoogleCloudStorageTracingFields.RESPONSE_COUNTER.name, (Object)this.responseCounter).put((Object)GoogleCloudStorageTracingFields.STREAM_OPERATION.name, (Object)"response");
        }

        protected String toJson(ImmutableMap<String, Object> eventDetails) {
            return this.gson.toJson(eventDetails);
        }

        private String getInvocationId() {
            if (this.headers == null) {
                return GoogleCloudStorageClientGrpcTracingInterceptor.DEFAULT_IDEMPOTENCY_TOKEN_VALUE;
            }
            String token = (String)this.headers.get(idempotencyKey);
            if (token == null) {
                return GoogleCloudStorageClientGrpcTracingInterceptor.DEFAULT_IDEMPOTENCY_TOKEN_VALUE;
            }
            return token;
        }

        private ImmutableMap.Builder<String, Object> getStreamContext() {
            return new ImmutableMap.Builder().put((Object)GoogleCloudStorageTracingFields.RPC_METHOD.name, (Object)this.rpcMethod).put((Object)GoogleCloudStorageTracingFields.IDEMPOTENCY_TOKEN.name, (Object)this.getInvocationId());
        }

        private ImmutableMap.Builder<String, Object> getCommonTraceFields() {
            return this.getStreamContext().put((Object)GoogleCloudStorageTracingFields.CURRENT_TIME.name, (Object)dtf.format(LocalDateTime.now()));
        }
    }
}

