package com.google.cloud.hadoop.gcsio.cooplock;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CooperativeLockingOptions extends CooperativeLockingOptions {

  private final long lockExpirationTimeoutMilli;

  private final int maxConcurrentOperations;

  private AutoValue_CooperativeLockingOptions(
      long lockExpirationTimeoutMilli,
      int maxConcurrentOperations) {
    this.lockExpirationTimeoutMilli = lockExpirationTimeoutMilli;
    this.maxConcurrentOperations = maxConcurrentOperations;
  }

  @Override
  public long getLockExpirationTimeoutMilli() {
    return lockExpirationTimeoutMilli;
  }

  @Override
  public int getMaxConcurrentOperations() {
    return maxConcurrentOperations;
  }

  @Override
  public String toString() {
    return "CooperativeLockingOptions{"
        + "lockExpirationTimeoutMilli=" + lockExpirationTimeoutMilli + ", "
        + "maxConcurrentOperations=" + maxConcurrentOperations
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CooperativeLockingOptions) {
      CooperativeLockingOptions that = (CooperativeLockingOptions) o;
      return this.lockExpirationTimeoutMilli == that.getLockExpirationTimeoutMilli()
          && this.maxConcurrentOperations == that.getMaxConcurrentOperations();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (int) ((lockExpirationTimeoutMilli >>> 32) ^ lockExpirationTimeoutMilli);
    h$ *= 1000003;
    h$ ^= maxConcurrentOperations;
    return h$;
  }

  @Override
  public CooperativeLockingOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends CooperativeLockingOptions.Builder {
    private Long lockExpirationTimeoutMilli;
    private Integer maxConcurrentOperations;
    Builder() {
    }
    private Builder(CooperativeLockingOptions source) {
      this.lockExpirationTimeoutMilli = source.getLockExpirationTimeoutMilli();
      this.maxConcurrentOperations = source.getMaxConcurrentOperations();
    }
    @Override
    public CooperativeLockingOptions.Builder setLockExpirationTimeoutMilli(long lockExpirationTimeoutMilli) {
      this.lockExpirationTimeoutMilli = lockExpirationTimeoutMilli;
      return this;
    }
    @Override
    public CooperativeLockingOptions.Builder setMaxConcurrentOperations(int maxConcurrentOperations) {
      this.maxConcurrentOperations = maxConcurrentOperations;
      return this;
    }
    @Override
    CooperativeLockingOptions autoBuild() {
      String missing = "";
      if (this.lockExpirationTimeoutMilli == null) {
        missing += " lockExpirationTimeoutMilli";
      }
      if (this.maxConcurrentOperations == null) {
        missing += " maxConcurrentOperations";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CooperativeLockingOptions(
          this.lockExpirationTimeoutMilli,
          this.maxConcurrentOperations);
    }
  }

}
