package com.google.cloud.hadoop.gcsio;

import java.util.regex.Pattern;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GoogleCloudStorageFileSystemOptions extends GoogleCloudStorageFileSystemOptions {

  private final boolean performanceCacheEnabled;

  private final PerformanceCachingGoogleCloudStorageOptions performanceCacheOptions;

  private final GoogleCloudStorageOptions cloudStorageOptions;

  private final boolean bucketDeleteEnabled;

  private final Pattern markerFilePattern;

  private final boolean statusParallelEnabled;

  private final boolean cooperativeLockingEnabled;

  private AutoValue_GoogleCloudStorageFileSystemOptions(
      boolean performanceCacheEnabled,
      PerformanceCachingGoogleCloudStorageOptions performanceCacheOptions,
      GoogleCloudStorageOptions cloudStorageOptions,
      boolean bucketDeleteEnabled,
      @Nullable Pattern markerFilePattern,
      boolean statusParallelEnabled,
      boolean cooperativeLockingEnabled) {
    this.performanceCacheEnabled = performanceCacheEnabled;
    this.performanceCacheOptions = performanceCacheOptions;
    this.cloudStorageOptions = cloudStorageOptions;
    this.bucketDeleteEnabled = bucketDeleteEnabled;
    this.markerFilePattern = markerFilePattern;
    this.statusParallelEnabled = statusParallelEnabled;
    this.cooperativeLockingEnabled = cooperativeLockingEnabled;
  }

  @Override
  public boolean isPerformanceCacheEnabled() {
    return performanceCacheEnabled;
  }

  @Override
  public PerformanceCachingGoogleCloudStorageOptions getPerformanceCacheOptions() {
    return performanceCacheOptions;
  }

  @Override
  public GoogleCloudStorageOptions getCloudStorageOptions() {
    return cloudStorageOptions;
  }

  @Override
  public boolean isBucketDeleteEnabled() {
    return bucketDeleteEnabled;
  }

  @Nullable
  @Override
  public Pattern getMarkerFilePattern() {
    return markerFilePattern;
  }

  @Override
  public boolean isStatusParallelEnabled() {
    return statusParallelEnabled;
  }

  @Override
  public boolean isCooperativeLockingEnabled() {
    return cooperativeLockingEnabled;
  }

  @Override
  public String toString() {
    return "GoogleCloudStorageFileSystemOptions{"
        + "performanceCacheEnabled=" + performanceCacheEnabled + ", "
        + "performanceCacheOptions=" + performanceCacheOptions + ", "
        + "cloudStorageOptions=" + cloudStorageOptions + ", "
        + "bucketDeleteEnabled=" + bucketDeleteEnabled + ", "
        + "markerFilePattern=" + markerFilePattern + ", "
        + "statusParallelEnabled=" + statusParallelEnabled + ", "
        + "cooperativeLockingEnabled=" + cooperativeLockingEnabled
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GoogleCloudStorageFileSystemOptions) {
      GoogleCloudStorageFileSystemOptions that = (GoogleCloudStorageFileSystemOptions) o;
      return this.performanceCacheEnabled == that.isPerformanceCacheEnabled()
          && this.performanceCacheOptions.equals(that.getPerformanceCacheOptions())
          && this.cloudStorageOptions.equals(that.getCloudStorageOptions())
          && this.bucketDeleteEnabled == that.isBucketDeleteEnabled()
          && (this.markerFilePattern == null ? that.getMarkerFilePattern() == null : this.markerFilePattern.equals(that.getMarkerFilePattern()))
          && this.statusParallelEnabled == that.isStatusParallelEnabled()
          && this.cooperativeLockingEnabled == that.isCooperativeLockingEnabled();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= performanceCacheEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= performanceCacheOptions.hashCode();
    h$ *= 1000003;
    h$ ^= cloudStorageOptions.hashCode();
    h$ *= 1000003;
    h$ ^= bucketDeleteEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (markerFilePattern == null) ? 0 : markerFilePattern.hashCode();
    h$ *= 1000003;
    h$ ^= statusParallelEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= cooperativeLockingEnabled ? 1231 : 1237;
    return h$;
  }

  @Override
  public GoogleCloudStorageFileSystemOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends GoogleCloudStorageFileSystemOptions.Builder {
    private Boolean performanceCacheEnabled;
    private PerformanceCachingGoogleCloudStorageOptions performanceCacheOptions;
    private GoogleCloudStorageOptions cloudStorageOptions;
    private Boolean bucketDeleteEnabled;
    private Pattern markerFilePattern;
    private Boolean statusParallelEnabled;
    private Boolean cooperativeLockingEnabled;
    Builder() {
    }
    private Builder(GoogleCloudStorageFileSystemOptions source) {
      this.performanceCacheEnabled = source.isPerformanceCacheEnabled();
      this.performanceCacheOptions = source.getPerformanceCacheOptions();
      this.cloudStorageOptions = source.getCloudStorageOptions();
      this.bucketDeleteEnabled = source.isBucketDeleteEnabled();
      this.markerFilePattern = source.getMarkerFilePattern();
      this.statusParallelEnabled = source.isStatusParallelEnabled();
      this.cooperativeLockingEnabled = source.isCooperativeLockingEnabled();
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setPerformanceCacheEnabled(boolean performanceCacheEnabled) {
      this.performanceCacheEnabled = performanceCacheEnabled;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setPerformanceCacheOptions(PerformanceCachingGoogleCloudStorageOptions performanceCacheOptions) {
      if (performanceCacheOptions == null) {
        throw new NullPointerException("Null performanceCacheOptions");
      }
      this.performanceCacheOptions = performanceCacheOptions;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setCloudStorageOptions(GoogleCloudStorageOptions cloudStorageOptions) {
      if (cloudStorageOptions == null) {
        throw new NullPointerException("Null cloudStorageOptions");
      }
      this.cloudStorageOptions = cloudStorageOptions;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setBucketDeleteEnabled(boolean bucketDeleteEnabled) {
      this.bucketDeleteEnabled = bucketDeleteEnabled;
      return this;
    }
    @Override
    GoogleCloudStorageFileSystemOptions.Builder setMarkerFilePattern(Pattern markerFilePattern) {
      this.markerFilePattern = markerFilePattern;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setStatusParallelEnabled(boolean statusParallelEnabled) {
      this.statusParallelEnabled = statusParallelEnabled;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setCooperativeLockingEnabled(boolean cooperativeLockingEnabled) {
      this.cooperativeLockingEnabled = cooperativeLockingEnabled;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions build() {
      String missing = "";
      if (this.performanceCacheEnabled == null) {
        missing += " performanceCacheEnabled";
      }
      if (this.performanceCacheOptions == null) {
        missing += " performanceCacheOptions";
      }
      if (this.cloudStorageOptions == null) {
        missing += " cloudStorageOptions";
      }
      if (this.bucketDeleteEnabled == null) {
        missing += " bucketDeleteEnabled";
      }
      if (this.statusParallelEnabled == null) {
        missing += " statusParallelEnabled";
      }
      if (this.cooperativeLockingEnabled == null) {
        missing += " cooperativeLockingEnabled";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GoogleCloudStorageFileSystemOptions(
          this.performanceCacheEnabled,
          this.performanceCacheOptions,
          this.cloudStorageOptions,
          this.bucketDeleteEnabled,
          this.markerFilePattern,
          this.statusParallelEnabled,
          this.cooperativeLockingEnabled);
    }
  }

}
