/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.state;

import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;

public final class DebugUtils {
    private DebugUtils() {
    }

    public static String duplicateMetricErrorMessage(MetricDescriptor existing, MetricDescriptor conflict) {
        StringBuilder result = new StringBuilder("Found duplicate metric definition: ");
        result.append(existing.getName()).append("\n");
        if (!conflict.getName().equals(conflict.getSourceInstrument().getName())) {
            result.append("\tVIEW defined\n").append(conflict.getViewSourceInfo().multiLineDebugString()).append("\tFROM instrument ").append(conflict.getSourceInstrument().getName()).append("\n").append(conflict.getSourceInstrument().getSourceInfo().multiLineDebugString());
        } else {
            result.append(conflict.getSourceInstrument().getSourceInfo().multiLineDebugString()).append("\n");
        }
        result.append("Causes\n");
        if (!existing.getName().equals(conflict.getName())) {
            result.append("- Name [").append(conflict.getName()).append("] does not match [").append(existing.getName()).append("]\n");
        }
        if (!existing.getDescription().equals(conflict.getDescription())) {
            result.append("- Description [").append(conflict.getDescription()).append("] does not match [").append(existing.getDescription()).append("]\n");
        }
        if (!existing.getAggregationName().equals(conflict.getAggregationName())) {
            result.append("- Aggregation [").append(conflict.getAggregationName()).append("] does not match [").append(existing.getAggregationName()).append("]\n");
        }
        if (!existing.getSourceInstrument().getName().equals(conflict.getSourceInstrument().getName())) {
            result.append("- InstrumentName [").append(conflict.getSourceInstrument().getName()).append("] does not match [").append(existing.getSourceInstrument().getName()).append("]\n");
        }
        if (!existing.getSourceInstrument().getDescription().equals(conflict.getSourceInstrument().getDescription())) {
            result.append("- InstrumentDescription [").append(conflict.getSourceInstrument().getDescription()).append("] does not match [").append(existing.getSourceInstrument().getDescription()).append("]\n");
        }
        if (!existing.getSourceInstrument().getUnit().equals(conflict.getSourceInstrument().getUnit())) {
            result.append("- InstrumentUnit [").append(conflict.getSourceInstrument().getUnit()).append("] does not match [").append(existing.getSourceInstrument().getUnit()).append("]\n");
        }
        if (!existing.getSourceInstrument().getType().equals((Object)conflict.getSourceInstrument().getType())) {
            result.append("- InstrumentType [").append((Object)conflict.getSourceInstrument().getType()).append("] does not match [").append((Object)existing.getSourceInstrument().getType()).append("]\n");
        }
        if (!existing.getSourceInstrument().getValueType().equals((Object)conflict.getSourceInstrument().getValueType())) {
            result.append("- InstrumentValueType [").append((Object)conflict.getSourceInstrument().getValueType()).append("] does not match [").append((Object)existing.getSourceInstrument().getValueType()).append("]\n");
        }
        if (existing.getName().equals(existing.getSourceInstrument().getName())) {
            result.append("Original instrument registered with same name but is incompatible.\n").append(existing.getSourceInstrument().getSourceInfo().multiLineDebugString()).append("\n");
        } else {
            result.append("Conflicting view registered.\n").append(existing.getViewSourceInfo().multiLineDebugString()).append("FROM instrument ").append(existing.getSourceInstrument().getName()).append("\n").append(existing.getSourceInstrument().getSourceInfo().multiLineDebugString()).append("\n");
        }
        return result.toString();
    }
}

