/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.unsafe;

import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Context;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.internal.Provider;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.ContextHandle;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.ContextManager;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.Span;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.unsafe.ContextHandleImpl;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.unsafe.ContextManagerImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class ContextHandleUtils {
    private static final Logger LOGGER = Logger.getLogger(ContextHandleUtils.class.getName());
    private static final ContextManager CONTEXT_MANAGER = ContextHandleUtils.loadContextManager(ContextManager.class.getClassLoader());

    private ContextHandleUtils() {
    }

    private static ContextManager loadContextManager(@Nullable ClassLoader classLoader) {
        try {
            return Provider.createInstance(Class.forName("com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.opencensusshim.OpenTelemetryContextManager", true, classLoader), ContextManager.class);
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.FINE, "Couldn't load full implementation for OpenTelemetry context manager, now loading original implementation.", e);
            return new ContextManagerImpl();
        }
    }

    public static ContextHandle currentContext() {
        return CONTEXT_MANAGER.currentContext();
    }

    public static ContextHandle withValue(ContextHandle context, @Nullable Span span) {
        return CONTEXT_MANAGER.withValue(context, span);
    }

    public static Span getValue(ContextHandle context) {
        return CONTEXT_MANAGER.getValue(context);
    }

    @Nullable
    public static Context tryExtractGrpcContext(ContextHandle handle) {
        if (handle instanceof ContextHandleImpl) {
            return ((ContextHandleImpl)handle).getContext();
        }
        return null;
    }
}

