/*
 * Decompiled with CFR 0.152.
 */
package com.google.capillary.android;

import android.app.KeyguardManager;
import android.content.Context;
import android.os.Build;
import com.google.capillary.AuthModeUnavailableException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;

class Utils {
    private static final String KEYSTORE_ANDROID = "AndroidKeyStore";
    private static Utils instance;

    private Utils() {
    }

    static synchronized Utils getInstance() {
        if (instance == null) {
            instance = new Utils();
        }
        return instance;
    }

    Context getDeviceProtectedStorageContext(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            return context.createDeviceProtectedStorageContext();
        }
        return context;
    }

    void checkAuthModeIsAvailable(Context context) throws AuthModeUnavailableException {
        boolean isScreenLockEnabled = this.isScreenLockEnabled(context);
        if (isScreenLockEnabled && !this.isScreenLocked(context)) {
            return;
        }
        if (!isScreenLockEnabled) {
            throw new AuthModeUnavailableException("the device is not secured with a PIN, pattern, or password");
        }
        throw new AuthModeUnavailableException("the device is locked");
    }

    private boolean isScreenLockEnabled(Context context) {
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        assert (keyguardManager != null);
        if (Build.VERSION.SDK_INT >= 23) {
            return keyguardManager.isDeviceSecure();
        }
        return keyguardManager.isKeyguardSecure();
    }

    boolean isScreenLocked(Context context) {
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        assert (keyguardManager != null);
        if (Build.VERSION.SDK_INT >= 23) {
            return keyguardManager.isDeviceLocked();
        }
        return keyguardManager.isKeyguardLocked();
    }

    KeyStore loadKeyStore() throws GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_ANDROID);
        try {
            keyStore.load(null);
        }
        catch (IOException e) {
            throw new GeneralSecurityException("unable to load keystore", e);
        }
        return keyStore;
    }
}

