/*
 * Decompiled with CFR 0.152.
 */
package com.google.capillary.android;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.VisibleForTesting;
import com.google.capillary.AuthModeUnavailableException;
import com.google.capillary.NoSuchKeyException;
import com.google.capillary.android.CapillaryHandler;
import com.google.capillary.android.CiphertextStorage;
import com.google.capillary.android.DecrypterManager;
import com.google.capillary.android.Utils;
import com.google.capillary.internal.CapillaryPublicKey;
import com.google.crypto.tink.HybridDecrypt;
import com.google.protobuf.ByteString;
import java.security.GeneralSecurityException;
import java.util.UUID;

public abstract class KeyManager {
    private static final String AUTH_KEY_SERIAL_NUMBER_KEY = "current_auth_key_serial_number";
    private static final String NO_AUTH_KEY_SERIAL_NUMBER_KEY = "current_no_auth_key_serial_number";
    private static final String KEYCHAIN_UNIQUE_ID_KEY = "keychain_unique_id";
    final Context context;
    final String keychainId;
    private final Utils utils;
    private final SharedPreferences sharedPreferences;
    private DecrypterManager decrypterManager;

    KeyManager(Context context, Utils utils, String keychainId) {
        this.context = context;
        this.utils = utils;
        this.keychainId = keychainId;
        Context storageContext = utils.getDeviceProtectedStorageContext(context);
        String prefName = String.format("%s_%s_preferences", this.getClass().getCanonicalName(), keychainId);
        this.sharedPreferences = storageContext.getSharedPreferences(prefName, 0);
    }

    public synchronized DecrypterManager getDecrypterManager() {
        if (this.decrypterManager == null) {
            CiphertextStorage ciphertextStorage = new CiphertextStorage(this.context, this.utils, this.keychainId);
            this.decrypterManager = new DecrypterManager(this.context, this, ciphertextStorage, this.utils);
        }
        return this.decrypterManager;
    }

    private static String toSerialNumberPrefKey(boolean isAuth) {
        return isAuth ? AUTH_KEY_SERIAL_NUMBER_KEY : NO_AUTH_KEY_SERIAL_NUMBER_KEY;
    }

    public void generateKeyPairs() throws GeneralSecurityException, AuthModeUnavailableException {
        this.generateKeyPair(false);
        this.generateKeyPair(true);
    }

    public synchronized void generateKeyPair(boolean isAuth) throws AuthModeUnavailableException, GeneralSecurityException {
        int currentSerialNumber = this.sharedPreferences.getInt(KeyManager.toSerialNumberPrefKey(isAuth), -1);
        this.generateKeyPair(currentSerialNumber + 1, isAuth);
    }

    synchronized boolean generateKeyPair(int newSerialNumber, boolean isAuth) throws AuthModeUnavailableException, GeneralSecurityException {
        int currentSerialNumber;
        if (isAuth) {
            this.utils.checkAuthModeIsAvailable(this.context);
        }
        if (newSerialNumber <= (currentSerialNumber = this.sharedPreferences.getInt(KeyManager.toSerialNumberPrefKey(isAuth), -1))) {
            return false;
        }
        this.rawGenerateKeyPair(isAuth);
        this.sharedPreferences.edit().putInt(KeyManager.toSerialNumberPrefKey(isAuth), newSerialNumber).apply();
        return true;
    }

    static String toKeyTypeString(boolean isAuth) {
        return isAuth ? "Auth" : "NoAuth";
    }

    private int checkAndGetSerialNumber(boolean isAuth) throws NoSuchKeyException {
        int currentSerialNumber = this.sharedPreferences.getInt(KeyManager.toSerialNumberPrefKey(isAuth), -1);
        if (currentSerialNumber == -1) {
            throw new NoSuchKeyException(KeyManager.toKeyTypeString(isAuth) + " key not initialized");
        }
        return currentSerialNumber;
    }

    abstract void rawGenerateKeyPair(boolean var1) throws GeneralSecurityException;

    public void getPublicKey(boolean isAuth, CapillaryHandler handler, Object extra) throws NoSuchKeyException, AuthModeUnavailableException, GeneralSecurityException {
        handler.handlePublicKey(isAuth, this.getPublicKey(isAuth), extra);
    }

    synchronized byte[] getPublicKey(boolean isAuth) throws NoSuchKeyException, AuthModeUnavailableException, GeneralSecurityException {
        if (isAuth) {
            this.utils.checkAuthModeIsAvailable(this.context);
        }
        int currentSerialNumber = this.checkAndGetSerialNumber(isAuth);
        return CapillaryPublicKey.newBuilder().setKeychainUniqueId(this.getKeychainUniqueId()).setSerialNumber(currentSerialNumber).setIsAuth(isAuth).setKeyBytes(ByteString.copyFrom((byte[])this.rawGetPublicKey(isAuth))).build().toByteArray();
    }

    @VisibleForTesting
    String getKeychainUniqueId() {
        String uniqueId = this.sharedPreferences.getString(KEYCHAIN_UNIQUE_ID_KEY, null);
        if (uniqueId == null) {
            uniqueId = UUID.randomUUID().toString();
            this.sharedPreferences.edit().putString(KEYCHAIN_UNIQUE_ID_KEY, uniqueId).apply();
        }
        return uniqueId;
    }

    abstract byte[] rawGetPublicKey(boolean var1) throws NoSuchKeyException, GeneralSecurityException;

    synchronized HybridDecrypt getDecrypter(String requestedUniqueId, int serialNumberInCiphertext, boolean isAuth) throws NoSuchKeyException, AuthModeUnavailableException, GeneralSecurityException {
        if (isAuth) {
            this.utils.checkAuthModeIsAvailable(this.context);
        }
        if (!this.getKeychainUniqueId().equals(requestedUniqueId)) {
            throw new NoSuchKeyException("keychain unique ID mismatch");
        }
        int serialNumberInPrefs = this.checkAndGetSerialNumber(isAuth);
        if (serialNumberInPrefs != serialNumberInCiphertext) {
            throw new NoSuchKeyException(KeyManager.toKeyTypeString(isAuth) + " key serial number invalid");
        }
        return this.rawGetDecrypter(isAuth);
    }

    abstract HybridDecrypt rawGetDecrypter(boolean var1) throws NoSuchKeyException, GeneralSecurityException;

    public void deleteKeyPair(boolean isAuth) throws NoSuchKeyException, AuthModeUnavailableException, GeneralSecurityException {
        if (isAuth) {
            this.utils.checkAuthModeIsAvailable(this.context);
        }
        this.checkAndGetSerialNumber(isAuth);
        this.rawDeleteKeyPair(isAuth);
    }

    abstract void rawDeleteKeyPair(boolean var1) throws NoSuchKeyException, GeneralSecurityException;
}

