/*
 * Decompiled with CFR 0.152.
 */
package com.google.capillary.android;

import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import com.google.capillary.NoSuchKeyException;
import com.google.capillary.RsaEcdsaConstants;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import javax.security.auth.x500.X500Principal;
import org.joda.time.LocalDate;

final class AndroidKeyStoreRsaUtils {
    private static final String AUTH_KEY_ALIAS_SUFFIX = "_capillary_rsa_auth";
    private static final String NO_AUTH_KEY_ALIAS_SUFFIX = "_capillary_rsa_no_auth";
    private static final String KEYSTORE_ANDROID = "AndroidKeyStore";
    private static final int KEY_SIZE = 2048;
    private static final int KEY_DURATION_YEARS = 100;
    private static final int UNLOCK_DURATION_SECONDS = 3600;

    AndroidKeyStoreRsaUtils() {
    }

    static void generateKeyPair(Context context, String keychainId, boolean isAuth) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyGenParameterSpec spec;
        String keyAlias = AndroidKeyStoreRsaUtils.toKeyAlias(keychainId, isAuth);
        RSAKeyGenParameterSpec rsaSpec = new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4);
        if (Build.VERSION.SDK_INT >= 23) {
            KeyGenParameterSpec.Builder specBuilder = new KeyGenParameterSpec.Builder(keyAlias, 2).setAlgorithmParameterSpec((AlgorithmParameterSpec)rsaSpec).setDigests(new String[]{"SHA-256"}).setEncryptionPaddings(new String[]{"OAEPPadding"});
            if (isAuth) {
                specBuilder.setUserAuthenticationRequired(true);
                specBuilder.setUserAuthenticationValidityDurationSeconds(3600);
            }
            spec = specBuilder.build();
        } else {
            LocalDate startDate = LocalDate.now();
            LocalDate endDate = startDate.plusYears(100);
            KeyPairGeneratorSpec.Builder specBuilder = new KeyPairGeneratorSpec.Builder(context).setAlias(keyAlias).setSubject(new X500Principal("CN=" + keyAlias)).setSerialNumber(BigInteger.ONE).setStartDate(startDate.toDate()).setEndDate(endDate.toDate());
            if (Build.VERSION.SDK_INT >= 19) {
                specBuilder.setAlgorithmParameterSpec((AlgorithmParameterSpec)rsaSpec);
                specBuilder.setKeySize(2048);
            }
            if (isAuth) {
                specBuilder.setEncryptionRequired();
            }
            spec = specBuilder.build();
        }
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", KEYSTORE_ANDROID);
        keyPairGenerator.initialize((AlgorithmParameterSpec)spec);
        keyPairGenerator.generateKeyPair();
    }

    static PublicKey getPublicKey(KeyStore keyStore, String keychainId, boolean isAuth) throws NoSuchKeyException, KeyStoreException {
        String alias = AndroidKeyStoreRsaUtils.toKeyAlias(keychainId, isAuth);
        AndroidKeyStoreRsaUtils.checkKeyExists(keyStore, alias);
        return keyStore.getCertificate(alias).getPublicKey();
    }

    static PrivateKey getPrivateKey(KeyStore keyStore, String keychainId, boolean isAuth) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, NoSuchKeyException {
        String alias = AndroidKeyStoreRsaUtils.toKeyAlias(keychainId, isAuth);
        AndroidKeyStoreRsaUtils.checkKeyExists(keyStore, alias);
        return (PrivateKey)keyStore.getKey(alias, null);
    }

    static void deleteKeyPair(KeyStore keyStore, String keychainId, boolean isAuth) throws NoSuchKeyException, KeyStoreException {
        String alias = AndroidKeyStoreRsaUtils.toKeyAlias(keychainId, isAuth);
        AndroidKeyStoreRsaUtils.checkKeyExists(keyStore, alias);
        keyStore.deleteEntry(alias);
    }

    private static String toKeyAlias(String keychainId, boolean isAuth) {
        String suffix = isAuth ? AUTH_KEY_ALIAS_SUFFIX : NO_AUTH_KEY_ALIAS_SUFFIX;
        return keychainId + suffix;
    }

    static void checkKeyExists(KeyStore keyStore, String keychainId, boolean isAuth) throws NoSuchKeyException, KeyStoreException {
        AndroidKeyStoreRsaUtils.checkKeyExists(keyStore, AndroidKeyStoreRsaUtils.toKeyAlias(keychainId, isAuth));
    }

    private static void checkKeyExists(KeyStore keyStore, String alias) throws NoSuchKeyException, KeyStoreException {
        if (!keyStore.containsAlias(alias)) {
            throw new NoSuchKeyException("android key store has no rsa key pair with alias " + alias);
        }
    }

    static RsaEcdsaConstants.Padding getCompatibleRsaPadding() {
        return Build.VERSION.SDK_INT >= 23 ? RsaEcdsaConstants.Padding.OAEP : RsaEcdsaConstants.Padding.PKCS1;
    }
}

