/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google;
import autovalue.shaded.com.google$.auto.common.$AnnotationMirrors;
import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.auto.common.$MoreTypes;
import autovalue.shaded.com.google$.auto.common.$Visibility;
import autovalue.shaded.com.google$.common.base.$Ascii;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import autovalue.shaded.net.ltgt.gradle.incap;
import com.google.auto.value.processor.AutoBuilderTemplateVars;
import com.google.auto.value.processor.AutoValueishProcessor;
import com.google.auto.value.processor.BuilderMethodClassifier;
import com.google.auto.value.processor.BuilderMethodClassifierForAutoBuilder;
import com.google.auto.value.processor.BuilderSpec;
import com.google.auto.value.processor.MissingTypes;
import com.google.auto.value.processor.Reformatter;
import com.google.auto.value.processor.TypeEncoder;
import com.google.auto.value.processor.TypeSimplifier;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

@SupportedAnnotationTypes(value={"com.google.auto.value.AutoBuilder"})
@google..AutoService(value={Processor.class})
@incap..IncrementalAnnotationProcessor(value=incap..IncrementalAnnotationProcessorType.ISOLATING)
public class AutoBuilderProcessor
extends AutoValueishProcessor {
    private static final String ALLOW_OPTION = "com.google.auto.value.AutoBuilderIsUnstable";
    private TypeMirror javaLangVoid;
    private static final ElementKind ELEMENT_KIND_RECORD = AutoBuilderProcessor.elementKindRecord();

    public AutoBuilderProcessor() {
        super("com.google.auto.value.AutoBuilder");
    }

    @Override
    public Set<String> getSupportedOptions() {
        return $ImmutableSet.of("com.google.auto.value.OmitIdentifiers", ALLOW_OPTION);
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.javaLangVoid = this.elementUtils().getTypeElement("java.lang.Void").asType();
    }

    @Override
    void processType(TypeElement autoBuilderType) {
        BuilderSpec builderSpec;
        if (!this.processingEnv.getOptions().containsKey(ALLOW_OPTION)) {
            this.errorReporter().abortWithError(autoBuilderType, "Compile with -A%s to enable this UNSUPPORTED AND UNSTABLE prototype", ALLOW_OPTION);
        }
        if (autoBuilderType.getKind() != ElementKind.CLASS && autoBuilderType.getKind() != ElementKind.INTERFACE) {
            this.errorReporter().abortWithError(autoBuilderType, "[AutoBuilderWrongType] @AutoBuilder only applies to classes and interfaces", new Object[0]);
        }
        this.checkModifiersIfNested(autoBuilderType);
        TypeElement constructedType = this.findConstructedType(autoBuilderType);
        this.checkModifiersIfNested(constructedType);
        ExecutableElement constructor = this.findConstructor(constructedType, autoBuilderType);
        BuilderSpec builderSpec2 = builderSpec = new BuilderSpec(constructedType, this.processingEnv, this.errorReporter());
        builderSpec2.getClass();
        BuilderSpec.Builder builder = builderSpec2.new BuilderSpec.Builder(autoBuilderType);
        $ImmutableSet<ExecutableElement> methods = AutoBuilderProcessor.abstractMethodsIn($MoreElements.getLocalAndInheritedMethods(autoBuilderType, this.typeUtils(), this.elementUtils()));
        Optional<BuilderMethodClassifier<VariableElement>> classifier = BuilderMethodClassifierForAutoBuilder.classify(methods, this.errorReporter(), this.processingEnv, constructor, constructedType, autoBuilderType);
        if (!classifier.isPresent()) {
            return;
        }
        AutoBuilderTemplateVars vars = new AutoBuilderTemplateVars();
        vars.props = this.propertySet(constructor);
        builder.defineVars(vars, classifier.get());
        vars.identifiers = !this.processingEnv.getOptions().containsKey("com.google.auto.value.OmitIdentifiers");
        String generatedClassName = AutoBuilderProcessor.generatedClassName(autoBuilderType, "AutoBuilder_");
        vars.builderName = TypeSimplifier.simpleNameOf(generatedClassName);
        vars.builtClass = TypeEncoder.encodeRaw(constructedType.asType());
        vars.types = this.typeUtils();
        vars.toBuilderConstructor = false;
        this.defineSharedVarsForType(constructedType, $ImmutableSet.of(), vars);
        String text = vars.toText();
        text = TypeEncoder.decode(text, this.processingEnv, vars.pkg, autoBuilderType.asType());
        text = Reformatter.fixup(text);
        this.writeSourceFile(generatedClassName, text, autoBuilderType);
    }

    private $ImmutableSet<AutoValueishProcessor.Property> propertySet(ExecutableElement constructor) {
        return constructor.getParameters().stream().map(this::newProperty).collect($ImmutableSet.toImmutableSet());
    }

    private AutoValueishProcessor.Property newProperty(VariableElement var) {
        String name = var.getSimpleName().toString();
        TypeMirror type = var.asType();
        return new AutoValueishProcessor.Property(name, name, TypeEncoder.encode(type), type, Optional.empty());
    }

    private ExecutableElement findConstructor(TypeElement constructedType, TypeElement autoBuilderType) {
        $ImmutableList<ExecutableElement> constructors = this.visibleConstructors(constructedType, autoBuilderType);
        $ImmutableList<ExecutableElement> maxConstructors = this.maxConstructors(constructors);
        if (maxConstructors.size() > 1) {
            this.errorReporter().abortWithError(autoBuilderType, "[AutoBuilderNoMaxConstructor] @AutoBuilder constructed type %s must have one visible constructor with more parameters than any other, but there are %d constructors with %d parameters", constructedType, maxConstructors.size(), ((ExecutableElement)maxConstructors.get(0)).getParameters().size());
        }
        return (ExecutableElement)maxConstructors.get(0);
    }

    private $ImmutableList<ExecutableElement> visibleConstructors(TypeElement constructedType, TypeElement autoBuilderType) {
        $ImmutableList<ExecutableElement> constructors = ElementFilter.constructorsIn(constructedType.getEnclosedElements()).stream().filter(c -> this.visibleFrom((Element)c, $MoreElements.getPackage(autoBuilderType))).collect($ImmutableList.toImmutableList());
        if (constructors.isEmpty()) {
            this.errorReporter().abortWithError(autoBuilderType, "[AutoBuilderNoConstructor] No visible constructors for %s", constructedType);
        }
        return constructors;
    }

    private $ImmutableList<ExecutableElement> maxConstructors(List<ExecutableElement> constructors) {
        int maxParams = constructors.stream().mapToInt(c -> c.getParameters().size()).max().getAsInt();
        return constructors.stream().filter(c -> c.getParameters().size() == maxParams).collect($ImmutableList.toImmutableList());
    }

    private boolean visibleFrom(Element element, PackageElement fromPackage) {
        $Visibility visibility = $Visibility.effectiveVisibilityOfElement(element);
        switch (visibility) {
            case PUBLIC: {
                return true;
            }
            case PROTECTED: 
            case DEFAULT: {
                return $MoreElements.getPackage(element).equals(fromPackage);
            }
        }
        return false;
    }

    private static ElementKind elementKindRecord() {
        try {
            Field record = ElementKind.class.getField("RECORD");
            return (ElementKind)((Object)record.get(null));
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    private TypeElement findConstructedType(TypeElement autoBuilderType) {
        TypeElement ofClassValue = this.findOfClassValue(autoBuilderType);
        boolean isDefault = this.typeUtils().isSameType(ofClassValue.asType(), this.javaLangVoid);
        if (!isDefault) {
            return ofClassValue;
        }
        Element enclosing = autoBuilderType.getEnclosingElement();
        ElementKind enclosingKind = enclosing.getKind();
        if (enclosing.getKind() != ElementKind.CLASS && enclosingKind != ELEMENT_KIND_RECORD) {
            this.errorReporter().abortWithError(autoBuilderType, "[AutoBuilderEnclosing] @AutoBuilder must specify ofClass=Something.class or it must be nested inside the class to be built; actually nested inside %s %s.", $Ascii.toLowerCase(enclosingKind.name()), enclosing);
        }
        return $MoreElements.asType(enclosing);
    }

    private TypeElement findOfClassValue(TypeElement autoBuilderType) {
        AnnotationMirror autoBuilderAnnotation = AutoBuilderProcessor.getAnnotationMirror(autoBuilderType, "com.google.auto.value.AutoBuilder").get();
        AnnotationValue ofClassValue = $AnnotationMirrors.getAnnotationValue(autoBuilderAnnotation, "ofClass");
        Object value = ofClassValue.getValue();
        if (value instanceof TypeMirror) {
            TypeMirror ofClassType = (TypeMirror)value;
            switch (ofClassType.getKind()) {
                case DECLARED: {
                    return $MoreTypes.asTypeElement(ofClassType);
                }
                case ERROR: {
                    throw new MissingTypes.MissingTypeException($MoreTypes.asError(ofClassType));
                }
            }
        }
        throw new MissingTypes.MissingTypeException(null);
    }

    @Override
    Optional<String> nullableAnnotationForMethod(ExecutableElement propertyMethod) {
        return Optional.empty();
    }
}

