/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

final class TypeSimplifier {
    private final Types typeUtil;
    private final Map<String, Spelling> imports;

    TypeSimplifier(Types typeUtil, String packageName, Set<TypeMirror> types) {
        this.typeUtil = typeUtil;
        Set<TypeMirror> referenced = TypeSimplifier.referencedClassTypes(typeUtil, types);
        this.imports = TypeSimplifier.findImports(typeUtil, packageName, referenced);
    }

    SortedSet<String> typesToImport() {
        TreeSet<String> typesToImport = new TreeSet<String>();
        for (Map.Entry<String, Spelling> entry : this.imports.entrySet()) {
            if (!entry.getValue().importIt) continue;
            typesToImport.add(entry.getKey());
        }
        return typesToImport;
    }

    String simplify(TypeMirror type) {
        return type.accept(new ToStringTypeVisitor(), new StringBuilder()).toString();
    }

    static String packageNameOf(TypeElement type) {
        Element enclosing;
        while (!((enclosing = type.getEnclosingElement()) instanceof PackageElement)) {
            type = (TypeElement)enclosing;
        }
        return ((PackageElement)enclosing).getQualifiedName().toString();
    }

    private static Map<String, Spelling> findImports(Types typeUtil, String packageName, Set<TypeMirror> referenced) {
        HashMap<String, Spelling> imports = new HashMap<String, Spelling>();
        Set<String> ambiguous = TypeSimplifier.ambiguousNames(typeUtil, referenced);
        for (TypeMirror type : referenced) {
            String spelling;
            boolean importIt;
            TypeElement typeElement = (TypeElement)typeUtil.asElement(type);
            String fullName = typeElement.getQualifiedName().toString();
            String simpleName = typeElement.getSimpleName().toString();
            String pkg = TypeSimplifier.packageNameOf(typeElement);
            if (ambiguous.contains(simpleName)) {
                importIt = false;
                spelling = fullName;
            } else if (pkg.equals(packageName) || pkg.equals("java.lang")) {
                importIt = false;
                spelling = fullName.substring(pkg.isEmpty() ? 0 : pkg.length() + 1);
            } else {
                importIt = true;
                spelling = simpleName;
            }
            imports.put(fullName, new Spelling(spelling, importIt));
        }
        return imports;
    }

    private static Set<TypeMirror> referencedClassTypes(Types typeUtil, Set<TypeMirror> types) {
        HashSet<TypeMirror> referenced = new HashSet<TypeMirror>();
        ReferencedClassTypeVisitor typeVisitor = new ReferencedClassTypeVisitor(typeUtil, referenced);
        for (TypeMirror type : types) {
            type.accept(typeVisitor, null);
        }
        return referenced;
    }

    private static Set<String> ambiguousNames(Types typeUtil, Set<TypeMirror> types) {
        HashSet<String> ambiguous = new HashSet<String>();
        HashSet<String> simpleNames = new HashSet<String>();
        for (TypeMirror type : types) {
            String simpleName = typeUtil.asElement(type).getSimpleName().toString();
            if (simpleNames.add(simpleName)) continue;
            ambiguous.add(simpleName);
        }
        return ambiguous;
    }

    private static class ReferencedClassTypeVisitor
    extends SimpleTypeVisitor6<Void, Void> {
        private final Types typeUtil;
        private final Set<TypeMirror> referenced;

        ReferencedClassTypeVisitor(Types typeUtil, Set<TypeMirror> referenced) {
            this.typeUtil = typeUtil;
            this.referenced = referenced;
        }

        @Override
        public Void visitArray(ArrayType t, Void p) {
            return (Void)this.visit(t.getComponentType(), p);
        }

        @Override
        public Void visitDeclared(DeclaredType t, Void p) {
            this.referenced.add(this.typeUtil.erasure(t));
            for (TypeMirror typeMirror : t.getTypeArguments()) {
                this.visit(typeMirror, p);
            }
            return null;
        }

        @Override
        public Void visitTypeVariable(TypeVariable t, Void p) {
            this.visit(t.getLowerBound(), p);
            return (Void)this.visit(t.getUpperBound(), p);
        }

        @Override
        public Void visitWildcard(WildcardType t, Void p) {
            for (TypeMirror bound : new TypeMirror[]{t.getSuperBound(), t.getExtendsBound()}) {
                if (bound == null) continue;
                this.visit(bound, p);
            }
            return null;
        }
    }

    private class ToStringTypeVisitor
    extends SimpleTypeVisitor6<StringBuilder, StringBuilder> {
        private ToStringTypeVisitor() {
        }

        @Override
        protected StringBuilder defaultAction(TypeMirror type, StringBuilder sb) {
            return sb.append(type);
        }

        @Override
        public StringBuilder visitArray(ArrayType type, StringBuilder sb) {
            return ((StringBuilder)this.visit(type.getComponentType(), sb)).append("[]");
        }

        @Override
        public StringBuilder visitDeclared(DeclaredType type, StringBuilder sb) {
            TypeElement typeElement = (TypeElement)TypeSimplifier.this.typeUtil.asElement(type);
            String typeString = typeElement.getQualifiedName().toString();
            if (TypeSimplifier.this.imports.containsKey(typeString)) {
                sb.append(((Spelling)((TypeSimplifier)TypeSimplifier.this).imports.get((Object)typeString)).spelling);
            } else {
                sb.append(typeString);
            }
            List<? extends TypeMirror> arguments = type.getTypeArguments();
            if (!arguments.isEmpty()) {
                sb.append("<");
                String sep = "";
                for (TypeMirror typeMirror : arguments) {
                    sb.append(sep);
                    sep = ", ";
                    this.visit(typeMirror, sb);
                }
                sb.append(">");
            }
            return sb;
        }

        @Override
        public StringBuilder visitWildcard(WildcardType type, StringBuilder sb) {
            sb.append("?");
            TypeMirror extendsBound = type.getExtendsBound();
            TypeMirror superBound = type.getSuperBound();
            if (superBound != null) {
                sb.append(" super ");
                this.visit(superBound, sb);
            } else if (extendsBound != null) {
                sb.append(" extends ");
                this.visit(extendsBound, sb);
            }
            return sb;
        }
    }

    private static class Spelling {
        final String spelling;
        final boolean importIt;

        Spelling(String spelling, boolean importIt) {
            this.spelling = spelling;
            this.importIt = importIt;
        }
    }
}

